# -*- coding: utf-8 -*-

"""
/***************************************************************************
 ZumBox
                                 A QGIS plugin
 Urban planning related tools
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-02-07
        copyright            : (C) 2024 by Matjaž Mori, ZUM d.o.o.
        email                : matjaz.mori@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Matjaž Mori, ZUM d.o.o.'
__date__ = '2024-02-07'
__copyright__ = '(C) 2024 by Matjaž Mori, ZUM d.o.o.'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessingParameterFile,
                       QgsProcessingAlgorithm,
                       QgsProject,
                       QgsVectorLayer,
                       QgsRasterLayer)
import os
import chardet

class ImportWorAlgorithm(QgsProcessingAlgorithm):
    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    INPUT = 'wor_file'

    def initAlgorithm(self, config):

        self.addParameter(
            QgsProcessingParameterFile(
                'wor_file', 
                self.tr('.WOR datoteka'), 
                behavior=QgsProcessingParameterFile.File, 
                fileFilter='WOR datoteke (*.WOR *.wor)', 
                defaultValue=None
            )
        )



    def processAlgorithm(self, parameters, context, feedback):
        
        # Function to load .tab files into QGIS
        def load_tab_files_into_qgis(input_wor_content, wor_file_path, qgis_project, group):
            wor_directory = os.path.dirname(wor_file_path)
            
            total_tables = 0
            successful_loads = 0
            unsuccessful_loads_info = []  # List to store information about unsuccessful loads

            for line in input_wor_content.splitlines():
                # Check if the algorithm was cancelled by the user
                if feedback.isCanceled():
                    break
                # Check if the line contains a reference to a .tab file
                if line.strip().startswith("Open Table"):
                    total_tables += 1
                    parts = line.split('"')
                    if len(parts) >= 3:
                        original_tab_file_path = parts[1]  # Original file path
                        tab_file_path = original_tab_file_path

                        # Append .tab extension if not present
                        if not tab_file_path.lower().endswith('.tab'):
                            tab_file_path += '.tab'

                        # Check if the path is absolute, otherwise make it relative to the .wor file
                        if not os.path.isabs(tab_file_path):
                            tab_file_path = os.path.join(wor_directory, tab_file_path)

                        # Use file name as the layer name
                        layer_name = os.path.splitext(os.path.basename(tab_file_path))[0]

                        if os.path.exists(tab_file_path):
                            raster_path = read_tab_file(tab_file_path)
                            layer = QgsVectorLayer(tab_file_path, layer_name, "ogr")
                            if layer.isValid():
                                qgis_project.addMapLayer(layer, False) 
                                group.addLayer(layer)
                                successful_loads += 1
                            else:
                                try:
                                    layer = QgsRasterLayer(raster_path, layer_name)
                                except Exception as e:
                                    feedback.reportError(self.tr(f"Error creating QgsRasterLayer: {e}"))
                                    unsuccessful_loads_info.append((line, tab_file_path))
                                if layer.isValid():                                
                                    tab_file_path = raster_path
                                    qgis_project.addMapLayer(layer, False) 
                                    group.addLayer(layer)
                                    successful_loads += 1
                                else:                        
                                    unsuccessful_loads_info.append((line, tab_file_path))
                        else:
                            unsuccessful_loads_info.append((line, tab_file_path))

            # Print summary report
            feedback.pushInfo(self.tr(f"Skupno'Open Table' vrstic pregledanih: {total_tables}"))
            feedback.pushInfo(self.tr(f"Uspešno naloženih slojev: {successful_loads}"))
            if unsuccessful_loads_info:
                feedback.reportError(self.tr("Neuspešno nalaganje:"))
                for line, path in unsuccessful_loads_info:
                    feedback.reportError(self.tr(f"Vrstica: {line}\nPoskus nalaganja: {path}\n"))

        def read_tab_file(tab_file_path):
            directory = os.path.dirname(tab_file_path)
            try:
                # Open the file in binary mode and get a sample of the content
                with open(tab_file_path, 'rb') as file:
                    rawdata = file.read(10000)  # You may need to adjust the number of bytes read depending on your files
                # Detect the encoding
                result = chardet.detect(rawdata)
                encoding = result['encoding']
                # Open the file again in text mode with the detected encoding
                with open(tab_file_path, 'r', encoding=encoding) as file:
                    tab_content = file.read()
                    for line in tab_content.splitlines():
                        if line.strip().startswith('File'):
                            filename = line.split('"')[1].strip()
                            raster_file_path = os.path.join(directory, filename)
                            return raster_file_path
      
            except IOError as e:
                feedback.reportError(self.tr(f"Napaka pri branju .TAB datoteke: {e}"))
                return None
            except UnicodeDecodeError as e:
                feedback.reportError(self.tr(f"Napaka pri nastavitvi kodiranja ob branju .TAB datoteke: {e}"))
                return None


        # Function to read .wor file      
        def read_wor_file(wor_file_path):
            try:
                # Open the file in binary mode and get a sample of the content
                with open(wor_file_path, 'rb') as file:
                    rawdata = file.read(10000)  # You may need to adjust the number of bytes read depending on your files
                # Detect the encoding
                result = chardet.detect(rawdata)
                feedback.pushInfo(self.tr(str(result)))
                encoding = result['encoding']
                # Open the file again in text mode with the detected encoding
                with open(wor_file_path, 'r', encoding=encoding) as file:
                    return file.read()
            except IOError as e:
                feedback.reportError(self.tr(f"Napaka pri branju .WOR datoteke: {e}"))
                return None
            except UnicodeDecodeError as e:
                feedback.reportError(self.tr(f"Napaka pri nastavitvi kodiranja ob branju .WOR datoteke: {e}"))
                return None
                
 
        # Retrieve the input parameters
        wor_file_path = self.parameterAsFile(parameters, self.INPUT, context)
        feedback.pushInfo(self.tr('Berem WOR datoteko: {}'.format(wor_file_path)))

        # Read the .wor file
        input_wor_content = read_wor_file(wor_file_path)

        # Load .tab files into QGIS
        qgis_project = QgsProject.instance()
        root = qgis_project.layerTreeRoot()
        group_name = os.path.splitext(os.path.basename(wor_file_path))[0]
        group = root.addGroup(group_name)

        load_tab_files_into_qgis(input_wor_content, wor_file_path,  qgis_project, group)

        return {}   


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'import_mapinfo_wor'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Uvozi sloje iz Mapinfo .WOR')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return ImportWorAlgorithm()

    def shortHelpString(self):
        """
        Returns a localised short helper string for the algorithm. This string
        should provide a basic description about what the algorithm does and the
        parameters and outputs associated with it..
        """
        return self.tr("Orodje za uvoz slojev iz Mapinfo .WOR datoteke. Po uvozu je potrebna pazljivost pri nastavitvi koordinatnega sistema in kodiranja znakov posameznih slojev! neuspešno uvoženi skloji so navedeni v konzoli.")