# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TriTra
                                 A QGIS plugin
 Trikotniška transformacija za Republiko Slovenijo.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-06-19
        copyright            : (C) 2023 by Matjaž Mori
        email                : matjaz.mori@zum-mb.si
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Matjaž Mori'
__date__ = '2023-06-19'
__copyright__ = '(C) 2023 by Matjaž Mori'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFile,
                        QgsProcessingParameterMultipleLayers,
                        QgsProcessingParameterEnum,
                        QgsProcessingParameterBoolean,
                        QgsPoint,
                        QgsFeature, 
                        QgsFields)
from qgis.PyQt.QtCore import *
import processing
from pathlib import Path
import os
from qgis.core import *
import datetime 

class TriTraAlgorithm(QgsProcessingAlgorithm):
    OUTPUT_FOLDER = 'OUTPUT_FOLDER'
    INPUT = 'INPUT'
    TRANS = 'TRANS'

    def initAlgorithm(self, config):
        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
        QgsProcessingParameterMultipleLayers(
            self.INPUT,
            self.tr('Sloji za transformacijo'),
            optional=True,
            layerType=QgsProcessing.TypeVectorAnyGeometry
            )
        )

        # Add a parameter for transformation direction.
        self.addParameter(
            QgsProcessingParameterEnum(
                self.TRANS,  # Parameter id
                self.tr('Smer transformacije'),  # Parameter description
                options=['D48/GK->D96/TM','D96/TM->D48/GK'],  # The list of options for the parameter
                defaultValue=0  # Default value
            )
        )

        # Add a boolean parameter to fix geometries.
        self.addParameter(
            QgsProcessingParameterBoolean(
                'popravi_geometrije',  # Parameter id
                self.tr('Popravi geometrije sloja'),  # Parameter description
                defaultValue=False  # Default value
            )
        )


        # Add a boolean parameter to fix geometries.
        self.addParameter(
            QgsProcessingParameterBoolean(
                'load_layers',  # Parameter id
                self.tr('Naloži sloje v projekt'),  # Parameter description
                defaultValue=False # Default value
            )
        )


        self.addParameter(
            QgsProcessingParameterFile(
                self.OUTPUT_FOLDER,
                self.tr('Ciljna mapa'),
                optional=True,
                behavior=QgsProcessingParameterFile.Folder,
                fileFilter='All files (*.*)'
            )
        )


    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        input_layers = self.parameterAsLayerList(parameters, self.INPUT, context)
        output_folder = self.parameterAsFile(parameters, self.OUTPUT_FOLDER, context)
        #0 = GK2TM,  1 = tm2GK
        trans_type = self.parameterAsEnum(parameters,self.TRANS,context)
  
        self.plugin_dir = os.path.dirname(__file__)
        params_path = os.path.join(
            self.plugin_dir,
            'params')

        if trans_type == 1:
            trans = 'TM2GK'
            file_prm = params_path + '\\TM2GK_PRM4.csv'
            file_vvt = params_path + '\\TM2GK_VVT4.csv'
            crs = QgsCoordinateReferenceSystem('EPSG:3912') 
        else:   
            trans = 'GK2TM' 
            file_prm = params_path + '\\GK2TM_PRM4.csv'
            file_vvt =  params_path + '\\GK2TM_VVT4.csv'
            crs = QgsCoordinateReferenceSystem('EPSG:3794') 


        # This function performs the coordinate transformation based on the given triangle and input coordinates
        def transf(triangle, e, n):
            eTM = float(triangle['a']) + float(triangle['b']) * float(e) + float(triangle['c']) * float(n)
            nTM = float(triangle['d']) + float(triangle['e']) * float(e) + float(triangle['f']) * float(n)
            trans_coor = [eTM, nTM]
            return trans_coor

        # This function reads the triangle coordinates from the given CSV files and creates QgsFeature objects
        def get_triangles(file_prm, file_vvt):
            coordinates = {}
            fields = QgsFields()
            fields.append(QgsField('a', QVariant.Double))
            fields.append(QgsField('b', QVariant.Double))
            fields.append(QgsField('c', QVariant.Double))
            fields.append(QgsField('d', QVariant.Double))
            fields.append(QgsField('e', QVariant.Double))
            fields.append(QgsField('f', QVariant.Double))

            with open(file_vvt, 'r') as file_vvt_lines:
                for line in file_vvt_lines:
                    data = line.strip().split()
                    coordinates[data[0]] = (data[1], data[2])

            with open(file_prm, 'r') as file_prm_lines:
                triangle_container = []

                for cur, line in enumerate(file_prm_lines):
                    row = line.strip().split()

                    point_f = coordinates.get(row[0], ('', ''))
                    point_s = coordinates.get(row[1], ('', ''))
                    point_t = coordinates.get(row[2], ('', ''))

                    fet = QgsFeature()
                    geometry = QgsGeometry.fromPolygonXY([[QgsPointXY(float(point_f[0]), float(point_f[1])),
                                                           QgsPointXY(float(point_s[0]), float(point_s[1])),
                                                           QgsPointXY(float(point_t[0]), float(point_t[1])),
                                                           QgsPointXY(float(point_f[0]), float(point_f[1]))]])
                    fet.setFields(fields)
                    fet.setGeometry(geometry)
                    fet.setAttribute('a', row[3])
                    fet.setAttribute('b', row[4])
                    fet.setAttribute('c', row[5])
                    fet.setAttribute('d', row[6])
                    fet.setAttribute('e', row[7])
                    fet.setAttribute('f', row[8])
                    triangle_container.append(fet)
            return triangle_container
                  

        def transform_poygons(input_layer, triangles):
            #tri_index = QgsSpatialIndex(triangles, flags=QgsSpatialIndex.FlagStoreFeatureGeometries)
            tri_index = triangles    
            for current, poly_feature in enumerate(input_layer.getFeatures()):
                feedback.setProgress(int(current * total))
                for fid in tri_index:
                    triangle_geom = fid.geometry()
                    if poly_feature.geometry().intersects(triangle_geom): 
                        vertices = poly_feature.geometry().vertices()
                        for cur, vertex in enumerate(vertices):  
                            if feedback.isCanceled():
                                return {}
                            point_geometry = QgsGeometry.fromPointXY(QgsPointXY(vertex.x(),vertex.y()))
                            if triangle_geom.intersects(point_geometry): 
                                trans_coord = transf(fid, vertex.x(), vertex.y())
                                input_layer.moveVertexV2(QgsPoint(trans_coord[0], trans_coord[1]), poly_feature.id(), cur)
   
        for input_layer in input_layers:
            feedback.pushDebugInfo(self.tr('Pretvarjam sloj: ') + input_layer.name())
            feedback.pushDebugInfo(self.tr('Vir sloja: ') + str(input_layer.source()))
            old_metadata = input_layer.metadata()


            layer_source_list = input_layer.source().split('|')              
            layer_source = Path(layer_source_list[0])

            source_folder = layer_source.parents[0]     
            extension = layer_source.suffix
          
            if trans_type == 0:
                file_name = str(layer_source.stem) + '_96TM'
            else:
                file_name = str(layer_source.stem) + '_48GK'
            
            if output_folder:
                out_folder = Path(output_folder)
            else:
                out_folder = source_folder

            feedback.pushDebugInfo(str(len(layer_source_list)))
            if len(layer_source_list) >= 2:
                if layer_source_list[1][:9] == 'layername':
                    out_layer_name = layer_source_list[1].split('=')[1]
                    if trans_type == 0:
                        out_layer_name = out_layer_name + '_96TM'
                    else:
                        out_layer_name = out_layer_name + '_48GK'
            else:
                out_layer_name = file_name



            output_layer = out_folder/(out_layer_name + str(extension))
            counter = 1

            while output_layer.exists():
                f_name = out_layer_name + '_' + str(counter)
                output_layer = out_folder/(f_name + str(extension))
                counter += 1
                file_name = f_name

  
            if self.parameterAsBool(parameters, 'popravi_geometrije', context):
                temp_layer = processing.run("native:fixgeometries", {
                    'INPUT': input_layer,
                    'OUTPUT': 'memory:'
                    },context=context)['OUTPUT']
            else:
                input_layer.selectAll()
                temp_layer = processing.run("native:saveselectedfeatures", {
                'INPUT': input_layer,
                'OUTPUT': 'memory:'
                },context=context)['OUTPUT']
                input_layer.removeSelection()

            total = 100.0 / input_layer.featureCount() if input_layer.featureCount()>0 else 0
      

            temp_layer.startEditing()     
            triangles = get_triangles(file_prm, file_vvt)
            transform_poygons(temp_layer, triangles)
            temp_layer.commitChanges()
            temp_layer.setCrs(crs)
          
            def update_history_metadata(layer, old_metadata):
                layer.startEditing()
                
                now = datetime.datetime.now()
                processing_step = self.tr(f'q3tra transformacija {trans}.')
    
                new_history = f'{now}:{processing_step}' 
                old_metadata.addHistoryItem(new_history)
                layer.setMetadata(old_metadata)

                layer.commitChanges()
 

            def write_layer_to_file():
                transform_context = QgsProject.instance().transformContext()
                options = QgsVectorFileWriter.SaveVectorOptions()
                options.driverName = input_layer.dataProvider().storageType()
                options.fileEncoding = input_layer.dataProvider().encoding()
                options.layerMetadata = temp_layer.metadata()
                options.saveMetadata = True
                options.crs = crs
                QgsVectorFileWriter.writeAsVectorFormatV3(temp_layer, str(output_layer), transform_context, options)
                

            try:
                update_history_metadata(temp_layer, old_metadata)

                write_layer_to_file()
                if self.parameterAsBool(parameters, 'load_layers', context):
                    layer = QgsVectorLayer(str(output_layer), out_layer_name, 'ogr')
                    QgsProject.instance().addMapLayer(layer)
                feedback.pushInfo(self.tr(f'Sloj uspešno pretvorjen in shranjen: {output_layer}.'))
            except Exception as e:
                feedback.reportError(self.tr('Napaka pri zapisu sloja: ') + str(e))
                return {}
           
        #open output folder
        if output_folder:
            feedback.pushInfo(self.tr('Pretvorba končana, sloji so shranjeni v: ') + str(output_folder))
            os.startfile(output_folder)
        else:    
            feedback.pushInfo(self.tr('Pretvorba končana, sloji so shranjeni v mapah z orignalnimi sloji:'))
            for layer in input_layers:
                feedback.pushInfo(str(layer.source()))
     

        
        return {}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'q3tra'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def shortHelpString(self):
        help_text = self.tr("""Orodje za transformacijo koordinat is D48/GK v D96/TM in obratno. 
        Reultat transformacije je nov sloj s pripono _96TM ali _48GK, odvisno od smeri transformacije. Če ne izberete ciljne mape, se sloji shranijo v mapo izvorne datoteke.
        Z opcijo "Popravi geometrije sloja", pred transformacijo požene orodje za popravo geometrij (Fix geometries). Metapodatki sloja se ohranijo.
        
                        
        Algoritem uporablja vsedržavni model trikotniške transformacije, različico transformacijskega modela 4.0 (29.5.2017). 
        Za vsako točko oz. lom vhodnega sloja se poišče trikotnik, v katerem se nahaja in s parametri za ta trikotnik izračuna nove koordinate po formuli:
        e = a + b * y + c * x
        n = d + e * y + f * x
        oz.
        y = a + b * e + c * n
        x = d + e * e + f * n

        Vir transformacijskega modela in več informacij o transformaciji:
        https://www.e-prostor.gov.si/podrocja/drzavni-koordinatni-sistem/drugo/razno/transformacija-v-novi-koordinatni-sistem/?acitem=1407-1411
         """)
        return self.tr(help_text)

    def createInstance(self):
        return TriTraAlgorithm()
