from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *
from qgis.gui import *
from qgis.core import *

debug = not True

class ZvMapTool(QgsMapTool):

    sigPointChanged = pyqtSignal(QgsPointXY)

    def __init__(self, zoomCanvas, mapCanvas):
        assert isinstance(zoomCanvas, QgsMapCanvas)
        QgsMapTool.__init__(self, zoomCanvas)

        self._mapCanvas = mapCanvas
        self._cursor = QCursor(Qt.CrossCursor)
        self._point = QgsPointXY(0, 0)

        # init map canvas items
        self._crosshairItem = QgsVertexMarker(mapCanvas=zoomCanvas)
        self._crosshairItem.setColor(QColor(255, 0, 0))
        self._crosshairItem.setIconSize(31)
        self._crosshairItem.setIconType(QgsVertexMarker.ICON_CROSS)
        self._crosshairItem.setPenWidth(1)

        self._rectangleItem = QgsRubberBand(mapCanvas=mapCanvas, geometryType=3)
        self._rectangleItem.setStrokeColor(QColor(255, 0, 0))
        self._rectangleItem.setColor(QColor(255, 0, 0))
        self._rectangleItem.setFillColor(QColor(0, 0, 0, 0))
        self._rectangleItem.setWidth(1)

        self._dotItem = QgsVertexMarker(mapCanvas=mapCanvas)
        self._dotItem.setColor(QColor(255, 0, 0))
        self._dotItem.setIconSize(2)
        self._dotItem.setIconType(QgsVertexMarker.ICON_CIRCLE)
        self._dotItem.setPenWidth(2)

    def mapCanvas(self):
        assert isinstance(self._mapCanvas, QgsMapCanvas)
        return self._mapCanvas

    def activate(self):
        QgsMapTool.activate(self)
        self.canvas().setCursor(self._cursor)
        self.plotMapCanvasItems()

    def deactivate(self):
        QgsMapTool.deactivate(self)
        self.plotMapCanvasItems(showRectangle=False, showCrosshair=False)

    def isZoomTool(self):
        return False

    def onPointChanged(self, point):
        self.plotMapCanvasItems()

    def setPoint(self, point):
        if self._point != point:
            if debug: print('setPointZoom')
            self._point = point
            self.canvas().setCenter(point)
            self.sigPointChanged.emit(point)

    def point(self):
        assert isinstance(self._point, QgsPointXY)
        return self._point

    def plotMapCanvasItems(self, showRectangle=True, showCrosshair=True):

        self._crosshairItem.setCenter(self._point)
        self._dotItem.setCenter(self._point)
        self._rectangleItem.setToGeometry(QgsGeometry.fromRect(self.canvas().extent()), None)

        self._crosshairItem.setVisible(showCrosshair)
        self._dotItem.setVisible(showRectangle)
        self._rectangleItem.setVisible(showRectangle)

    # delegate all events to the map canvas map tool
    def _convertMapMouseEvent(self, event):
        assert isinstance(event, QgsMapMouseEvent)
        point = event.originalMapPoint() # from map coordinates ...
        pixel = self._mapCanvas.getCoordinateTransform().transform(point) # ... to device coordinates (inplace)
        event2 = QgsMapMouseEvent(mapCanvas=self._mapCanvas,
                                  type=event.type(),
                                  pos=QPoint(round(pixel.x()), round(pixel.y())),
                                  button=event.button(),
                                  buttons=event.buttons(),
                                  modifiers=event.modifiers())
        event2.originalMapPoint = lambda: point
        event2.mapPoint = lambda: point
        event2.snapPoint = lambda: point
        return event2

    def canvasReleaseEvent(self, event):
        self.setPoint(point=event.originalMapPoint())
        if self.mapCanvas().mapTool() is not None:
            # sync map view scale and center with zoom view
            scale = self.mapCanvas().scale()
            center = self.mapCanvas().center()
            self.mapCanvas().zoomScale(self.canvas().scale())
            self.mapCanvas().setCenter(self.canvas().center())

            # invoke the event handler
            self.mapCanvas().mapTool().canvasReleaseEvent(self._convertMapMouseEvent(event))

            # restore map canvas
            self.mapCanvas().zoomScale(scale)
            self.mapCanvas().setCenter(center)

    def canvasMoveEvent(self, event):
        if self.mapCanvas().mapTool() is not None:
            self.mapCanvas().mapTool().canvasMoveEvent(self._convertMapMouseEvent(event))

    def canvasPressEvent(self, event):
        if self.mapCanvas().mapTool() is not None:
            self.mapCanvas().mapTool().canvasPressEvent(self._convertMapMouseEvent(event))

    def canvasDoubleClickEvent(self, event):
        if self.mapCanvas().mapTool() is not None:
            self.mapCanvas().mapTool().canvasDoubleClickEvent(self._convertMapMouseEvent(event))

    '''def customEvent(self, event):
        if self.mapCanvas().mapTool() is not None:
            self.mapCanvas().mapTool().customEvent(self._convertMapMouseEvent(event))

    def gestureEvent(self, event):
        if self.mapCanvas().mapTool() is not None:
            self.mapCanvas().mapTool().gestureEvent(self._convertMapMouseEvent(event))

    def keyPressEvent(self, event):
        if self.mapCanvas().mapTool() is not None:
            self.mapCanvas().mapTool().keyPressEvent(self._convertMapMouseEvent(event))

    def keyReleaseEvent(self, event):
        if self.mapCanvas().mapTool() is not None:
            self.mapCanvas().mapTool().keyReleaseEvent(self._convertMapMouseEvent(event))

    def timerEvent(self, event):
        if self.mapCanvas().mapTool() is not None:
            self.mapCanvas().mapTool().timerEvent(self._convertMapMouseEvent(event))

    def wheelEvent(self, event):
        if self.mapCanvas().mapTool() is not None:
            self.mapCanvas().mapTool().wheelEvent(self._convertMapMouseEvent(event))'''
