# -*- coding: utf-8 -*-
"""
/***************************************************************************
 zoomtopaste
                                 A QGIS plugin
 Zoom to a specified point on the map from the Clipboard comma delimited
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-12-02
        git sha              : $Format:%H$
        copyright            : (C) 2019 by gerd 3er geoplaning GmbH
        email                : kontakt@geoplaning.de

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QApplication

from qgis.core import *
from qgis.gui import *
# from win32com.client import Dispatch

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .zoomtopaste_dialog import zoomtopasteDialog
import os.path


class zoomtopaste:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'zoomtopaste_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Zoom to Paste')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('zoomtopaste', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/zoomtopaste/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'ZoomToPaste'),
            callback=self.run,
            parent=self.iface.mainWindow())

        icon_path = ':/plugins/zoomtopaste/icongpiu.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Zoom Now'),
            callback=self.zoomnow,
            parent=self.iface.mainWindow())

        #icon_path = ':/plugins/zoomtopaste/icon_frm.png'
        #self.add_action(
        #    icon_path,
        #    text=self.tr(u'Zoom Now'),
        #    callback=self.actionopenfrm,
        #    parent=self.iface.mainWindow())


        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Zoom to Paste'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = zoomtopasteDialog()

        settings = QSettings("MicroResources", "zoomtopaste")

        xValue = settings.value("coordinate/x", '')
        self.dlg.xCoord.setText(str(xValue))
        
        yValue = settings.value("coordinate/y", '')
        self.dlg.yCoord.setText(str(yValue))
        
        scale = settings.value("zoom/scale", 4)
        self.dlg.spinBoxScale.setValue(int(scale))
        
        cbx = settings.value("zoom/checked", 0)
        self.dlg.checkBox.setChecked(int(cbx))

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
               # See if OK was pressed
        if result == 1:
            # Get the coordinates and scale factor from the dialog
            xValue = float(self.dlg.xCoord.text())
            yValue = float(self.dlg.yCoord.text())
            scale = float(self.dlg.spinBoxScale.value())
            cbx=  int(self.dlg.checkBox.isChecked())

            # Create a rectangle to cover the new extent
            rect = QgsRectangle((xValue) - scale, (yValue) - scale, (xValue) + scale, (yValue) + scale)
            # Get the map canvas
            mc =self.iface.mapCanvas()
            # Set the extent to our new rectangle
            mc.setExtent(rect)
            # Refresh the map
            mc.refresh()


            # store the settings
            settings.setValue("coordinate/x", xValue)
            settings.setValue("coordinate/y", yValue)
            settings.setValue("zoom/scale", scale)
            settings.setValue("zoom/checked", cbx)
            
            #settings.setValue("zoom/checked", "1" if self.dlg.checkBox.isChecked() else "0")
        
            if self.dlg.checkBox.isChecked():
                
                QApplication.clipboard().dataChanged.connect(self.zoomnow)

            else:    
                
                QApplication.clipboard().dataChanged.connect(self.destroy)
                #QApplication.clipboard().clear

            

    def zoomnow(self):
        clipboard = QApplication.clipboard()
        if not clipboard.mimeData().hasText():
            return False

        text = unicode(clipboard.text())

        # create and show the zoomtopaste dialog

        if text != "" and text.find(',')>0:

            ret = text.split(",")
            xValue = float(ret[1])
            yValue = float(ret[0])

            if xValue > 0 and yValue > 0:

                if self.first_start == True:
                    self.first_start = False
                    self.dlg = zoomtopasteDialog()  

                self.dlg.xCoord.setText(str(xValue))
                self.dlg.yCoord.setText(str(yValue))

                scale = self.dlg.spinBoxScale.value()

                # Create a rectangle to cover the new extent
                rect = QgsRectangle((xValue) - scale, (yValue) - scale, (xValue) + scale, (yValue) + scale)
                # Get the map canvas
                mc =self.iface.mapCanvas()
                # Set the extent to our new rectangle
                mc.setExtent(rect)
                # Refresh the map
                mc.refresh()

                settings = QSettings("MicroResources", "zoomtopaste")
                settings.setValue("coordinate/x", str(xValue))
                settings.setValue("coordinate/y", str(yValue))

        else:
           self.iface.messageBar().pushMessage("Error zoomNow", "Im Clipbord sind keine oder falsche Daten: " + text , level=Qgis.Warning, duration=3)
            #QMessageBox.information(self.iface.mainWindow(),text, "Im Clipbord sind falsche Daten")


# #http://www.programcreek.com/python/example/4315/win32com.client.Dispatch

    # def DoDumpAccessInfo(self):

        # import daodump

        # a = forms = None
        # try:
            
            # a=Dispatch("Access.Application")
            # a.DoCmd.RunMacro('test')
            # a.OpenCurrentDatabase(dbname)
            # db = a.CurrentDb()
            # daodump.DumpDB(db,1)

            # forms = a.Forms
            # lf=len(forms)



            # #from win32com.client import Dispatch
            # dbForm = 'FRM: _Haltungsdaten'
            # filter ='id= "[% "ID_LSTRE" %]"'
            # dbname ='reporter.mdb'


            # objDB = a.CurrentDb()
            # if objDB is None:
                # a.OpenCurrentDatabase(dbname,True)

            # #a.Visible = True
            # #DoCmd.OpenForm "Employees", , ,"LastName = 'King'"

            # a.DoCmd.OpenForm(dbForm,0,filter)
            # #a.forms(dbForm).Filter = filter
            # a.forms(dbForm).FilterOn = True

            # # Uncommenting these lines means Access remains open.
            # #               for form in forms:
            # #                       print " %s" % form.Name
            # reports = a.Reports
            # rf=len(reports)

        # finally:
            # if not a is None:
               # self.iface.messageBar().pushMessage("Error DoDumpAccessInfo", "Access nicht geoeffnet ", level=Qgis.Warning, duration=3)



    def destroy(self):
        pass
