"""
/***************************************************************************
      zoomtopastedialog  - A QGIS plugin to zoom the map canvas to a point
                         specified in the clippboard
                             -------------------
    begin                : 2018-10-14
    copyright            : (C) 2018 by GD
    email                : gd at geoplaning.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt5.QtCore import *
from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from qgis.core import *
from qgis.gui import *
from win32com.client import Dispatch
 
# Initialize Qt resources from file resources.py
from . import resources

# Import the code for the dialog
from .zoomtopastedialog import zoomtopastedialog 

class zoomtopaste:
    def __init__(self, iface):
        # Save reference to the QGIS interface
        self._iface = iface

    def initGui(self):
        #import pydevd
        #pydevd.settrace('localhost', port=55130, stdoutToServer=True, stderrToServer=True)

        # Create action that will start plugin configuration
        icon = QIcon(":/plugins/zoomtopaste/icon.png")
        self.action = QAction(icon, u"Zoom To Paste",self._iface.mainWindow())
        self.action.setWhatsThis("Configuration for Zoom To Paste plugin")
        self.action.triggered.connect(self.run)
        
       
        # Add toolbar button and menu item
        self._iface.addToolBarIcon(self.action)
        self._iface.addPluginToMenu("&Zoom to Paste...", self.action)
       

       #self._iface.setAcceptDrops(True)

        self.actionzoom = QAction(QIcon(":/plugins/zoomtopaste/icon_now.png"),"Zoom Now",self._iface.mainWindow())
        self.actionzoom.setWhatsThis("Zoom Now")
        self.actionzoom.triggered.connect(self.zoomnow)

        # Add toolbar button and menu item
        self._iface.addToolBarIcon(self.actionzoom)
        
        self._iface.addPluginToMenu("&Zoom Now", self.actionzoom)

               
       #How to call a method by a key shortcut
        self._iface.registerMainWindowAction(self.actionzoom , "F7")
        


        #self.actionopenfrm = QAction(QIcon(":/plugins/zoomtopaste/icon_frm.png"),"Open Form",self._iface.mainWindow())
        #self.actionopenfrm.triggered.connect(self.DoDumpAccessInfo)
       
        # Add toolbar button and menu item
        #self._iface.addToolBarIcon(self.actionopenfrm)
        #self._iface.addPluginToMenu("&AccessInfo", self.actionopenfrm)
   

        
        
    def unload(self):
        # Remove the plugin menu item and icon
       self._iface.removePluginMenu("&Zoom to Paste...", self.action)
       self._iface.removePluginMenu("&Zoom Now", self.actionzoom)
       self._iface.removeToolBarIcon(self.action)
       self._iface.removeToolBarIcon(self.actionzoom)
       self._iface.unregisterMainWindowAction(self.action)
       self._iface.unregisterMainWindowAction(self.actionzoom)
        #self.iface.removeToolBarIcon(self.actionopenfrm)

    # run method that performs all the real work
    def run(self):

        # create and show the zoomtopaste dialog
        dlg = zoomtopastedialog(self._iface)
        # dlg.setupUi(self)
        # fetch the last used values from settings and intialize the
        # dialog with them
        settings = QSettings("MicroResources", "zoomtopaste")

        xValue = settings.value("coordinate/x", '')
        dlg.xCoord.setText(str(xValue))
        
        yValue = settings.value("coordinate/y", '')
        dlg.yCoord.setText(str(yValue))
        
        scale = settings.value("zoom/scale", 4)
        dlg.spinBoxScale.setValue(int(scale))
        
        #cbx = settings.value("zoom/checked", 0)
        #dlg.checkBox.setChecked(int(cbx))

        
        dlg.show()
        result = dlg.exec_()
        # See if OK was pressed
        if result == 1:
            # Get the coordinates and scale factor from the dialog
            x = dlg.xCoord.text()
            y = dlg.yCoord.text()
            scale = dlg.spinBoxScale.value()


            rect = QgsRectangle(float(x) - scale,float(y) - scale,float(x) + scale,float(y) + scale)
            # Get the map canvas
            mc =self._iface.mapCanvas()
            # Set the extent to our new rectangle
            mc.setExtent(rect)
            # Refresh the map
            mc.refresh()


            # store the settings
            settings.setValue("coordinate/x", x)
            settings.setValue("coordinate/y", y)
            settings.setValue("zoom/scale", scale)

            #settings.setValue("zoom/checked", "1" if dlg.checkBox.isChecked() else "0")
        
            if dlg.checkBox.isChecked():
                #QObject.connect(QApplication.clipboard(), SIGNAL("dataChanged()"), self.dropChangedGo)
                QApplication.clipboard().dataChanged.connect(self.dropChangedGo)

            else:    
                #QObject.connect(QApplication.clipboard(), SIGNAL("dataChanged()"), self.destroy)
                QApplication.clipboard().dataChanged.connect(self.destroy)
                #QApplication.clipboard().clear

            


    def zoomnow(self):
        clipboard = QApplication.clipboard()
        if not clipboard.mimeData().hasText():
            return False

        text = unicode(clipboard.text())

        # create and show the zoomtopaste dialog

        if text != "" and text.find(',')>0:

            str = text.split(",")
            x = str[1]
            y = str[0]

            if x > 0 and y > 0:
                dlg = zoomtopastedialog(self,self._iface)
                dlg.xCoord.setText((x))
                dlg.yCoord.setText((y))

                scale = dlg.spinBoxScale.value()

                # Create a rectangle to cover the new extent
                rect = QgsRectangle(float(x) - scale, float(y) - scale, float(x) + scale, float(y) + scale)
                # Get the map canvas
                mc =self._iface.mapCanvas()
                # Set the extent to our new rectangle
                mc.setExtent(rect)
                # Refresh the map
                mc.refresh()

                settings = QSettings("MicroResources", "zoomtopaste")
                settings.setValue("coordinate/x", x)
                settings.setValue("coordinate/y", y)

        else:
           self._iface.messageBar().pushMessage("Error dropChangedGo", "Im Clipbord sind keine oder falsche Daten " , level=Qgis.Warning, duration=3)
            #QMessageBox.information(self.iface.mainWindow(),text, "Im Clipbord sind falsche Daten")




    def dropChangedGo(self):

        # create and show the zoomtopaste dialog
        dlg = zoomtopastedialog(self._iface)

        clipboard = QApplication.clipboard()
        if not clipboard.mimeData().hasText():
            return False

        text = unicode(clipboard.text())
        print(text)
        # create and show the zoomtopaste dialog

        if text != "" and text.find(',')>0:
            #5744021,3503546
            str = text.split(",")
            print(str)

            x = str[1]
            y = str[0]
            if int(x) > 0 and int(y) > 0:

                dlg.xCoord.setText((x))
                dlg.yCoord.setText((y))

                scale = dlg.spinBoxScale.value()

                # Create a rectangle to cover the new extent
                rect = QgsRectangle(float(x) - scale, float(y) - scale, float(x) + scale, float(y) + scale)
                # Get the map canvas
                mc =self._iface.mapCanvas()
                # Set the extent to our new rectangle
                mc.setExtent(rect)
                # Refresh the map
                mc.refresh()

                settings = QSettings("MicroResources", "zoomtopaste")
                settings.setValue("coordinate/x", x)
                settings.setValue("coordinate/y", y)

        else:
           self._iface.messageBar().pushMessage("Error dropChangedGo", "Im Clipbord sind falsche Daten ", level = Qgis.Warning, duration = 3)
            #QMessageBox.information(self.iface.mainWindow(),text, "Im Clipbord sind falsche Daten")

#http://www.programcreek.com/python/example/4315/win32com.client.Dispatch

    def DoDumpAccessInfo(self):

        import daodump

        a = forms = None
        try:
            
            a=Dispatch("Access.Application")
            a.DoCmd.RunMacro('test')
            a.OpenCurrentDatabase(dbname)
            db = a.CurrentDb()
            daodump.DumpDB(db,1)

            forms = a.Forms
            lf=len(forms)



            #from win32com.client import Dispatch
            dbForm = 'FRM: _Haltungsdaten'
            filter ='id= "[% "ID_LSTRE" %]"'
            dbname ='reporter.mdb'


            objDB = a.CurrentDb()
            if objDB is None:
                a.OpenCurrentDatabase(dbname,True)

            #a.Visible = True
            #DoCmd.OpenForm "Employees", , ,"LastName = 'King'"

            a.DoCmd.OpenForm(dbForm,0,filter)
            #a.forms(dbForm).Filter = filter
            a.forms(dbForm).FilterOn = True

            # Uncommenting these lines means Access remains open.
            #               for form in forms:
            #                       print " %s" % form.Name
            reports = a.Reports
            rf=len(reports)

        finally:
            if not a is None:
               self._iface.messageBar().pushMessage("Error DoDumpAccessInfo", "Access nicht geoeffnet ", level=Qgis.Warning, duration=3)



    def destroy(self):
        pass
