"""
/***************************************************************************
      zoomtopasteDialog  - A QGIS plugin to zoom the map canvas to a point
                         specified in the clippboard
                             -------------------
    begin                : 2014-10-14
    copyright            : (C) 2014 by GD
    email                : gd at geoplaning.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
from win32com.client import Dispatch
 
# Initialize Qt resources from file resources.py
import resources

# Import the code for the dialog
from zoomtopastedialog import zoomtopasteDialog


class zoomtopaste:
    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface

    def initGui(self):
        #import pydevd
        #pydevd.settrace('localhost', port=55130, stdoutToServer=True, stderrToServer=True)

        # Create action that will start plugin configuration
        icon = QIcon(":/plugins/zoomtopaste/icon.png")
        self.action = QAction(icon, u"Zoom To Paste", self.iface.mainWindow())
        self.action.setWhatsThis("Configuration for Zoom To Paste plugin")
        QObject.connect(self.action, SIGNAL("activated()"), self.run)
        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Zoom to Paste...", self.action)

        # self.iface.setAcceptDrops(True)

        self.actionzoom = QAction(QIcon(":/plugins/zoomtopaste/icon_now.png"),"Zoom Now   F7",self.iface.mainWindow())
        QObject.connect(self.actionzoom, SIGNAL("activated()"), self.zoomnow)
        self.iface.addToolBarIcon(self.actionzoom)


        #How to call a method by a key shortcut
        self.iface.registerMainWindowAction(self.actionzoom, "F7")
        QObject.connect(self.actionzoom, SIGNAL("triggered()"), self.zoomnow)



        
    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&Zoom to Paste...", self.action)
        self.iface.removeToolBarIcon(self.action)
        self.iface.removeToolBarIcon(self.actionzoom)

    # run method that performs all the real work
    def run(self):

        # create and show the zoomtopaste dialog
        dlg = zoomtopasteDialog()
        # dlg.setupUi(self)
        # fetch the last used values from settings and intialize the
        # dialog with them
        settings = QSettings("MicroResources", "zoomtopaste")

        xValue = settings.value("coordinate/x", '')
        dlg.ui.xCoord.setText(str(xValue))
        
        yValue = settings.value("coordinate/y", '')
        dlg.ui.yCoord.setText(str(yValue))
        
        scale = settings.value("zoom/scale", 4)
        dlg.ui.spinBoxScale.setValue(int(scale))
        
        #cbx = settings.value("zoom/checked", 0)
        #dlg.ui.checkBox.setChecked(int(cbx))

        
        dlg.show()
        result = dlg.exec_()
        # See if OK was pressed
        if result == 1:
            # Get the coordinates and scale factor from the dialog
            x = dlg.ui.xCoord.text()
            y = dlg.ui.yCoord.text()
            scale = dlg.ui.spinBoxScale.value()


            rect = QgsRectangle(float(x) - scale,float(y) - scale,float(x) + scale,float(y) + scale)
            # Get the map canvas
            mc = self.iface.mapCanvas()
            # Set the extent to our new rectangle
            mc.setExtent(rect)
            # Refresh the map
            mc.refresh()


            # store the settings
            settings.setValue("coordinate/x", x)
            settings.setValue("coordinate/y", y)
            settings.setValue("zoom/scale", scale)

            #settings.setValue("zoom/checked", "1" if dlg.ui.checkBox.isChecked() else "0")
        
            if dlg.ui.checkBox.isChecked():
                QObject.connect(QApplication.clipboard(), SIGNAL("dataChanged()"), self.dropChangedGo)
            else:    
                QObject.connect(QApplication.clipboard(), SIGNAL("dataChanged()"), self.destroy)
                #QApplication.clipboard().clear

            


    def zoomnow(self):
        clipboard = QApplication.clipboard()
        if not clipboard.mimeData().hasText():
            return False

        text = unicode(clipboard.text())

        # create and show the zoomtopaste dialog

        if text != "" and text.find(',')>0:

            str = text.split(",")
            x = str[1]
            y = str[0]

            if x > 0 and y > 0:
                dlg = zoomtopasteDialog()
                dlg.ui.xCoord.setText((x))
                dlg.ui.yCoord.setText((y))

                scale = dlg.ui.spinBoxScale.value()

                # Create a rectangle to cover the new extent
                rect = QgsRectangle(float(x) - scale, float(y) - scale, float(x) + scale, float(y) + scale)
                # Get the map canvas
                mc = self.iface.mapCanvas()
                # Set the extent to our new rectangle
                mc.setExtent(rect)
                # Refresh the map
                mc.refresh()

                settings = QSettings("MicroResources", "zoomtopaste")
                settings.setValue("coordinate/x", x)
                settings.setValue("coordinate/y", y)

        else:
            self.iface.messageBar().pushMessage("Error dropChangedGo", "Im Clipbord sind falsche Daten " , level=QgsMessageBar.INFO, duration=3)
            #QMessageBox.information(self.iface.mainWindow(),text, "Im Clipbord sind falsche Daten")




    def dropChangedGo(self):

        dlg = zoomtopasteDialog()

        clipboard = QApplication.clipboard()
        if not clipboard.mimeData().hasText():
            return False

        text = unicode(clipboard.text())

        # create and show the zoomtopaste dialog

        if text != "" and text.find(',')>0:

            str = text.split(",")
            x = str[1]
            y = str[0]

            if x > 0 and y > 0:

                dlg.ui.xCoord.setText((x))
                dlg.ui.yCoord.setText((y))

                scale = dlg.ui.spinBoxScale.value()

                # Create a rectangle to cover the new extent
                rect = QgsRectangle(float(x) - scale, float(y) - scale, float(x) + scale, float(y) + scale)
                # Get the map canvas
                mc = self.iface.mapCanvas()
                # Set the extent to our new rectangle
                mc.setExtent(rect)
                # Refresh the map
                mc.refresh()

                settings = QSettings("MicroResources", "zoomtopaste")
                settings.setValue("coordinate/x", x)
                settings.setValue("coordinate/y", y)

        else:
            self.iface.messageBar().pushMessage("Error dropChangedGo", "Im Clipbord sind falsche Daten ", level=QgsMessageBar.INFO, duration=3)
            #QMessageBox.information(self.iface.mainWindow(),text, "Im Clipbord sind falsche Daten")



    def DoDumpAccessInfo(dbname):
        import Dispatch

        a = forms = None
        try:
            
            a=Dispatch("Access.Application")
            a.OpenCurrentDatabase(dbname)
            db = a.CurrentDb()
            daodump.DumpDB(db,1)
            forms = a.Forms
            print "There are %d forms open." % (len(forms))
    # Uncommenting these lines means Access remains open.
    #               for form in forms:
    #                       print " %s" % form.Name
            reports = a.Reports
            print "There are %d reports open" % (len(reports))
        finally:
            if not a is None:
                sys.stderr.write("Closing database\n")
                try:
                    a.CloseCurrentDatabase()
                except pythoncom.com_error:
                    pass

           
    def destroy(self):
        pass
