# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ZoomRCDockWidget
                                 A QGIS plugin
 Zoom to a Spanish Cadastre Reference
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-02-27
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Francisco P. Sampayo
        email                : fpsampayo@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.core import QgsRectangle

from PyQt5 import QtWidgets, uic
from PyQt5.QtCore import pyqtSignal
from PyQt5.QtWidgets import QMessageBox

from zoomrc.core.catastroTools import CatastroTools


pluginPath = os.path.split(os.path.dirname(__file__))[0]
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    pluginPath, 'ui', 'zoomrc_dockwidget_base.ui'))


class ZoomRCDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None, iface=None):
        """Constructor."""
        super(ZoomRCDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        
        self.setupUi(self)
        self.iface = iface
        
        self.cmpRefCat.setMaxLength(14)
        #self.cmpEscala.setValue(600)
        self.cmpResaltar.setChecked(True)
        self.cmpNuevaCapa.setChecked(False)
        self.cmpLindantes.setEnabled(False)
        
        self.btnBuscar.clicked.connect(self.findRefcat)
        self.btnClean.clicked.connect(self.clearRubber)

        self.cmpNuevaCapa.stateChanged.connect(self.toggleLindantes)
        
        self.catastroTools = CatastroTools(iface)


    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()


    def toggleLindantes(self):
        if self.cmpLindantes.isEnabled():
            self.cmpLindantes.setChecked(False)
            self.cmpLindantes.setEnabled(False)
        else:
            self.cmpLindantes.setEnabled(True)

    def clearRubber(self):
        self.catastroTools.clearRubber()
        
    
    def findRefcat(self):
        
        refcat = self.cmpRefCat.text()
        resaltar = self.cmpResaltar.isChecked()
        cargarCapa = self.cmpNuevaCapa.isChecked()
        lindantes = self.cmpLindantes.isChecked()
        canvas = self.iface.mapCanvas()
        msettings = canvas.mapSettings()
        projection = msettings.destinationCrs().authid()
        
        
        if len(refcat) < 14:
            QMessageBox.information(None, "Error", "La Referencia Catastral debe ser de 14 caracteres.")
        else:
            isok, msg = self.catastroTools.XYbyRefCat(refcat,
                                                      projection,
                                                      resaltar=resaltar,
                                                      cargarCapa=cargarCapa,
                                                      lindantes=lindantes)
            if not isok:
                QMessageBox.information(None, "Error", msg)
