# -*- coding: utf-8 -*-

"""
/***************************************************************************
 XPlan-Umring
                                 A QGIS plugin
 Umringpolygon eines Bebauungsplans aus QGIS nach XPlanung konvertieren
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-22
        copyright            : (C) 2023 by Kreis Viersen
        email                : open@kreis-viersen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = "Kreis Viersen"
__date__ = "2023-05-22"
__copyright__ = "(C) 2023 by Kreis Viersen"

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .xplan_umring_provider import XPlanUmringProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class XPlanUmringPlugin(object):
    def __init__(self):
        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = XPlanUmringProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
