# -*- coding: utf-8 -*-

"""
/***************************************************************************
 XPlan-Umring
                                 A QGIS plugin
 Umringpolygon eines Bebauungsplans aus QGIS nach XPlanung konvertieren
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-22
        copyright            : (C) 2023 by Kreis Viersen
        email                : open@kreis-viersen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = "Kreis Viersen"
__date__ = "2023-05-22"
__copyright__ = "(C) 2023 by Kreis Viersen"

from qgis.core import QgsProcessingProvider
from .xplan_umring_algorithm_bp_5_4 import XPlanUmringAlgorithmBP54
from .xplan_umring_algorithm_bp_6_0 import XPlanUmringAlgorithmBP60
from .xplan_umring_algorithm_lp_6_0 import XPlanUmringAlgorithmLP60


class XPlanUmringProvider(QgsProcessingProvider):
    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(XPlanUmringAlgorithmBP54())
        self.addAlgorithm(XPlanUmringAlgorithmBP60())
        self.addAlgorithm(XPlanUmringAlgorithmLP60())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return "XPlan-Umring"

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr("XPlan-Umring")

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
