# SPDX-FileCopyrightText: 2025 XLeitstelle Planen und Bauen <xleitstelle@gv.hamburg.de>
# SPDX-FileContributor: Tobias Kraft <tobias.kraft@gv.hamburg.de>
#
# SPDX-License-Identifier: EUPL-1.2-or-later

from configparser import ConfigParser
from pathlib import Path

metadata = ConfigParser()
with open(Path(__file__).parent.parent / "metadata.txt") as f:
    metadata.read_file(f)

PLUGIN_NAME = metadata.get("general", "name")
PLUGIN_VERSION = metadata.get("general", "version")
PLUGIN_DIR_NAME = PLUGIN_NAME.lower().replace("-", "_")

DEPENDENCIES = {
    "required": metadata.get("dependencies", "required").split(" "),
    "optional": metadata.get("dependencies", "optional").split(" "),
}
