# SPDX-FileCopyrightText: 2025 XLeitstelle Planen und Bauen <xleitstelle@gv.hamburg.de>
# SPDX-FileContributor: Tobias Kraft <tobias.kraft@gv.hamburg.de>
#
# SPDX-License-Identifier: EUPL-1.2

import logging

from qgis.core import (
    Qgis,
    QgsAttributeEditorField,
    QgsVectorLayer,
)

from xmas_plugin.util.metadata import PLUGIN_DIR_NAME

logger = logging.getLogger(PLUGIN_DIR_NAME)


def configure_layer_form(layer: QgsVectorLayer):
    """Configures edit form, widgets and fields for the plugin."""
    form = layer.editFormConfig()
    form.setLayout(Qgis.AttributeFormLayout.DragAndDrop)
    root = form.invisibleRootContainer()
    root.clear()
    editor_field = QgsAttributeEditorField(
        "properties", layer.fields().indexFromName("properties"), root
    )
    editor_field.setShowLabel(False)
    editor_field.setVerticalStretch(2)
    root.addChildElement(editor_field)
    layer.setEditFormConfig(form)
    layer.setDisplayExpression("featuretype || ' '  || left(id, 8)")
    logger.debug("layer form config successful")
