# SPDX-FileCopyrightText: 2025 XLeitstelle Planen und Bauen <xleitstelle@gv.hamburg.de>
# SPDX-FileContributor: Anton Jacobsson <anton.jacobsson@init.de>
#
# SPDX-License-Identifier: EUPL-1.2

import os
import site
import tempfile
from pathlib import Path

from qgis.utils import iface


def get_main_window():
    """
    Returns the Qgis main window
    """
    return iface.mainWindow() if hasattr(iface, "mainWindow") else None


def get_plugin_root():
    """
    Get the root directory of the plugin.
    """
    return str(Path(os.path.dirname(__file__)).parent)


def get_log_dir() -> Path:
    """Returns the Path to a log dir in the system's temp dir."""
    dir = Path(tempfile.gettempdir()) / "xmas_log"
    dir.mkdir(exist_ok=True)
    return dir


def get_user_site_subdirs() -> int:
    """Determine the number of subdirs in user's site directory to track changes."""
    try:
        return len([dir for dir in Path(site.getusersitepackages()).iterdir()])
    except Exception:
        return 0


PIP_TARGET_PATH = str(Path(get_plugin_root()) / "_vendor")
