# SPDX-FileCopyrightText: 2025 XLeitstelle Planen und Bauen <xleitstelle@gv.hamburg.de>
# SPDX-FileContributor: Tobias Kraft <tobias.kraft@gv.hamburg.de>
# SPDX-FileContributor: Anton Jacobsson <anton.jacobsson@init.de>
#
# SPDX-License-Identifier: EUPL-1.2-or-later


def classFactory(iface):  # pylint: disable=invalid-name
    """Initialize plugin class."""
    deps_satisfied = False

    try:
        from PyQt5.QtWebEngineWidgets import QWebEngineView  # noqa: F401

        deps_satisfied = True
    except ImportError:
        from xmas_plugin import server_manager
        from xmas_plugin.util.helpers import get_user_site_subdirs

        # Build requirement string like "PyQtWebEngine~=5.15"
        req = server_manager.pyqtwebengine_requirement()

        user_site_subdirs = get_user_site_subdirs()

        ok = server_manager.verify_dependency_installation(
            [req],
            parent=iface.mainWindow(),
            label="PyQtWebEngine",
        )

        if ok:
            # check if package was installed to user site, which requires a reload of QGIS
            if get_user_site_subdirs() > user_site_subdirs:
                from qgis.PyQt.QtWidgets import QMessageBox

                from xmas_plugin.util.metadata import PLUGIN_NAME

                restart = QMessageBox.question(
                    iface.mainWindow(),
                    PLUGIN_NAME,
                    "PyQtWebEngine steht erst nach einem Neustart von QGIS zur Verfügung.\n\nQGIS jetzt beenden?",
                )
                if restart == QMessageBox.Yes:
                    iface.actionExit().trigger()

        # Auto-install claimed success. Try the import again:
        try:
            from PyQt5.QtWebEngineWidgets import QWebEngineView  # noqa: F401

            deps_satisfied = True
        except ImportError:
            pass

    from xmas_plugin.xmas_plugin import XMASPlugin

    return XMASPlugin(iface, deps_satisfied)
