# SPDX-FileCopyrightText: 2025 XLeitstelle Planen und Bauen <xleitstelle@gv.hamburg.de>
# SPDX-FileContributor: Tobias Kraft <tobias.kraft@gv.hamburg.de>
# SPDX-FileContributor: Michael Holzapfel <michael.holzapfel@geocledian.com>
#
# SPDX-License-Identifier: EUPL-1.2-or-later

from qgis.core import (
    QgsCoordinateReferenceSystem,
    QgsCoordinateTransform,
    QgsGeometry,
    QgsProject,
)


def transform_to_project_crs(
    geom: QgsGeometry, crs: QgsCoordinateReferenceSystem
) -> QgsGeometry:
    """
    Clones and transforms a QgsGeometry from given CRS to projects current CRS.
    """
    _geom = QgsGeometry()
    _geom.fromWkb(geom.asWkb())
    if (project_crs := QgsProject.instance().crs()) != crs:
        transformer = QgsCoordinateTransform(crs, project_crs, QgsProject.instance())
        _geom.transform(transformer)
    return _geom


def transform_to_crs(
    geom: QgsGeometry,
    source_crs: QgsCoordinateReferenceSystem,
    target_crs: QgsCoordinateReferenceSystem,
) -> QgsGeometry:
    """
    Clones and transforms a QgsGeometry from a source to a target CRS.
    """
    _geom = QgsGeometry()
    _geom.fromWkb(geom.asWkb())
    if source_crs != target_crs:
        transformer = QgsCoordinateTransform(
            source_crs, target_crs, QgsProject.instance()
        )
        _geom.transform(transformer)
    return _geom
