from qgis.core import QgsCoordinateReferenceSystem, QgsGeometry, QgsMapLayer
from qgis.gui import QgsHighlight, QgsMapCanvas
from qgis.PyQt.QtCore import QSettings
from qgis.PyQt.QtGui import QColor
from qgis.PyQt.QtWidgets import QTableView


class TopoCheckerHighlight(QgsHighlight):
    def __init__(
        self, canvas: QgsMapCanvas | None, geom: QgsGeometry, layer: QgsMapLayer | None
    ):
        super().__init__(canvas, geom, layer)


class TopoTableView(QTableView):
    """
    Base Class for TableViews
    """

    def __init__(self, parent=None):
        super().__init__(parent)

        # placeholder for CRS
        self.plan_crs: QgsCoordinateReferenceSystem | None = None

        # get highlight color from Qgis Settings
        _settings = QSettings()

        try:
            self.highlight_color = QColor(_settings.value("Map/highlight/color"))
        except:
            self.highlight_color = QColor(255, 0, 0)

        try:
            _highlight_alpha = _settings.value("Map/highlight/colorAlpha")
            self.highlight_color.setAlpha(int(_highlight_alpha))
        except TypeError:
            self.highlight_color.setAlpha(0)

        self.verticalHeader().setVisible(False)
