from qgis.core import QgsProcessingProvider

from xmas_plugin.processing.alg_split_plan import SplitPlanByBoundaryAlgorithm
from xmas_plugin.util.metadata import PLUGIN_NAME


class XMASPluginProcessingProvider(QgsProcessingProvider):
    def loadAlgorithms(self):
        self.addAlgorithm(SplitPlanByBoundaryAlgorithm())

    def id(self):
        return PLUGIN_NAME.lower()

    def name(self):
        return PLUGIN_NAME

    def longName(self):
        return f"{PLUGIN_NAME} Processing Provider"
