# noinspection PyPep8Naming


def classFactory(iface):  # pylint: disable=invalid-name
    """Initialize plugin class."""
    try:
        from PyQt5.QtWebEngineWidgets import QWebEngineView  # noqa: F401
    except ImportError as e:
        from . import server_manager

        # Build requirement string like "PyQtWebEngine~=5.15"
        req = server_manager.pyqtwebengine_requirement()

        ok = server_manager.verify_dependency_installation(
            [req],
            parent=iface.mainWindow(),
            label="PyQtWebEngine",
        )

        if not ok:
            iface.messageBar().pushCritical(
                "XMAS-Plugin",
                "Erforderliches Paket 'PyQtWebEngine' fehlt und konnte nicht automatisch installiert werden.",
            )
            raise RuntimeError(
                "Missing dependency: PyQtWebEngine (auto-install failed)"
            ) from e

        # Auto-install claimed success. Try the import again:
        try:
            from PyQt5.QtWebEngineWidgets import QWebEngineView  # noqa: F401
        except ImportError as e2:
            iface.messageBar().pushCritical(
                "XMAS-Plugin",
                "PyQtWebEngine nach automatischer Installation weiterhin nicht importierbar.",
            )
            raise RuntimeError("PyQtWebEngine still missing after auto-install") from e2

    from .xmas_plugin import XMASPlugin

    return XMASPlugin(iface)
