# -*- coding: utf-8 -*-
"""
 /***************************************************************************
   QGIS Web Processing Service Plugin
  -------------------------------------------------------------------
 Date                 : 09 November 2009
 Copyright            : (C) 2009 by Dr. Horst Duester
 email                : horst dot duester at kappasys dot ch

  ***************************************************************************
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  ***************************************************************************/
"""
from configparser import ConfigParser
import os


class Metadata():
    
    def __init__(self):
        self._read_metadata()
    
    def _read_metadata(self):
        self.result = {}
        with open("%s/wps/metadata.txt" % (os.path.dirname(os.path.dirname( __file__)))) as f:
            config = ConfigParser()
            config.read_file(f)
            options = config.options('general')
            for option in options:
                try:
                    self.result[option] = config.get('general', option)
                except:
                    self.result[option] = ''          
                
    
    def version(self):
        return self.result['version']
        
    def description(self):
        return self.result['description']
        
        
    def name(self):
       return self.result['name']
       
    def date(self):
       return self.result['date']       
       
    def qgisMinimumVersion(self):
       return self.result['qgisMinimumVersion']
       
    def qgisMaximumVersion(self):
       return self.result['qgisMaximumVersion']
       
    def author(self):
       return self.result['author']
       
    def email(self):
       return self.result['email']
       
    def homepage(self):
       return self.result['homepage']
       
    def tracker(self):
        return self.result['tracker']
        
    def repository(self):
        return self.result['repository']               
        
    def changelog(self):
        try:
            return self.result['changelog']        
        except:
            return ''    
        
    
