from qgis.core import (
    Qgis,
    QgsApplication,
    QgsLineSymbol,
    QgsMarkerLineSymbolLayer,
    QgsMarkerSymbol,
    QgsSimpleLineSymbolLayer,
    QgsSimpleMarkerSymbolLayer,
)
from qgis.gui import QgsMapCanvas, QgsRubberBand
from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QColor


class CurveRubberband(QgsRubberBand):
    """Show a red line as a rubberband on the main canvas"""

    def __init__(self, map_canvas: QgsMapCanvas) -> None:
        # Copy from QgsElevationProfileWidget::createOrUpdateRubberBands
        super().__init__(map_canvas, Qgis.GeometryType.Line)

        self.setWidth(QgsApplication.scaleIconSize(2))

        line_symbol = QgsLineSymbol()

        bottom_symbol_layer = QgsSimpleLineSymbolLayer()
        bottom_symbol_layer.setWidth(0.8)
        bottom_symbol_layer.setWidthUnit(Qgis.RenderUnit.Millimeters)
        bottom_symbol_layer.setColor(QColor(180, 50, 50, 150))
        bottom_symbol_layer.setPenCapStyle(Qt.PenCapStyle.FlatCap)
        line_symbol.changeSymbolLayer(0, bottom_symbol_layer)

        arrow_symbol_layer = QgsMarkerLineSymbolLayer()
        arrow_symbol_layer.setPlacements(Qgis.MarkerLinePlacement.CentralPoint)

        arrow_marker_symbol_layer = QgsSimpleMarkerSymbolLayer(Qgis.MarkerShape.EquilateralTriangle)
        arrow_marker_symbol_layer.setSize(4)
        arrow_marker_symbol_layer.setAngle(90)
        arrow_marker_symbol_layer.setSizeUnit(Qgis.RenderUnit.Millimeters)
        arrow_marker_symbol_layer.setColor(QColor(200, 60, 60, 180))
        arrow_marker_symbol_layer.setStrokeColor(QColor(255, 255, 255, 220))
        arrow_marker_symbol_layer.setStrokeWidth(0.2)

        marker_symbol = QgsMarkerSymbol()
        marker_symbol.changeSymbolLayer(0, arrow_marker_symbol_layer)
        arrow_symbol_layer.setSubSymbol(marker_symbol)
        line_symbol.appendSymbolLayer(arrow_symbol_layer)

        top_symbol_layer = QgsSimpleLineSymbolLayer()
        top_symbol_layer.setWidth(0.4)
        top_symbol_layer.setWidthUnit(Qgis.RenderUnit.Millimeters)
        top_symbol_layer.setColor(QColor(255, 255, 255, 255))
        top_symbol_layer.setPenStyle(Qt.PenStyle.DashLine)
        top_symbol_layer.setPenCapStyle(Qt.PenCapStyle.FlatCap)
        line_symbol.appendSymbolLayer(top_symbol_layer)

        self.setSymbol(line_symbol)
        self.updatePosition()
