"""
Utility module
"""

from __future__ import annotations

from typing import TYPE_CHECKING, cast

from qgis.gui import QgisInterface, QgsElevationProfileCanvas
from qgis.utils import iface

if TYPE_CHECKING:
    from woody.layer.image_layer import ImageLayer


def refreshAllElevationProfiles(image_layer: ImageLayer):
    """
    Refresh all elevation profile canvas where this layer is in.
    """

    if iface is None:
        return

    # FIXME: We should use image_layer.dataChanged.emit() to trigger the elevation
    # profile canvas refresh but there is a bug in QGIS so we use
    # this function instead while the bug is here

    if (main_window := cast(QgisInterface, iface).mainWindow()) is not None:
        for elevation_canvas in main_window.findChildren(QgsElevationProfileCanvas):
            if image_layer in elevation_canvas.layers():
                elevation_canvas.refresh()
