# -*- coding: utf-8 -*-
"""
/***************************************************************************
 WofEClass
                                 A QGIS plugin
                        Weights of Evidence (WofE) Model
 
 Created by Bijal Chudasama, Geological Survey of Finland 
 
 Generated using the basic template from Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-01-12
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Geological Survey of Finland
        email                : bijal.chudasama@gtk.fi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .WofE_module_dialog import WofEClassDialog
import os.path

#System imports
import os
import os.path
from pathlib import Path
import csv
import math
import qgis
import processing
from processing.algs.gdal.GdalUtils import GdalUtils
from osgeo import gdal, ogr, osr, gdalconst
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QAbstractItemView, QDialog, QListWidget,  QListWidgetItem, QAction, QFileDialog, QApplication, QWidget, QPushButton, QMessageBox
from qgis.core import QgsVectorLayer, Qgis, QgsProject, QgsMapLayer, QgsRasterLayer
from qgis.analysis import QgsRasterCalculator, QgsRasterCalculatorEntry 
import pandas as pd
import numpy as np

class WofEClass:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'WofEClass_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Weights of Evidence (WofE) Model')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None


        
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('WofEClass', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToRasterMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/WofE_module/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'WofE'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

        
    def inp_evdnc_rst(self):
        global names_evr
        names_evr =(QFileDialog.getOpenFileNames(caption="Add evidence rasters", filter="Evidence Rasters (*.tif)")[0])
        for name in names_evr:
            self.dlg.lw_evdnc_rsts.addItem(name)
        inFile =str(names_evr)  
        print(names_evr)
    

    def removeSelectedEvR(self):
       for item in self.dlg.lw_evdnc_rsts.selectedItems():
            self.dlg.lw_evdnc_rsts.takeItem(self.dlg.lw_evdnc_rsts.row(item))
    
    
    def depNote(self):    
        tooltip = QMessageBox()
        tooltip.setText("The input training layer  should \
have a field called 'Dep_ID' with all points having value 1. \
In the absence of this field the code will not run to completion.\n\
\n\
")
        tooltip.setStyleSheet("font-size: 12pt;")
        tooltip.show()
        tooltip.exec_()
    
    def depMsg(self):
        noFldMsg = QMessageBox()
        noFldMsg.setText( "Data pre-processing INCOMPLETE.   \n\
        \n\
The input training layer does not have the field called 'Dep_ID'.   \n\
\n\
Refer to 'Imp. Info.'  button in the tool interface for details.   \n\
\n\
 ")
        #noFldMsg.setStyleSheet("background-color: rgb(180, 10, 0); font-size: 12pt; font-color: rgb(0, 255, 255);" )
        noFldMsg.setStyleSheet("font-size: 12pt;")
        noFldMsg.setStyleSheet("QLabel{ color: red}");
        noFldMsg.show()
        noFldMsg.exec_()
        
        
    def rcls1ErrMsg(self):
        noRcls1Msg = QMessageBox()
        noRcls1Msg.setText("Weights Calculation INCOMPLETE. Process ABORTED. \n\
        \n\
Error Details: For the given studentized contrast value, none of classes were \n\
classified to the 'Unfavorable' class, i.e. Class 1. \n\
\n\
File 'Calc_Stud_Cont.csv', that is loaded to the project, contains the calculated \n\
studentized contrast values. Check these values and run 'calculate weights' again \n\
with a suitable studentized contrast value. \n\
\n\
The plugin will throw an error and will not execute further processing. \n\
\n\
")
        #noRcls1Msg.setStyleSheet("background-color: rgb(0, 0, 0);")
        #noRcls1Msg.setStyleSheet("text-color: rgb(255, 255, 255);")
        noRcls1Msg.setStyleSheet("QLabel{ color: red}");
        noRcls1Msg.show()
        noRcls1Msg.exec_()
        
    
    def rcls2ErrMsg(self):
        noRcls2Msg = QMessageBox()
        noRcls2Msg.setText("Weights Calculations INCOMPLETE. Process ABORTED. \n\
        \n\
ERROR DETAILS: For the given studentized contrast value, none of classes were \n\
classified to the 'Favorable' class, i.e. Class 2. \n\
\n\
File 'Calc_Stud_Cont.csv', that is loaded to the project, contains the calculated \n\
studentized contrast values. Check these values and run 'calculate weights' again \n\
with a suitable studentized contrast value. \n\
\n\
The plugin will throw an error and will not execute further processing. \n\
\n\
")
        #noRcls1Msg.setStyleSheet("background-color: rgb(0, 0, 0);")
        #noRcls1Msg.setStyleSheet("text-color: rgb(255, 255, 255);")
        noRcls2Msg.setStyleSheet("QLabel{ color: red}");
        noRcls2Msg.show()
        noRcls2Msg.exec_()
        
    
    def preProCmptMsg(self):
        preProCmptMsg = QMessageBox()
        preProCmptMsg.setText("Data pre-processing COMPLETED. \n\
        \n\
The processed evidence rasters are saved in the current workspace. \n\
These have also been added to the curent QGIS project.\n\
\n\
Training sites raster succesfully created in the current workspace. \n\
\n\
NEXT STEP - CALCULATE WEIGHTS   \n\
\n\
For weights calculations and responses calculations use: \n\
1. The processed evidence rasters \n\
2. The same scratch and current workspace. \n\
\n\
")
        preProCmptMsg.setStyleSheet("font-size: 12pt;")
        preProCmptMsg.show()
        preProCmptMsg.exec_()
 
    
    def wgtsCalcCmpltMsg(self):
        wgtsCalcCmpltMsg = QMessageBox()
        wgtsCalcCmpltMsg.setText("Weights Calculations COMPLETED. \n\
        \n\
All the results are added to the current QGIS project.\n\
\n\
Proceed to weights calculation for the next evidential layer\n\
\n\
If finished with weights calculations for all evidential layers then proceed to:\n\
\n\
CALCULATE RESPONSES \n\
\n\
For 'Calculate Responses' use:\n\
1. The multiband weights rasters, \n\
2. The same scratch and current workspace. \n\
\n\
")
        wgtsCalcCmpltMsg.setStyleSheet("font-size: 12pt;")
        wgtsCalcCmpltMsg.show()
        wgtsCalcCmpltMsg.exec_()
        
        
    def respCmpltMsg(self):
        wgtsCalcCmpltMsg = QMessageBox()
        wgtsCalcCmpltMsg.setText("WofE Modeling COMPLETE. \n\
        \n\
All the results are added to the current QGIS project.\n\
\n\
 ")
        wgtsCalcCmpltMsg.setStyleSheet("font-size: 12pt;")
        wgtsCalcCmpltMsg.show()
        wgtsCalcCmpltMsg.exec_()    
    
    
    def loadRasters(self):
        self.dlg.cb_raster.clear()
        #self.dlg.cb_xtnt_rstr.clear()
        #self.dlg.cb_xtnt_rstr_rsp.clear()
        layers=[layer for layer in QgsProject.instance().mapLayers().values()]
        raster_layers=[]
        for layer in layers:
            if layer.type()==QgsMapLayer.RasterLayer:
                raster_layers.append(layer.name())
        self.dlg.cb_raster.addItems(raster_layers)   
        #self.dlg.cb_xtnt_rstr.addItems(raster_layers)
        #self.dlg.cb_xtnt_rstr_rsp.addItems(raster_layers)
        
    def openRaster(self):
        """Open raster from file dialog"""
        inFile=str(QFileDialog.getOpenFileName(caption="Add raster to map project", filter="Evidence raster (*.tif)")[0])
        name = str.split(os.path.basename(inFile), ".")
        base=os.path.basename(inFile)
        name_ = os.path.splitext(base)[0]
        
        if inFile is not None:
            self.iface.addRasterLayer(inFile, str.split(os.path.basename(inFile), ".")[0])
            self.loadRasters()
                # Add the selected filename to combobox
            self.dlg.cb_raster.addItem(name_)
            
            # Obtain index of newly-added item
            index = self.dlg.cb_raster.findText(name_)
            # Set the combobox to select the new item
            self.dlg.cb_raster.setCurrentIndex(index)
            
    
    
    def loadVectors(self):
        self.dlg.cb_shp.clear()
        layers=[layer for layer in QgsProject.instance().mapLayers().values()]
        vector_layers=[]
        for layer in layers:
            if layer.type()==QgsMapLayer.VectorLayer:
                vector_layers.append(layer.name())
        self.dlg.cb_shp.addItems(vector_layers)
    
    def openVector(self):
        """Open vector layer from file dialog""" 
        inFile_v=str(QFileDialog.getOpenFileName(caption="Add trainng deposit layer to map project", filter="Layers (*.shp)")[0])
        name = str.split(os.path.basename(inFile_v), ".")
        base=os.path.basename(inFile_v)
        name_ = os.path.splitext(base)[0] 
        if inFile_v is not None:
            self.iface.addVectorLayer(inFile_v, name_, 'ogr')
            self.loadVectors()
            # Add the selected filename to combobox
            self.dlg.cb_shp.addItem(name_)
            # Obtain index of newly-added item
            index = self.dlg.cb_shp.findText(name_)
            # Set the combobox to select the new item
            self.dlg.cb_shp.setCurrentIndex(index)

            
    def openMask(self):
        """Open vector layer from file dialog"""
        inFile=str(QFileDialog.getOpenFileName(caption="Add mask layer to map project", filter="Layers (*.shp)")[0])
        name = str.split(os.path.basename(inFile), ".")
        base=os.path.basename(inFile)
        name_ = os.path.splitext(base)[0] 
        if inFile is not None:
            self.iface.addVectorLayer(inFile, name_, 'ogr')
            self.loadVectors()
            #self.dlg.comboBox.addItem(inFile)
            
            # Add the selected filename to combobox
            self.dlg.cb_msk.addItem(name_)
            #Obtain index of newly-added item
            index = self.dlg.cb_msk.findText(name_)
            # Set the combobox to select the new item
            self.dlg.cb_msk.setCurrentIndex(index)
            
            ## Adding the mask layer to 'Calculate Weights' Tab
            self.dlg.cb_msk_wgt.addItem(name_)
            #Obtain index of newly-added item
            index = self.dlg.cb_msk_wgt.findText(name_)
            # Set the combobox to select the new item
            self.dlg.cb_msk_wgt.setCurrentIndex(index)
            
            ## Adding the mask layer to 'Calculate Responses' Tab
            self.dlg.cb_msk_resp.addItem(name_)
            #Obtain index of newly-added item
            index = self.dlg.cb_msk_resp.findText(name_)
            # Set the combobox to select the new item
            self.dlg.cb_msk_resp.setCurrentIndex(index)
    
    
    
    
    def openVectorRsp(self):
        """Open vector layer from file dialog"""
        inFile=str(QFileDialog.getOpenFileName(caption="Add trainng deposit layer to map project", filter="Layers (*.shp)")[0])
        name = str.split(os.path.basename(inFile), ".")
        base=os.path.basename(inFile)
        name_ = os.path.splitext(base)[0] 
        if inFile is not None:
            self.iface.addVectorLayer(inFile, name_, 'ogr')
            self.loadVectors()
            self.dlg.cb_trng_rsp.addItem(name_)
            # Obtain index of newly-added item
            index = self.dlg.cb_trng_rsp.findText(name_)
            # Set the combobox to select the new item
            self.dlg.cb_trng_rsp.setCurrentIndex(index)
    
    
    def select_scratch_folder(self):
        global scratch_dir
        scratch_dir = QFileDialog.getExistingDirectory (None, "Open a folder" ," /home/my_user_name/ " , QFileDialog.ShowDirsOnly)
        self.dlg.le_scrt.setText(scratch_dir)
        self.dlg.le_scrt_wgt.setText(scratch_dir)
        self.dlg.le_scrt_resp.setText(scratch_dir)
        
    def select_working_folder(self):
        global working_dir
        working_dir = QFileDialog.getExistingDirectory (None, "Open a folder" ," /home/my_user_name/ " , QFileDialog.ShowDirsOnly)
        self.dlg.le_wrk.setText(working_dir)
        self.dlg.le_wrk_wgt.setText(working_dir)
        self.dlg.le_wrk_resp.setText(working_dir)
        
    def saveBnRaster(self):
        """Get the save file name for the inverted raster from a file dialog"""
        outFile=str(QFileDialog.getSaveFileName(caption="Save raster as", filter="Raster (*.tif)")[0])
        self.setBnRasterLine(outFile)
    
    def setBnRasterLine(self, text):
        """Set the GUI text for the inverted raster filename"""
        self.dlg.le_save_bn_rstr.setText(text)
    
    def saveWgtRaster(self):
        """Get the save file name for the inverted raster from a file dialog"""
        outFile=str(QFileDialog.getSaveFileName(caption="Save raster as", filter="Raster (*.tif)")[0])
        self.setWgtRasterLine(outFile)
  
    def setWgtRasterLine(self, text):
        """Set the GUI text for the inverted raster filename"""
        self.dlg.le_save_wgts_rstr.setText(text)

    def saveMltbRaster(self):
        """Get the save file name for the inverted raster from a file dialog"""
        outFile=str(QFileDialog.getSaveFileName(caption="Save raster as", filter="Raster (*.tif)")[0])
        self.setMltbRasterLine(outFile)
  
    def setMltbRasterLine(self, text):
        """Set the GUI text for the inverted raster filename"""
        self.dlg.le_save_mltb_rstr.setText(text)


    def saveTable(self):
        """Get the save file name for the weights table from a file dialog"""
        outFile=str(QFileDialog.getSaveFileName(caption="Save weights table as", filter="Text (*.csv)")[0])
        self.setTableLine(outFile)
      
    def setTableLine(self, text):
        """Set the GUI text for the raster filename"""
        self.dlg.le_save_wgts_tbl.setText(text) 
    

    def prepro(self):
       
        #Step 1: Clipping of rasters
        unt_area_km2 = self.dlg.le_unt_area.text()
        flt_unt_area_km2 = float(unt_area_km2)
        unt_m = int((math.sqrt(flt_unt_area_km2)*1000))
     
        # Mask Layer
        msk_name= self.dlg.cb_msk.currentText()
        msk_layer = QgsProject().instance().mapLayersByName(msk_name)[0]
        # msk_src = msk_layer.source()
        
        # Compute entries from filenames of layers added in the listwidget
        paths = names_evr       
        lst =  [QgsRasterLayer(str(path)) for path in paths]
        
        for lyr in lst:
            inp = lyr
            path = inp.source()
            rstr_baseName = str.split(os.path.basename(path), ".")
            ot_rsmpl = scratch_dir + '/' + rstr_baseName[0] +'_rsmpl' + '.tif'
            ot_c = working_dir + '/' + rstr_baseName[0] +'_clip' + '.tif'
            
            data = gdal.Open(path, gdalconst.GA_ReadOnly)
            gdal.Warp(ot_rsmpl, data, format = 'GTiff', xRes = unt_m, yRes = unt_m) 
            
            processing.run('gdal:cliprasterbymasklayer',
               {'ALPHA_BAND' : False, 
               'CROP_TO_CUTLINE' : True, 
               'DATA_TYPE' : 6, 
               'INPUT' : ot_rsmpl, 
               'KEEP_RESOLUTION' : False, 
               'MASK' : msk_layer, 
               'MULTITHREADING' : False, 
               'NODATA' :  -999999999, 
               'OPTIONS' : '', 
               'OUTPUT' : ot_c, 
               'SET_RESOLUTION' : False, 
               'SOURCE_CRS' : None, 
               'TARGET_CRS' : None, 
               'X_RESOLUTION' : None, 
               'Y_RESOLUTION' : None} )

            qgis.utils.iface.addRasterLayer(ot_c)
    
        #Step 2: Rasterize training sites
        
        ##Rasterization of training sites
        trng_name= self.dlg.cb_shp.currentText()
        trng_layer = QgsProject().instance().mapLayersByName(trng_name)[0]
        path_trng = trng_layer.source()
        layer = trng_layer
        #next 13 lines refer I-B 
        #St_Area_Rst = ot_c
        St_Area_Rst = ot_rsmpl
        dim = gdal.Open(St_Area_Rst,gdalconst.GA_ReadOnly)
        xoff,a,b,yoff,d,e = dim.GetGeoTransform()
        band1= dim.GetRasterBand(1)
        rows = dim.RasterYSize
        cols = dim.RasterXSize
        Total_pixel = (rows*cols)
        extent = layer.extent()
        xmin = xoff
        xmax = xoff + (a*cols)
        ymin = yoff + (e*rows)
        ymax = yoff
         
        '''
        #Sample code to save the file to the same directory as the inpput
        output_loc_name = str(os.path.dirname(path))
        output_new = output_loc_name + '/temp_trng_rstr.tif'
        output = output_new
        '''
        
        
        global dep_rst_clip
        dep_rst = scratch_dir + '/trng_rst.tif'
        dep_rst_clip = scratch_dir + '/' + 'dep_rst_clip.tif'
        
        field_name = "Dep_ID"
        field_index = layer.fields().indexFromName(field_name)

        if field_index != -1:
                   
            processing.run("gdal:rasterize",
                               {"INPUT":layer,
                               "FIELD":"Dep_ID",
                               "UNITS": 0,
                               "DIMENSIONS":0,
                               "WIDTH":cols,
                               "HEIGHT":rows,
                               "EXTENT":"%f,%f,%f,%f"% (xmin, xmax, ymin, ymax),
                               "TFW":1,
                               "RTYPE":0,
                               "NO_DATA":0,
                               "COMPRESS":0,
                               "JPEGCOMPRESSION":1,
                               "ZLEVEL":1,
                               "PREDICTOR":1,
                               "TILED":False,
                               "BIGTIFF":2,
                               "EXTRA": '',
                               "OUTPUT":dep_rst})
            #target_ds = None
           
            ##Clipping training sites raster to extent mask
            msk_c_name= self.dlg.cb_msk.currentText()
            msk_c_layer = QgsProject().instance().mapLayersByName(msk_c_name)[0]
            msk_c_src = msk_c_layer.source()
            mask_c = msk_c_layer

            processing.run('gdal:cliprasterbymasklayer',
               {'ALPHA_BAND' : False, 
               'CROP_TO_CUTLINE' : True, 
               'DATA_TYPE' : 0, 
               'INPUT' : dep_rst, 
               'KEEP_RESOLUTION' : False, 
               'MASK' : msk_layer, 
               'MULTITHREADING' : False, 
               'NODATA' : -999999999,
               'OPTIONS' : '', 
               'OUTPUT' : dep_rst_clip, 
               'SET_RESOLUTION' : False, 
               'SOURCE_CRS' : None, 
               'TARGET_CRS' : None, 
               'X_RESOLUTION' : None, 
               'Y_RESOLUTION' : None} )
            
            #résampling the deposit raster to ensure cell size
            #ot_dep_rsmpl is used for all three tools in the plugin
            global ot_dep_rsmpl 
            ot_dep_rsmpl = working_dir + '/' + 'Training_sites' + '.tif'
            gdal.Warp(ot_dep_rsmpl, dep_rst_clip, format = 'GTiff', xRes = unt_m, yRes = unt_m)
            qgis.utils.iface.addRasterLayer(ot_dep_rsmpl)
            self.preProCmptMsg()
            self.tab_close()
        
        else: 
            self.depMsg()
     
    def wgtsCalc(self):
    
            msk_name= self.dlg.cb_msk_wgt.currentText()
            msk_layer = QgsProject().instance().mapLayersByName(msk_name)[0]
            ot_dep_rsmpl = working_dir + '/' + 'Training_sites' + '.tif'
            raster_name= self.dlg.cb_raster.currentText()
            raster_layer = QgsProject().instance().mapLayersByName(raster_name)[0]
            path_ev_rst = raster_layer.source()
            feat = gdal.Open(path_ev_rst, gdalconst.GA_ReadOnly)
            
            dim = feat
            xoff,a,b,yoff,d,e = dim.GetGeoTransform()
            band1= dim.GetRasterBand(1)
            rows = dim.RasterYSize
            cols = dim.RasterXSize
            ###ReadData = band1.ReadAsArray(0,0,cols,rows)
            Total_pixel = (rows*cols)
            xmin = xoff
            xmax = xoff + (a*cols)
            ymin = yoff + (e*rows)
            ymax = yoff
            
            #Creating a numpy array from the feature raster file
            Geol = np.array(feat.GetRasterBand(1).ReadAsArray())
            #getting the number of pixels in the feature raster 
            feat_size = np.size(Geol)
            NaN_cnt=  np.count_nonzero(Geol <= -1000000000)
            tot_pxls = feat_size - NaN_cnt

            #Opening the rasterized training deposit layer
            dep = gdal.Open(ot_dep_rsmpl)
            #Creating a numpy array from the deposit raster file
            Dep = np.array(dep.GetRasterBand(1).ReadAsArray())
            #Getting the number of pixels in the deposit raster 
            dep_size = np.size(Dep)
            
            #Count of deposit-pixels and no-deposit-pixels; 
            #The size of each deposit is equal to unit cell size of the input predictor map
            dep1s = np.count_nonzero(Dep == 1)
            dep0s = np.count_nonzero(Dep == 0)
            
            #Making 1-D array from the 2D arrays of input data, 
            #to enable grouping them into the pandas dataframe
            d_flat = Dep.flatten()
            g_flat = Geol.flatten()
           
            #Creating pandas dataframe for subsequent calculations
            df = pd.DataFrame({"A": g_flat, "B": d_flat})
            
            temp_csv1 = scratch_dir + '/' + 'temp_680.csv'
            df.to_csv(temp_csv1, sep='\t')
            
            Geol_Dep = df.groupby("A")["B"]
            # getting unique values (classes) of the input predictor raster
            Geol_Unq = np.unique(g_flat) 
            # count of unique values in the input predictor raster Geol
            Geol_Cnt = Geol_Dep.count() 
            # count of pixels for each unique values (classes) with deposit
            Geol_Sum = Geol_Dep.sum() 
            
            
            # # count of pixels for each unique values (classes) without deposit
            Geol_NoDep = Geol_Dep.count() - Geol_Dep.sum() 
            dep_unq= np.unique(d_flat)
            
            dff = pd.DataFrame({"Class": Geol_Unq, "Count" : Geol_Cnt, "Geol_Dep_Count" : Geol_Sum, \
                "No Dep Cnt" : Geol_NoDep, "Total Area": tot_pxls, "Total Deposits": dep1s, "Tot No Dep Cnt": dep0s, \
                })
            temp_csv2 = scratch_dir + '/' + 'temp_699.csv'
            dff.to_csv(temp_csv2, sep='\t')


           # EXCEPTIONS: 
            #Below line handles the exception in W+ calculations when a class does not have any deposits
            dff["Geol_Dep_Count"].replace(0, 0.001, inplace = True) 
            #Below line handles the exception
            dff["No Dep Cnt"].replace(0, 0.001, inplace = True)


            dff["Dep_outsidefeat"] = dff["Total Deposits"] - dff["Geol_Dep_Count"]
            Dep_outsidefeat = dff["Total Deposits"] - dff["Geol_Dep_Count"]
            
            dff["Non_feat_Pxls"] = dff["Total Area"] - dff["Count"]
            dff["Non_Feat_Non_Dep"] = dff["Non_feat_Pxls"] - dff["Dep_outsidefeat"]
            
            Non_Feat_Non_Dep = dff["Non_feat_Pxls"] - dff["Dep_outsidefeat"]
            
            # EXCEPTIONS: 
            #Below line handles the exception 
            dff["Dep_outsidefeat"].replace(0, 0.001, inplace = True) 
            dff["Non_Feat_Non_Dep"].replace(0, 0.001, inplace = True)

            
            dff = pd.DataFrame({"Class": Geol_Unq, "Count" : Geol_Cnt, "Geol_Dep_Count" : Geol_Sum, \
                "No Dep Cnt" : Geol_NoDep, "Total Area": tot_pxls, "Total Deposits": dep1s, \
                "Tot No Dep Cnt": dep0s, "Dep_outsidefeat": Dep_outsidefeat, "Non_Feat_Non_Dep": Non_Feat_Non_Dep})
            
            wgts_type = ['Categorical', 'Ascending', 'Descending']
            slctd_wgts_type = self.dlg.cb_wgts_type.currentText()
            
            if slctd_wgts_type == wgts_type[0]:
                # Positive weights and it's standard deviation
                dff["Num_wpls"] = dff["Geol_Dep_Count"]/dff["Total Deposits"]
                # EXCEPTION: Below line handles the exception in W+ calculations the numerator of W+ becomes 1
                dff["Num_wpls"].replace(1, 1.001, inplace = True) 
                # EXCEPTION: 
                dff["Num_wpls"].replace(0, 0.0001, inplace = True)
                # EXCEPTION:
                dff["Geol_Dep_Count"].replace(0, 0.0001, inplace = True)
                # Calculations
                dff["Deno_wpls"] = dff["No Dep Cnt"]/dff["Tot No Dep Cnt"]
                wpls = np.log(dff.Num_wpls) - np.log(dff.Deno_wpls)
                var_wpls = (1/dff["Geol_Dep_Count"]) +(1/dff["No Dep Cnt"])
                s_wpls = np.sqrt(var_wpls)
 
                # Negative weights and it's standard deviation
                dff["Num_wmns"] = (dff["Total Deposits"]-dff["Geol_Dep_Count"])/dff["Total Deposits"]
                ## the denominator for w_mins
                dff["Dep_outsidefeat"] = dff["Total Deposits"] - dff["Geol_Dep_Count"]
                Dep_outsidefeat = dff["Total Deposits"] - dff["Geol_Dep_Count"]
                
                dff["Non_feat_Pxls"] = dff["Total Area"] - dff["Count"]
                dff["Non_Feat_Non_Dep"] = dff["Non_feat_Pxls"] - dff["Dep_outsidefeat"]
                Non_Feat_Non_Dep = dff["Non_feat_Pxls"] - dff["Dep_outsidefeat"]
                
                dff["Deno_wmns"] = (dff["Non_feat_Pxls"] - dff["Dep_outsidefeat"])/dff["Tot No Dep Cnt"]
                
                # EXCEPTION: Below two lines handle the exception in W- calculations when num == deno
                dff = dff.round(3)
                dff.loc[dff["Num_wmns"]== dff["Deno_wmns"], "Num_wmns" ] = 1.001
                
                #This exception code in below line does not seem to work?
                dff["Deno_wmns"].replace(0, 0.001, inplace = True)
              
                # above calculations in one singe line
                ###dff["Deno_wmns"] = ((dff["Total Area"]-dff["Count"]) - (dff["Total Deposits"] - dff["Geol_Dep_Count"])/dff["Tot No Dep Cnt"]
                wmns = np.log(dff.Num_wmns) - np.log(dff.Deno_wmns)
                var_wmns =(1/Dep_outsidefeat) +(1/Non_Feat_Non_Dep)
                s_wmns = np.sqrt(var_wmns)
                
                cntrst = wpls - wmns
                s_cntrst = np.sqrt(var_wpls + var_wmns)
                stud_cntrst = cntrst/s_cntrst
                
                dff1 = pd.DataFrame({"Class": Geol_Unq, "Count" : Geol_Cnt, \
                "Geol_Dep_Count" : Geol_Sum, "No Dep Cnt" : Geol_NoDep, "Total Area": tot_pxls, \
                "Total Deposits": dep1s, "Tot No Dep Cnt": dep0s, "wpls": wpls, "s_wpls": s_wpls, "var_wpls": var_wpls,\
                "wmns": wmns, "s_wmns": s_wmns, "Contrast": cntrst, "S_Contrast": s_cntrst, "Stud_Cont": stud_cntrst,\
                "Gen_Class": Geol_Unq, "Gen_W":  wpls, "S_Gen_W": s_wpls})
               
                dff1_round = dff1.round(4)

                #Creating the weights raster
                
                mapping_w = {}
                mapping_w = pd.Series(dff1_round.wpls.values,index=dff1_round.Class).to_dict()
               
                # create the output image
                driver = dim.GetDriver()
                #print driver
                wgts_rst=self.dlg.le_save_wgts_rstr.text()
                outRst = driver.Create(wgts_rst, cols, rows, 1, gdal.GDT_Float64)
                outBand = outRst.GetRasterBand(1)
                outData = np.zeros((rows,cols), np.float_)
                
                #Getting the shape of the raster array
                rstr_arry = band1.ReadAsArray(0,0,cols,rows)
                # Save the shape of the raster array
                s = rstr_arry.shape
                # Flatten the raster array
                rstr_arry = rstr_arry.reshape(-1)
                # Create 2D replacement matrix:
                replace = np.array([list(mapping_w.keys()), list(mapping_w.values())])
                # Find elements that need replacement:
                mask = np.in1d(rstr_arry, replace[0, :])
                ss = np.searchsorted(replace[0, :], rstr_arry[mask])
                # Replace the elements:
                rstr_arry = replace[1,ss] #stored the searchsorted part in variable ss; and removed [mask] from the LHS
              
                # Restore the shape of the raster array
                rstr_arry = rstr_arry.reshape(s)        
                outBand.WriteArray(rstr_arry, 0, 0)
                srs = osr.SpatialReference()
                srs.ImportFromWkt(dim.GetProjectionRef())
                outRst.SetProjection(srs.ExportToWkt())
                outBand.SetNoDataValue(-99)
                outRst.SetGeoTransform(dim.GetGeoTransform())
                outRst.FlushCache()
                qgis.utils.iface.addRasterLayer(wgts_rst)
               
               # Creating variance raster
                mapping_v = {}
                mapping_v = pd.Series(dff1_round.var_wpls.values,index=dff1_round.Class).to_dict()
                            
                str_wgts_rst = QgsRasterLayer(str(wgts_rst)) 
                inp_w = str_wgts_rst
                path_w = inp_w.source()
                rstr_baseName_w = str.split(os.path.basename(path_w), ".")
                var_rst = scratch_dir + '/' + rstr_baseName_w[0] +'_var_temp' + '.tif'
                std_rsttt = working_dir + '/' + rstr_baseName_w[0] +'_w_std' + '.tif'
               
                varRst = driver.Create(var_rst, cols, rows, 1, gdal.GDT_Float64)
                varBand = varRst.GetRasterBand(1)
                varData = np.zeros((rows,cols), np.float_)
                
                #Getting the shape of the raster array
                rstr_arry_var = band1.ReadAsArray(0,0,cols,rows)
                # Save the shape of the raster array
                s_var = rstr_arry_var.shape
                # Flatten the raster array
                rstr_arry_var = rstr_arry_var.reshape(-1)
                replace_var = np.array([list(mapping_v.keys()), list(mapping_v.values())])
                # Find elements that need replacement:
                mask_var = np.in1d(rstr_arry_var, replace[0, :])
                ss_var = np.searchsorted(replace_var[0, :], rstr_arry_var[mask_var])
                # Replace them:
                rstr_arry_var = replace_var[1,ss_var] #stored the searchsorted part in variable ss; and removed [mask] from the LHS
                # Restore the shape of the raster array
                rstr_arry_var = rstr_arry_var.reshape(s_var)        
                varBand.WriteArray(rstr_arry_var, 0, 0)
                varRst.SetProjection(srs.ExportToWkt())
                varBand.SetNoDataValue(-99)
                varRst.SetGeoTransform(dim.GetGeoTransform())
                varRst.FlushCache()
                
                # Clipping variance raster
                var_rst_clp = working_dir + '/' + rstr_baseName_w[0] +'_var' + '.tif'
                
                processing.run('gdal:cliprasterbymasklayer', {'ALPHA_BAND' : False, 'CROP_TO_CUTLINE' : True,
                   'DATA_TYPE' : 0, 'INPUT' : var_rst, 'KEEP_RESOLUTION' : False, 'MASK' : msk_layer, 'MULTITHREADING' : False, 
                   'NODATA' :  -999999999, 'OPTIONS' : '', 'OUTPUT' : var_rst_clp, 'SET_RESOLUTION' : False, 
                   'SOURCE_CRS' : None, 'TARGET_CRS' : None,'X_RESOLUTION' : None, 'Y_RESOLUTION' : None} )
                
                qgis.utils.iface.addRasterLayer(var_rst_clp)
   
                # Creating Standard deviation of weights raster
                mapping_s = {}
                mapping_s = pd.Series(dff1_round.s_wpls.values,index=dff1_round.Class).to_dict()
                
                std_rstt = scratch_dir + '/' + rstr_baseName_w[0] +'_std_tmp' + '.tif'
                std_rst_clp = working_dir + '/' + rstr_baseName_w[0] +'_std' + '.tif'
                stdRst = driver.Create(std_rstt, cols, rows, 1, gdal.GDT_Float64)
                stdBand = stdRst.GetRasterBand(1)
                stdData = np.zeros((rows,cols), np.float_)
                
                #Getting the shape of the raster array
                rstr_arry_std = band1.ReadAsArray(0,0,cols,rows)
                # Save the shape of the raster array
                s_std = rstr_arry_std.shape
                # Flatten the raster array
                rstr_arry_std = rstr_arry_std.reshape(-1)
                replace_std = np.array([list(mapping_s.keys()), list(mapping_s.values())])
                
                # Find elements that need replacement:
                mask_std = np.in1d(rstr_arry_std, replace[0, :])
                ss_std = np.searchsorted(replace_std[0, :], rstr_arry_std[mask_std])
                
                # Replace them:
                #rstr_arry[mask] = replace[1, numpy.searchsorted(replace[0, :], rstr_arry[mask])] #original code
                rstr_arry_std = replace_std[1,ss_std] #stored the searchsorted part in variable ss; and removed [mask] from the LHS
                # Restore the shape of the raster array
                rstr_arry_std = rstr_arry_std.reshape(s_std)        
                stdBand.WriteArray(rstr_arry_std, 0, 0)
                stdRst.SetProjection(srs.ExportToWkt())
                stdBand.SetNoDataValue(-99)
                stdRst.SetGeoTransform(dim.GetGeoTransform())
                stdRst.FlushCache()
                
                ## CLIPPING the standard deviation of weights raster
             
                processing.run('gdal:cliprasterbymasklayer', {'ALPHA_BAND' : False, 'CROP_TO_CUTLINE' : True,
                   'DATA_TYPE' : 0, 'INPUT' : std_rstt, 'KEEP_RESOLUTION' : False, 'MASK' : msk_layer, 'MULTITHREADING' : False, 
                   'NODATA' :  -999999999, 'OPTIONS' : '', 'OUTPUT' : std_rst_clp, 'SET_RESOLUTION' : False, 
                   'SOURCE_CRS' : None, 'TARGET_CRS' : None,'X_RESOLUTION' : None, 'Y_RESOLUTION' : None} )
                
                qgis.utils.iface.addRasterLayer(std_rst_clp)
               
                #Creating the multiband raster
            
                lst_mltb = [path_ev_rst, wgts_rst, var_rst_clp]
                paths = lst_mltb
                lst_mltb1 =  [QgsRasterLayer(str(path)) for path in paths]
                mltb_ot=self.dlg.le_save_mltb_rstr.text()          
                mltb = scratch_dir + '/' + rstr_baseName_w[0] +'mltb' + '.tif'
   
                processing.run('gdal:merge',
                                {'DATA_TYPE' : 6, 
                                'INPUT' : lst_mltb1, 
                                'NODATA_INPUT' : None, 
                                'NODATA_OUTPUT' : None, 
                                'OPTIONS' : '', 
                                'OUTPUT' : mltb, 
                                'PCT' : False, 
                                'SEPARATE' : True })

                
                ## CLIPPING the Multiband raster to shape

                processing.run('gdal:cliprasterbymasklayer',
                   {'ALPHA_BAND' : False, 
                   'CROP_TO_CUTLINE' : True, 
                   'DATA_TYPE' : 0, 
                   'INPUT' : mltb, 
                   'KEEP_RESOLUTION' : False, 
                   'MASK' : msk_layer, 
                   'MULTITHREADING' : False, 
                   'NODATA' :  -999999999, 
                   'OPTIONS' : '', 
                   'OUTPUT' : mltb_ot, 
                   'SET_RESOLUTION' : False, 
                   'SOURCE_CRS' : None, 
                   'TARGET_CRS' : None, 
                   'X_RESOLUTION' : None, 
                   'Y_RESOLUTION' : None} )
                
                qgis.utils.iface.addRasterLayer(mltb_ot)
                
                # Saving weights table
                # Defining the columns of dataframe again after removal of the 'var_wpls' column
                # Let the below code be here for reference, do not delete it
                '''
                dff1 = pd.DataFrame({"Class": Geol_Unq, "Count" : Geol_Cnt, \
                "Geol_Dep_Count" : Geol_Sum, "No Dep Cnt" : Geol_NoDep, "Total Area": tot_pxls, \
                "Total Deposits": dep1s, "Tot No Dep Cnt": dep0s, "wpls": wpls, "s_wpls": s_wpls, \
                "wmns": wmns, "s_wmns": s_wmns, "Contrast": cntrst, "S_Contrast": s_cntrst, "Stud_Cont": stud_cntrst,\
                "Gen_Class": Geol_Unq, "Gen_W":  wpls, "S_Gen_W": s_wpls})
                '''
            
                #Redefining the dataframe with final column names; 
                dff1 = pd.DataFrame({"Class": Geol_Unq, "Count" : Geol_Cnt, 
                "Point Count" : Geol_Sum,"W_Plus": wpls, "S_WPlus": s_wpls, 
                "W_Minus": wmns, "S_WMinus": s_wmns, "Contrast": cntrst, 
                "S_Contrast": s_cntrst, "Stud. Contrast": stud_cntrst,
                "Gen. Class": Geol_Unq, "Weights":  wpls, "S_Weights": s_wpls})
   
                # Removing 'no data' values from weights table
                dff1=dff1.set_index("Class")
                dff1 = dff1.drop(-1000000000.0, axis = 0)
                dff1_round = dff1.round(4)
                wgts_tab=self.dlg.le_save_wgts_tbl.text()
                dff1_round.to_csv(wgts_tab, sep='\t')
                self.iface.addVectorLayer(wgts_tab, '', 'ogr') 
          
          
            elif slctd_wgts_type != wgts_type[0]:        
                if slctd_wgts_type == wgts_type[1]:
                
                    dff.loc[dff.Class <= -1000000000.0, 'N_cls'] = 'NaN'
                    dff.loc[dff.Class > -1000000000.0, 'N_cls'] = 'Data'
                    
                    df_rcl=dff.groupby('N_cls')
                    
                    df_rcl.get_group('Data')
                    df_rcl_dt =df_rcl.get_group('Data')
                    
                    #Sorting 'Class' in ascending order
                    dff_srtd = df_rcl_dt.sort_values(by = "Class", ascending=True)
                    
                    ##dff_srtd.to_csv(r'C:/GTK_Plugin/Data_Mawson/temp1/dff_asc.csv', sep='\t')
                    ##self.iface.addVectorLayer(r'C:/GTK_Plugin/Data_Mawson/temp1/dff_asc.csv', '', 'ogr')
                    
                    
                elif slctd_wgts_type == wgts_type[2]:
                    
                    dff.loc[dff.Class <= -1000000000.0, 'N_cls'] = 'NaN'
                    dff.loc[dff.Class > -1000000000.0, 'N_cls'] = 'Data'
                    
                    df_rcl=dff.groupby('N_cls')
                    
                    df_rcl.get_group('Data')
                    df_rcl_dt =df_rcl.get_group('Data')
                    
                    #Sorting 'Class' in descending order
                    dff_srtd = df_rcl_dt.sort_values(by = "Class", ascending=False)
                    
                #Getting cumulartive count of the number of pixels and that of the number of deposits
                cumu_dep_cnt = dff_srtd["Geol_Dep_Count"].cumsum()
                dff_srtd["cumu_cnt"] = dff_srtd["Count"].cumsum()
                dff_srtd["cumu_dep_cnt"] = dff_srtd["Geol_Dep_Count"].cumsum()
                dff_srtd["cumu_no_dep_cnt"] = dff_srtd["No Dep Cnt"].cumsum()
                    
                # EXCEPTIONS: 
                #Below line handles the exception in W+ calculations when a class does not have any deposits
                dff_srtd["cumu_dep_cnt"].replace(0, 0.001, inplace = True) 
                #Below line handles the exception 
                dff_srtd["cumu_no_dep_cnt"].replace(0, 0.001, inplace = True)
                
                # Positive weights and it's standard deviation
                dff_srtd["Num_wpls"] = dff_srtd["cumu_dep_cnt"]/dff_srtd["Total Deposits"]
                dff_srtd["Deno_wpls"] = dff_srtd["cumu_no_dep_cnt"]/dff_srtd["Tot No Dep Cnt"]
                
                # EXCEPTION: Below line handles the exception in W+ calculations the numerator of W+ becomes 1
                dff_srtd["Num_wpls"].replace(1, 1.001, inplace = True)
                
                wpls = np.log(dff_srtd.Num_wpls) - np.log(dff_srtd.Deno_wpls)
                var_wpls = (1/dff_srtd["cumu_dep_cnt"]) +(1/dff_srtd["cumu_no_dep_cnt"])
                s_wpls = np.sqrt(var_wpls)
                dff_srtd["s_wpls"] = s_wpls
                dff_srtd["var_wpls"] = var_wpls    

                # Negative weights and it's standard deviation
                dff_srtd["Num_wmns"] = (dff_srtd["Total Deposits"]-dff_srtd["cumu_dep_cnt"])/dff_srtd["Total Deposits"]
                
                # Exception:
                dff_srtd["Num_wmns"].replace(0, 0.001, inplace = True) 
                
                ## the denominator for w_mns
                dff_srtd["Cumu_Non_feat_Pxls"] = dff_srtd["Total Area"] - dff_srtd["cumu_cnt"]
                dff_srtd["Cumu_Dep_outsidefeat"] = dff_srtd["Total Deposits"] - dff_srtd["cumu_dep_cnt"]
                Cumu_Dep_outsidefeat = dff_srtd["Total Deposits"] - dff_srtd["cumu_dep_cnt"]
                Cumu_Non_Feat_Non_Dep = dff_srtd["Cumu_Non_feat_Pxls"] - dff_srtd["Cumu_Dep_outsidefeat"]
                dff_srtd["Cumu_Non_Feat_Non_Dep"] = dff_srtd["Cumu_Non_feat_Pxls"] - dff_srtd["Cumu_Dep_outsidefeat"]
                
                # EXCEPTIONS: These exceptions are probably not needed
                #Below line handles the exception 
                ####dff_srtd["Cumu_Dep_outsidefeat"].replace(0, 0.001, inplace = True) 
                ####dff_srtd["Cumu_Non_Feat_Non_Dep"].replace(0, 0.001, inplace = True)
                ####dff_srtd["Cumu_Non_feat_Pxls"].replace(0, 0.001, inplace = True)
                #print(dff_srtd.Cumu_Non_feat_Pxls)
                #print(dff_srtd.Cumu_Dep_outsidefeat)
                #print(dff_srtd.Tot No Dep Cnt)
                
                dff_srtd["Deno_wmns"] = (dff_srtd["Cumu_Non_feat_Pxls"] - dff_srtd["Cumu_Dep_outsidefeat"])/dff["Tot No Dep Cnt"]
                
                # EXCEPTIONS: 
                dff_srtd["Deno_wmns"].replace(0, 0.001, inplace = True)

                # EXCEPTION: Below two lines handle the exception in W- calculations when num == deno
                dff_srtd = dff_srtd.round(3)
                dff_srtd.loc[dff_srtd["Num_wmns"]== dff_srtd["Deno_wmns"], "Num_wmns" ] = 1.001
                    
                wmns = np.log(dff_srtd.Num_wmns) - np.log(dff_srtd.Deno_wmns)
                dff_srtd["var_wmns"] =(1/dff_srtd.Cumu_Dep_outsidefeat) +(1/dff_srtd.Cumu_Non_Feat_Non_Dep)
                
                dff_srtd.loc[~np.isfinite(dff_srtd["var_wmns"]), "var_wmns"] = 2000
                
                dff_srtd["s_wmns"] = np.sqrt(dff_srtd.var_wmns)
                s_wmns = dff_srtd["s_wmns"]
                
                dff_srtd["wpls"] = wpls
                dff_srtd["wmns"] = wmns
                
                dff_srtd["cntrst"] = dff_srtd["wpls"] - dff_srtd["wmns"]
                dff_srtd["s_cntrst"] = np.sqrt(dff_srtd.var_wpls + dff_srtd.var_wmns)
                dff_srtd["stud_cntrst"] = dff_srtd.cntrst/dff_srtd.s_cntrst
                
                #temp_csv = scratch_dir + '/' + 'temp.csv'
                #dff_srtd.to_csv(temp_csv , sep='\t')
                
                user_std_cnt=float(self.dlg.le_stud_cnt.text())
                               
                dff_srtd['Rcls'] = dff_srtd.stud_cntrst.ge(user_std_cnt)[::-1].cummax()+1

                
                stud_cntrst_df = dff_srtd[['Class','cntrst','stud_cntrst','Rcls']]
                stud_cntrst_df= stud_cntrst_df.round(4)
                stud_cntrst_csv = scratch_dir + '/' + 'Calc_Stud_Cont.csv'
                stud_cntrst_df.to_csv(stud_cntrst_csv , sep='\t')
                
                rcls1 = 1
                rcls2 = 2
                if rcls1 not in dff_srtd['Rcls'].values:
                    self.iface.addVectorLayer(stud_cntrst_csv, '', 'ogr')
                    self.rcls1ErrMsg()
                    self.tab_close()
                    
                if rcls2 not in dff_srtd['Rcls'].values:
                    self.iface.addVectorLayer(stud_cntrst_csv, '', 'ogr')
                    self.rcls2ErrMsg()
                    self.tab_close()
               
                Rcls_v = dff_srtd['Rcls']
                
                cntrst = dff_srtd['cntrst']
                s_cntrst = dff_srtd['s_cntrst']
                stud_cntrst = dff_srtd['stud_cntrst']
                
                dff_srtd_round = dff_srtd.round(4)
                dff_srtd_round = dff_srtd_round.sort_values(by = "Class", ascending=True)
                df_rcl=dff.groupby('N_cls')
                df_rcl_ndt =df_rcl.get_group('NaN')
                frames = [dff_srtd_round, df_rcl_ndt]
                dff_srtd_round = pd.concat(frames)
                dff_srtd_round.loc[dff_srtd_round.Class <= -1000000000, 'W'] = -99
                dff_srtd_round.loc[dff_srtd_round.Class <= -1000000000, 'Rcls'] = -99

                # Creating binary raster
                
                mapping_bnry = {}
                mapping_bnry = pd.Series(dff_srtd_round.Rcls.values,index=dff_srtd_round.Class).to_dict() 
                
                print('mapping_bnry')
                print(mapping_bnry)
                
                # create the output image
                driver = dim.GetDriver()
                #Getting the shape of the raster array
                raster_name= self.dlg.cb_raster.currentText()
                raster_layer = QgsProject().instance().mapLayersByName(raster_name)[0]
                path = raster_layer.source()
                feat = gdal.Open(path, gdalconst.GA_ReadOnly)
                dim = feat
                xoff,a,b,yoff,d,e = dim.GetGeoTransform()
                band1= dim.GetRasterBand(1)
                rows = dim.RasterYSize
                cols = dim.RasterXSize
                rstr_arry = band1.ReadAsArray(0,0,cols,rows)
                               
                # Save the shape of the raster array
                s = rstr_arry.shape
                #print('s')
                #print(s)
                
                # Flatten the raster array
                rstr_arry = rstr_arry.reshape(-1)
                # Create 2D replacement matrix:
                ##replace = np.array([list(mapping.keys()), list(mapping.values())]) #(for the weights replacement)
                replace = np.array([list(mapping_bnry.keys()), list(mapping_bnry.values())]) #(for the reclassification replacement)
                #print('replace')
                #print(replace)
                # Find elements that need replacement:
                mask = np.in1d(rstr_arry, replace[0, :])
                #print('mask')
                #print(mask)
                ss = np.searchsorted(replace[0, :], rstr_arry[mask])
                #print('ss')
                #print(ss)
                # Replace them:
                rstr_arry = replace[1,ss] 
                # Restore the shape of the raster array
                rstr_arry = rstr_arry.reshape(s)        
                srs = osr.SpatialReference()
                srs.ImportFromWkt(dim.GetProjectionRef())
                #srs.ImportFromEPSG(3112) #the gda  projection
 
                ## Binary raster creation
                bn_rst1 = scratch_dir + '/' + 'bn_rst_whole.tif'
                outBnRst = driver.Create(bn_rst1, cols, rows, 1, gdal.GDT_Float32)
                outBand_Bn = outBnRst.GetRasterBand(1)
                outData_Bn = np.zeros((rows,cols), np.float_)
                outBand_Bn.WriteArray(rstr_arry, 0, 0)
                
                outBnRst.SetProjection(srs.ExportToWkt())
                outBand_Bn.SetNoDataValue(-99)
                outBnRst.SetGeoTransform(dim.GetGeoTransform())
                outBnRst.FlushCache()
                
                ## CLIPPING the Binary raster to shape
                bn_rst_clip = self.dlg.le_save_bn_rstr.text()
                
                processing.run('gdal:cliprasterbymasklayer', {'ALPHA_BAND' : False, 
                   'CROP_TO_CUTLINE' : True, 'DATA_TYPE' : 0, 'INPUT' : bn_rst1, 
                   'KEEP_RESOLUTION' : False, 'MASK' : msk_layer, 'MULTITHREADING' : False, 
                   'NODATA' :  -999999999, 'OPTIONS' : '', 'OUTPUT' : bn_rst_clip, 
                   'SET_RESOLUTION' : False, 'SOURCE_CRS' : None, 'TARGET_CRS' : None, 
                   'X_RESOLUTION' : None, 'Y_RESOLUTION' : None} )

                qgis.utils.iface.addRasterLayer(bn_rst_clip)
                 
                
                # CALCULATIONS OF GENERALIZED WEIGHTS AFTER RECLASSIFICATION
                
                # Calculations of generalized weights for Class 2
                
                df_rc=dff_srtd_round.groupby('Rcls')
                df_rc.get_group(2)
                df_rc_2=df_rc.get_group(2)

                df_rc_2["cumu_dep_cnt"] = df_rc_2["Geol_Dep_Count"].cumsum() 
                df_rc_2["cumu_cnt"] = df_rc_2["Count"].cumsum()
                df_rc_2["cumu_no_dep_cnt"] = df_rc_2["No Dep Cnt"].cumsum()
                df2_last = df_rc_2.iloc[[-1]]
                
                '''
                # EXCEPTIONS: 
                #Below line handles the exception in W+ calculations when a class does not have any deposits
                dff_srtd["cumu_dep_cnt"].replace(0, 0.001, inplace = True) 
                #Below line handles the exception 
                dff_srtd["cumu_no_dep_cnt"].replace(0, 0.001, inplace = True)
                '''    
                
                #positive weights and it's standard deviation
                df2_last["Num_wpls"] = df2_last["cumu_dep_cnt"]/df2_last["Total Deposits"]
                df2_last["Deno_wpls"] = df2_last["cumu_no_dep_cnt"]/df2_last["Tot No Dep Cnt"]

                '''    
                # EXCEPTION: Below line handles the exception in W+ calculations the numerator of W+ becomes 1
                dff_srtd["Num_wpls"].replace(1, 1.001, inplace = True)
                '''
                
                wpls_gen = np.log(df2_last.Num_wpls) - np.log(df2_last.Deno_wpls)
                var_wpls_gen = (1/df2_last.cumu_dep_cnt) +(1/df2_last.cumu_no_dep_cnt)
                #var_wpls_gen = (1/df2_last["cumu_dep_cnt"]) +(1/df2_last["cumu_no_dep_cnt"])
                s_wpls_gen = np.sqrt(var_wpls_gen)
                df2_last["w_gen"] = wpls_gen
                df2_last["s_wpls_gen"] = s_wpls_gen
                df2_last["var_wpls_gen"] = var_wpls_gen
                
                # Calculations of generalized weights for Class 1
                
                df_rc_1=df_rc.get_group(1)
                df_rc_1["cumu_dep_cnt"] = df_rc_1["Geol_Dep_Count"].cumsum()
                df_rc_1["cumu_cnt"] = df_rc_1["Count"].cumsum()
                df_rc_1["cumu_no_dep_cnt"] = df_rc_1["No Dep Cnt"].cumsum()
                df1_last = df_rc_1.iloc[[-1]]


                '''
                # EXCEPTIONS: 
                #Below line handles the exception in W+ calculations when a class does not have any deposits
                dff_srtd["cumu_dep_cnt"].replace(0, 0.001, inplace = True) 
                #Below line handles the exception --------------
                dff_srtd["cumu_no_dep_cnt"].replace(0, 0.001, inplace = True)
                '''    
                
                # positive weights and it's standard deviation
                df1_last["Num_wpls"] = df1_last["cumu_dep_cnt"]/df1_last["Total Deposits"]
                df1_last["Deno_wpls"] = df1_last["cumu_no_dep_cnt"]/df1_last["Tot No Dep Cnt"]

                '''    
                # EXCEPTION: Below line handles the exception in W+ calculations the numerator of W+ becomes 1
                dff_srtd["Num_wpls"].replace(1, 1.001, inplace = True)
                '''
                
                wpls_gen = np.log(df1_last.Num_wpls) - np.log(df1_last.Deno_wpls)
                var_wpls_gen = (1/df1_last.cumu_dep_cnt) +(1/df1_last.cumu_no_dep_cnt)
                #var_wpls_gen = (1/df1_last["cumu_dep_cnt"]) +(1/df1_last["cumu_no_dep_cnt"])
                s_wpls_gen = np.sqrt(var_wpls_gen)
                df1_last["w_gen"] = wpls_gen
                
                df1_last["s_wpls_gen"] = s_wpls_gen
                df1_last["var_wpls_gen"] = var_wpls_gen
                index = df1_last.columns.get_loc('w_gen')
            
                w1= df1_last.iloc[0,31]
                w2= df2_last.iloc[0,31]
                index_s_w1 = df1_last.columns.get_loc('s_wpls_gen')
                index_s_w2 = df1_last.columns.get_loc('s_wpls_gen')
                s_w1= df1_last.iloc[0,32]
                s_w2= df2_last.iloc[0,32]
                
                v_w1= df1_last.iloc[0,33]
                v_w2= df2_last.iloc[0,33]
 
                dff_srtd_round.loc[dff_srtd_round.Rcls  == 2, 'W'] = w2  
                dff_srtd_round.loc[dff_srtd_round.Rcls == 1, 'W'] = w1
                
                dff_srtd_round.loc[dff_srtd_round.Rcls  == 2, 's_wpls_gen'] = s_w2  
                dff_srtd_round.loc[dff_srtd_round.Rcls == 1, 's_wpls_gen'] = s_w1
                
                dff_srtd_round.loc[dff_srtd_round.Rcls  == 2, 'var_wpls_gen'] = v_w2  
                dff_srtd_round.loc[dff_srtd_round.Rcls == 1, 'var_wpls_gen'] = v_w1
                
                df_round = dff_srtd_round.round(4)
                
 
                '''
                df_round = pd.DataFrame({"Class": Geol_Unq, "Count" : Count, \
                "Geol_Dep_Count" : Geol_Sum, "cumu_dep_cnt": cumu_dep_cnt,"No Dep Cnt" : Geol_NoDep, "Total Area": tot_pxls, \
                "Total Deposits": dep1s, "Tot No Dep Cnt": dep0s, "wpls": wpls, "s_wpls": s_wpls, \
                "wmns": wmns, "s_wmns": s_wmns, "cntrst": cntrst, "s_cntrst": s_cntrst, "stud_cntrst": stud_cntrst, "Rcls": Rcls_v})
                '''
                
                wgts_tab=self.dlg.le_save_wgts_tbl.text()
                wgts_tab_tp = scratch_dir + '/' + 'wgts_tbl_temp.csv'
                df_round.to_csv(wgts_tab_tp, sep='\t')
                
                
                #Step xxx: Creating 'Generalized weights' raster
                
                mapping_wgts = {}
                mapping_wgts = pd.Series(df_round.W.values,index=df_round.Class).to_dict() # create the output image
                driver = dim.GetDriver()
                wgts_rst_wh = scratch_dir + '/' + 'wgts_rst_whole.tif'
                outRst = driver.Create(wgts_rst_wh, cols, rows, 1, gdal.GDT_Float64)
                outBand = outRst.GetRasterBand(1)
                outData = np.zeros((rows,cols), np.float_)
                
                #Code repetition
                #Getting the shape of the raster array
                rstr_arry = band1.ReadAsArray(0,0,cols,rows)          
                # Save the shape of the raster array
                s = rstr_arry.shape
                # Flatten the raster array
                rstr_arry = rstr_arry.reshape(-1)
                # Create 2D replacement matrix:
                replace_wgts = np.array([list(mapping_wgts.keys()), list(mapping_wgts.values())]) #(for the reclassification replacement)
                # Find elements that need replacement:
                mask_wgts = np.in1d(rstr_arry, replace_wgts[0, :])
                ss = np.searchsorted(replace_wgts[0, :], rstr_arry[mask_wgts])
                # Replace them:
                rstr_arry = replace_wgts[1,ss] 
                # Restore the shape of the raster array
                rstr_arry = rstr_arry.reshape(s)        

                outBand.WriteArray(rstr_arry, 0, 0)
                           
                outRst.SetProjection(srs.ExportToWkt())
                outBand.SetNoDataValue(-99)
                outRst.SetGeoTransform(dim.GetGeoTransform())
                outRst.FlushCache()
                #qgis.utils.iface.addRasterLayer(wgts_rst_wh)
                
                ## CLIPPING the Generalized weights raster to shape
                
                wgts_rst_clip = self.dlg.le_save_wgts_rstr.text()
                
                processing.run('gdal:cliprasterbymasklayer',
                   {'ALPHA_BAND' : False, 
                   'CROP_TO_CUTLINE' : True, 
                   'DATA_TYPE' : 0, 
                   'INPUT' : wgts_rst_wh, 
                   'KEEP_RESOLUTION' : False, 
                   'MASK' : msk_layer, 
                   'MULTITHREADING' : False, 
                   'NODATA' :  None, 
                   'OPTIONS' : '', 
                   'OUTPUT' : wgts_rst_clip, 
                   'SET_RESOLUTION' : False, 
                   'SOURCE_CRS' : None, 
                   'TARGET_CRS' : None, 
                   'X_RESOLUTION' : None, 
                   'Y_RESOLUTION' : None} )
                
                
                qgis.utils.iface.addRasterLayer(wgts_rst_clip)
                
                
                #Step xxx: Creating Generalized weights' variance and standard deviation rasters
                
                # Variance Raster of Generalized weights
                mapping_v = {}
                mapping_v = pd.Series(df_round.var_wpls_gen.values,index=df_round.Class).to_dict()
             
                str_wgts_rst = QgsRasterLayer(str(wgts_rst_clip)) 
                
                inp_w = str_wgts_rst
                path_w = inp_w.source()
                rstr_baseName_w = str.split(os.path.basename(path_w), ".")
                var_rst = scratch_dir + '/' + rstr_baseName_w[0] +'_var_temp' + '.tif'
                std_rsttt = working_dir + '/' + rstr_baseName_w[0] +'_w_std' + '.tif'
               
                varRst = driver.Create(var_rst, cols, rows, 1, gdal.GDT_Float64)
                varBand = varRst.GetRasterBand(1)
                varData = np.zeros((rows,cols), np.float_)
                
                #Getting the shape of the raster array
                rstr_arry_var = band1.ReadAsArray(0,0,cols,rows)
                # Save the shape of the raster array
                s_var = rstr_arry_var.shape
                # Flatten the raster array
                rstr_arry_var = rstr_arry_var.reshape(-1)
                replace_var = np.array([list(mapping_v.keys()), list(mapping_v.values())])
                # Find elements that need replacement:
                mask_var = np.in1d(rstr_arry_var, replace[0, :])
                ss_var = np.searchsorted(replace_var[0, :], rstr_arry_var[mask_var])
                # Replace them:
                #rstr_arry[mask] = replace[1, numpy.searchsorted(replace[0, :], rstr_arry[mask])] #original code
                rstr_arry_var = replace_var[1,ss_var] #stored the searchsorted part in variable ss; and removed [mask] from the LHS
                # Restore the shape of the raster array
                rstr_arry_var = rstr_arry_var.reshape(s_var)        
                varBand.WriteArray(rstr_arry_var, 0, 0)
                
                varRst.SetProjection(srs.ExportToWkt())
                varBand.SetNoDataValue(-99)
                varRst.SetGeoTransform(dim.GetGeoTransform())
                varRst.FlushCache()
                #qgis.utils.iface.addRasterLayer(var_rst)
                
                # Clipping the variance raster
                var_rst_clp = working_dir + '/' + rstr_baseName_w[0] +'_var' + '.tif'
                
                processing.run('gdal:cliprasterbymasklayer', {'ALPHA_BAND' : False, 'CROP_TO_CUTLINE' : True,
                   'DATA_TYPE' : 0, 'INPUT' : var_rst, 'KEEP_RESOLUTION' : False, 'MASK' : msk_layer, 'MULTITHREADING' : False, 
                   'NODATA' :  -999999999, 'OPTIONS' : '', 'OUTPUT' : var_rst_clp, 'SET_RESOLUTION' : False, 
                   'SOURCE_CRS' : None, 'TARGET_CRS' : None,'X_RESOLUTION' : None, 'Y_RESOLUTION' : None} )
                
                #qgis.utils.iface.addRasterLayer(var_rst_clp)
 
 
                #Standard deviation raster of generalized weights
                
                mapping_s = {}
                mapping_s = pd.Series(df_round.s_wpls_gen.values,index=df_round.Class).to_dict()
                             
                std_rsttt = scratch_dir + '/' + rstr_baseName_w[0] +'_std_tmp' + '.tif'
                stdRst = driver.Create(std_rsttt, cols, rows, 1, gdal.GDT_Float64)
                stdBand = stdRst.GetRasterBand(1)
                stdData = np.zeros((rows,cols), np.float_)
                
                #Getting the shape of the raster array
                rstr_arry_std = band1.ReadAsArray(0,0,cols,rows)
                # Save the shape of the raster array
                s_std = rstr_arry_std.shape
                # Flatten the raster array
                rstr_arry_std = rstr_arry_std.reshape(-1)
                replace_std = np.array([list(mapping_s.keys()), list(mapping_s.values())])
                # Find elements that need replacement:
                mask_std = np.in1d(rstr_arry_std, replace[0, :])
                ss_std = np.searchsorted(replace_std[0, :], rstr_arry_std[mask_std])
                # Replace them:
                #rstr_arry[mask] = replace[1, numpy.searchsorted(replace[0, :], rstr_arry[mask])] #original code
                rstr_arry_std = replace_std[1,ss_std] #stored the searchsorted part in variable ss; and removed [mask] from the LHS
                # Restore the shape of the raster array
                rstr_arry_std = rstr_arry_std.reshape(s_std)        
                stdBand.WriteArray(rstr_arry_std, 0, 0)
                
                stdRst.SetProjection(srs.ExportToWkt())
                stdBand.SetNoDataValue(-99)
                stdRst.SetGeoTransform(dim.GetGeoTransform())
                stdRst.FlushCache()
                #qgis.utils.iface.addRasterLayer(std_rsttt)
                
                #Clipping the standard deviation raster
                std_rst_clp = working_dir + '/' + rstr_baseName_w[0] +'_std' + '.tif'
                                
                processing.run('gdal:cliprasterbymasklayer', {'ALPHA_BAND' : False, 'CROP_TO_CUTLINE' : True,
                               'DATA_TYPE' : 0, 'INPUT' : std_rsttt, 'KEEP_RESOLUTION' : False, 'MASK' : msk_layer, 'MULTITHREADING' : False, 
                               'NODATA' :  -999999999, 'OPTIONS' : '', 'OUTPUT' : std_rst_clp, 'SET_RESOLUTION' : False, 
                               'SOURCE_CRS' : None, 'TARGET_CRS' : None,'X_RESOLUTION' : None, 'Y_RESOLUTION' : None} )
                            
                qgis.utils.iface.addRasterLayer(std_rst_clp)

                # Redefining the weights dataframe and saving it as the weight tabel csv file 
                
                # Removing 'no data' values from weights table
                df_round=df_round.set_index("Class")
                df_round = df_round.drop(-1000000000.0, axis = 0)
                
                # Removing unecessary columns
                df_round = df_round.drop(['Cumu_Dep_outsidefeat', 'Cumu_Dep_outsidefeat', 'Cumu_Non_Feat_Non_Dep', 
                'Cumu_Non_feat_Pxls', 'Deno_wmns', 'Deno_wpls', 'Dep_outsidefeat',
                'N_cls', 'Non_Feat_Non_Dep', 'Num_wmns', 'Num_wpls' ,'Tot No Dep Cnt', 
                'cumu_no_dep_cnt',  'var_wmns', 'var_wpls'], axis = 1)                 
                
                # Rearrange columns; the column 'Class' is default column and hence not added here in the list below
                #df_round = df_round[['Count', 'cumu_cnt', 'Geol_Dep_Count', 'cumu_dep_cnt', 'No Dep Cnt',
                #'Total Area', 'Total Deposits', 'wpls', 's_wpls', 'wmns', 's_wmns',
                #'cntrst', 's_cntrst',  'stud_cntrst',  'Rcls', 'W', 's_wpls_gen']]
                
                #Rearrange columns, code same as above but removed the 'Total Area' and 'Total Deposits' columns
                df_round = df_round[['Count', 'cumu_cnt', 'Geol_Dep_Count', 'cumu_dep_cnt', 
                'No Dep Cnt', 'wpls', 's_wpls', 'wmns', 's_wmns','cntrst', 
                's_cntrst',  'stud_cntrst',  'Rcls', 'W', 's_wpls_gen']]
                
                #Final renaming of the weights table columns
                df_round = df_round.rename(columns={'Count': 'Count', 'cumu_cnt' : 'Cmltv. Count', 
                'Geol_Dep_Count' : 'Point Count', 'cumu_dep_cnt': 'Cmltv. Point Count', 
                'wpls' : 'WPlus', 's_wpls' : 'S_WPlus', 'wmns': 'WMinus', 's_wmns' : 'S_WMinus',
                'cntrst': 'Contrast', 's_cntrst': 'S_Contrast',  'stud_cntrst' : 'Stud Contrast',
                'Rcls': 'Gen. Classs', 'W': 'Weights', 's_wpls_gen': 'S_Weights'})

                wgts_tab=self.dlg.le_save_wgts_tbl.text()
                df_round.to_csv(wgts_tab, sep='\t')
                self.iface.addVectorLayer(wgts_tab, '', 'ogr')
                
                
                # Creating the multiband raster
                '''
                raster_name= self.dlg.cb_raster.currentText()
                raster_layer = QgsProject().instance().mapLayersByName(raster_name)[0]
                path = raster_layer.source()
                '''
                
                lst_mltb = [bn_rst_clip, wgts_rst_clip, var_rst_clp]
                paths = lst_mltb
                print(lst_mltb)

                lst_mltb1 =  [QgsRasterLayer(str(path)) for path in paths]
        
                mltb_ot=self.dlg.le_save_mltb_rstr.text()          
                mltb = scratch_dir + '/' + rstr_baseName_w[0] +'mltb' + '.tif'
               
                processing.run('gdal:merge',
                                {'DATA_TYPE' : 6, 
                                'INPUT' : lst_mltb1, 
                                'NODATA_INPUT' : None, 
                                'NODATA_OUTPUT' : None, 
                                'OPTIONS' : '', 
                                'OUTPUT' : mltb, 
                                'PCT' : False, 
                                'SEPARATE' : True })

                
                ## CLIPPING the Multiband raster to shape
                
                msk_name= self.dlg.cb_msk_wgt.currentText()
                msk_layer = QgsProject().instance().mapLayersByName(msk_name)[0]
                
                processing.run('gdal:cliprasterbymasklayer',
                   {'ALPHA_BAND' : False, 
                   'CROP_TO_CUTLINE' : True, 
                   'DATA_TYPE' : 0, 
                   'INPUT' : mltb, 
                   'KEEP_RESOLUTION' : False, 
                   'MASK' : msk_layer, 
                   'MULTITHREADING' : False, 
                   'NODATA' :  -999999999, 
                   'OPTIONS' : '', 
                   'OUTPUT' : mltb_ot, 
                   'SET_RESOLUTION' : False, 
                   'SOURCE_CRS' : None, 
                   'TARGET_CRS' : None, 
                   'X_RESOLUTION' : None, 
                   'Y_RESOLUTION' : None} )
                
                qgis.utils.iface.addRasterLayer(mltb_ot)
 
            self.wgtsCalcCmpltMsg()
        #self.tab_close()
    
    #Calculation of posterior probability   
    
    def inp_wgts_rst(self):
        #names, _ =  QFileDialog.getOpenFileNames(self, 'Select Rasters', '','*.tif')
        global names_resp
        names_resp =(QFileDialog.getOpenFileNames(caption="Add the 'multiban Weights Rasters' to map project", filter="Multiband Rasters (*.tif)")[0])
        for name in names_resp:
            self.dlg.lw_wgts_rst.addItem(name)
        inFile =str(names_resp)  
        print(names_resp)
    

    def removeSelected(self):
       for item in self.dlg.lw_wgts_rst.selectedItems():
            self.dlg.lw_wgts_rst.takeItem(self.dlg.lw_wgts_rst.row(item))

            
    def save_ppb(self):
        """Get the save file name for the inverted raster from a file dialog"""
        outFile=str(QFileDialog.getSaveFileName(caption="Save raster as", filter="Raster (*.tif)")[0])
        self.setppbLine(outFile)
    
    def setppbLine(self, text):
        """Set the GUI text for the inverted raster filename"""
        self.dlg.le_ppb.setText(text)
        
    def save_ppb_std(self):
        """Get the save file name for the inverted raster from a file dialog"""
        outFile=str(QFileDialog.getSaveFileName(caption="Save raster as", filter="Raster (*.tif)")[0])
        self.setppbStdLine(outFile)
    
    def setppbStdLine(self, text):
        """Set the GUI text for the inverted raster filename"""
        self.dlg.le_sv_ppb_std.setText(text)    
          

    def save_ppb_conf(self):
        """Get the save file name for the inverted raster from a file dialog"""
        outFile=str(QFileDialog.getSaveFileName(caption="Save raster as", filter="Raster (*.tif)")[0])
        self.setppbConfLine(outFile)
    
    def setppbConfLine(self, text):
        """Set the GUI text for the inverted raster filename"""
        self.dlg.le_sv_conf.setText(text)   
              
   
    def ppb_calc(self):

        # Calculating prior odds
        
        ot_dep_rsmpl = working_dir + '/' + 'Training_sites' + '.tif'
        dep_open = gdal.Open(ot_dep_rsmpl)
        
        #Creating a numpy array from the deposit raster file
        dep = np.array(dep_open.GetRasterBand(1).ReadAsArray())
        #Getting the number of pixels in the deposit raster 
        dep_size = np.size(dep)
        
        #Count of deposit-pixels and no-deposit-pixels; assuming the size of each deposit is equal to unit cell size of the input predictor map

        dep1s = np.count_nonzero(dep == 1)
        dep0s = np.count_nonzero(dep == 0)
        
        inv_dep1s = 1/dep1s
        
        print('deposits pixels are ' + str(dep1s))
        print('no deposits pixels are ' + str(dep0s))
        
        pr_pb = dep1s/(dep1s+dep0s)
        pr_od = math.log((pr_pb)/(1-pr_pb))
        
        print('pr_pb is ' + str(pr_pb) + ' and pr_od is ' + str(pr_od))
        
                
        # Compute entries from filenames
        paths_resp = names_resp
        #outputname = r'C:/QGIS_Trials/5dec5.tif'
        
        ppb_rst=self.dlg.le_ppb.text()
        
        wgts_sum = scratch_dir + '/wgts_sum.tif'
        
        layers =  [QgsRasterLayer(str(path)) for path in paths_resp]
        entries = []
        for i, layer in enumerate(layers, 1):
            entry = QgsRasterCalculatorEntry()
            entry.ref = f"layer_{i}@1"
            entry.raster = layer
            entry.bandNumber = 2
            entries.append(entry)


        # Create operation string
        operation = "+".join(entry.ref for entry in entries)

        # Actual computation
        calc = QgsRasterCalculator(
            operation,
            wgts_sum,
            "GTiff",
            layers[0].extent(),  # Use first layer as ref for extent & size
            layers[0].width(),
            layers[0].height(),
            entries,
        )
        calc.processCalculation()
        #return calc.processCalculation() #commented this because the other codes were not working with this
 
        ## Sum of variance rasters
        
        var_sum = scratch_dir + '/var_sum.tif'
        
        for i, layer in enumerate(layers, 1):
            entry = QgsRasterCalculatorEntry()
            entry.ref = f"layer_{i}@1"
            entry.raster = layer
            entry.bandNumber = 3
            entries.append(entry)


        ##### Create operation string
        operation = "+".join(entry.ref for entry in entries)

        # Actual computation
        calc = QgsRasterCalculator(
            operation,
            var_sum,
            "GTiff",
            layers[0].extent(),  # Use first layer as ref for extent & size
            layers[0].width(),
            layers[0].height(),
            entries,
        )
        calc.processCalculation()
        #return calc.processCalculation() #commented this because the other codes were not working with this
        
        #ppb_rst_whole = r'C:/QGIS_Trials/Temp3/ppb_rst_whole.tif'
        
        ppb_rst_whole = scratch_dir + '/ppb_rst_whole.tif'
        ds_template0=gdal.Open(wgts_sum)
        driver_tiff= gdal.GetDriverByName('GTiff')
        #ppb_rst_ds = driver_tiff.CreateCopy(ppb_rst, ds_template0,strict=0)
        ppb_rst_ds = driver_tiff.CreateCopy(ppb_rst_whole, ds_template0,strict=0)
        band_base0= ds_template0.GetRasterBand(1).ReadAsArray()

        #band_base_add = band_base0 + pr_od
        
        e = 2.718281828
        band_base_add =(e**(band_base0 + pr_od))/(1+(e**(band_base0 + pr_od)))
        
        ppb_rst_ds.GetRasterBand(1).WriteArray(band_base_add)

        ds_template0=None
        ppb_rst_ds=None
        
        msk_name= self.dlg.cb_msk_resp.currentText()
        msk_layer = QgsProject().instance().mapLayersByName(msk_name)[0]
        
        processing.run('gdal:cliprasterbymasklayer',
           {'ALPHA_BAND' : False, 
           'CROP_TO_CUTLINE' : True, 
           'DATA_TYPE' : 0, 
           'INPUT' : ppb_rst_whole, 
           'KEEP_RESOLUTION' : False, 
           'MASK' : msk_layer, 
           'MULTITHREADING' : False, 
           'NODATA' :  None, 
           'OPTIONS' : '', 
           'OUTPUT' : ppb_rst, 
           'SET_RESOLUTION' : False, 
           'SOURCE_CRS' : None, 
           'TARGET_CRS' : None, 
           'X_RESOLUTION' : None, 
           'Y_RESOLUTION' : None} )
        
        
        qgis.utils.iface.addRasterLayer(ppb_rst)
                
        
        #Pprb square raster
                
        ppb_rst_sqr = scratch_dir + '/ppb_rst_sqr.tif'

        ppb_sqr_template=gdal.Open(ppb_rst)
        base_ppb_sqr= ppb_sqr_template.GetRasterBand(1).ReadAsArray()

        driver_tiff= gdal.GetDriverByName('GTiff')
        ppb_rst_sqr_ds = driver_tiff.CreateCopy(ppb_rst_sqr, ppb_sqr_template,strict=0)

        band_base_sqr =(base_ppb_sqr**2)

        ppb_rst_sqr_ds.GetRasterBand(1).WriteArray(band_base_sqr)

        ppb_sqr_template=None
        ppb_rst_sqr_ds=None
        
        
        
        ## Calculating posterior probability variance 
        #due to variances of weights of evidence 
        
        #ppb_var_sqrt = scratch_dir + '/ppb_std_wgts.tif'
        ppb_var_sqrt=self.dlg.le_sv_ppb_std.text()

        ppb_var_template=gdal.Open(ppb_rst_sqr)
        base_ppb_var= ppb_var_template.GetRasterBand(1).ReadAsArray()

        ppb_var_template1=gdal.Open(var_sum)
        base_ppb_var_sum= ppb_var_template1.GetRasterBand(1).ReadAsArray()

        
        driver_tiff= gdal.GetDriverByName('GTiff')
        #ppb_var_ds is replaced by ppb_var_sqrt_ds to get the std raster directly
        #ppb_var_ds = driver_tiff.CreateCopy(ppb_var, ppb_var_template,strict=0)

        band_base_ppb_var =(inv_dep1s + base_ppb_var_sum) * base_ppb_var
        #ppb_var_ds.GetRasterBand(1).WriteArray(band_base_ppb_var)
        
        #The folowing three lines calculate the std deviation raster
        #from the variance raster. The output is supposed to be the 
        #Std deviation raster
        ppb_var_sqrt_ds = driver_tiff.CreateCopy(ppb_var_sqrt, ppb_var_template,strict=0)
        band_base_ppb_var_sqrt = (band_base_ppb_var)**(1/2)
        ppb_var_sqrt_ds.GetRasterBand(1).WriteArray(band_base_ppb_var_sqrt)
        
        ppb_var_template=None
        #ppb_var_ds=None
        ppb_var_sqrt_ds=None
        
        qgis.utils.iface.addRasterLayer(ppb_var_sqrt)
        
       ## Confidence raster calculations
        
        #W_conf_rst = working_dir + '/W_conf_rst.tif'
        W_conf_rst=self.dlg.le_sv_conf.text()
        
        ppb_rst_template=gdal.Open(ppb_rst)
        base_ppb_rst= ppb_rst_template.GetRasterBand(1).ReadAsArray()

        ppb_var_sqrt_template1=gdal.Open(ppb_var_sqrt)
        base_ppb_var_sqrt= ppb_var_sqrt_template1.GetRasterBand(1).ReadAsArray()

        
        driver_tiff= gdal.GetDriverByName('GTiff')
        w_conf_rst_ds = driver_tiff.CreateCopy(W_conf_rst, ppb_rst_template,strict=0)
        band_base_w_conf_rst = base_ppb_rst/base_ppb_var_sqrt
        w_conf_rst_ds.GetRasterBand(1).WriteArray(band_base_w_conf_rst)
        
        ppb_rst_template=None
        ppb_var_sqrt_template1=None
        #ppb_var_ds=None
        w_conf_rst_ds=None
        
        qgis.utils.iface.addRasterLayer(W_conf_rst)
        
        self.respCmpltMsg()
        self.tab_close()
 
        
    def tab_close(self):
        #This fucntion closes the plugin;
        self.dlg.close()
 
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginRasterMenu(
                self.tr(u'&Weights of Evidence (WofE) Model'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = WofEClassDialog()
            
            # For 'Pre-process' Tab
            self.dlg.pb_scrt.clicked.connect(self.select_scratch_folder)
            self.dlg.pb_wrk.clicked.connect(self.select_working_folder)
            self.dlg.pb_ld_msk.clicked.connect(self.openMask)
            self.dlg.le_unt_area.setText('1')
            self.dlg.pb_ld_shp.clicked.connect(self.openVector)
            self.dlg.pb_dep_note.clicked.connect(self.depNote)
            self.dlg.lw_evdnc_rsts.setSelectionMode(QAbstractItemView.MultiSelection) 
            self.dlg.pb_add_evdnc_rsts.clicked.connect(self.inp_evdnc_rst)
            self.dlg.pb_rmv_evdnc_rsts.clicked.connect(self.removeSelectedEvR)
            self.dlg.pb_pre_proc.clicked.connect(self.prepro)
            self.dlg.pb_pre_proc_cancel.clicked.connect(self.tab_close)
            
            # Calculate Weights Tab actions
            self .dlg.pb_scrt_wgt.clicked.connect(self.select_scratch_folder)
            self .dlg.pb_wrk_wgt.clicked.connect(self.select_working_folder)
            self.dlg.pb_ld_msk_wgt.clicked.connect(self.openMask)
            self.dlg.pb_ld_rstr.clicked.connect(self.openRaster)
            self.dlg.le_stud_cnt.setText('2')
            self.dlg.pb_save_bn_rstr.clicked.connect(self.saveBnRaster) 
            self.dlg.pb_save_wgts_rstr.clicked.connect(self.saveWgtRaster)
            self.dlg.pb_save_mltb_rstr.clicked.connect(self.saveMltbRaster)
            self.dlg.pb_save_wgts_tbl.clicked.connect(self.saveTable) 
            self.dlg.pb_clc_wgt.clicked.connect(self.wgtsCalc)
            self.dlg.pb_cancel_wgt.clicked.connect(self.tab_close)
            
           # Calculate Responses Tab actions
            
            self .dlg.pb_scrt_resp.clicked.connect(self.select_scratch_folder)
            self .dlg.pb_wrk_resp.clicked.connect(self.select_working_folder)
            self.dlg.pb_ld_msk_resp.clicked.connect(self.openMask)
            self.dlg.lw_wgts_rst.setSelectionMode(QAbstractItemView.MultiSelection) 
            self.dlg.pb_add_wgts_rst.clicked.connect(self.inp_wgts_rst)
            self.dlg.pb_rmv_wgts_rst.clicked.connect(self.removeSelected)
            self.dlg.pb_calc_resp.clicked.connect(self.ppb_calc)
            self.dlg.pb_sv_ppb.clicked.connect(self.save_ppb)
            self.dlg.pb_sv_std_resp.clicked.connect(self.save_ppb_std)
            self.dlg.pb_sv_conf.clicked.connect(self.save_ppb_conf)
            self.dlg.pb_resp_cancel.clicked.connect(self.tab_close)
            
    
        wgts_type = ['Categorical', 'Ascending', 'Descending']
        self.dlg.cb_wgts_type.clear()
        self.dlg.cb_wgts_type.addItems(wgts_type)
        slctd_wgts_type = self.dlg.cb_wgts_type.currentText()


        #For loading list of raster layers in the combobox 
        layerlist1 = ['<Select the evidence raster>']
        #self.searchLayers = [None, None] # This is same size as layerlist
        layers1 = QgsProject.instance().mapLayers().values()
        for layer in layers1:
            if layer.type() == QgsMapLayer.RasterLayer:
                if layer not in layerlist1:
                    layerlist1.append(layer.name())
        
        #Clear the contents of the comboBox from previous runs
        self.dlg.cb_raster.clear()
        # Populate the comboBox with names of all the loaded layers
        self.dlg.cb_raster.addItems(layerlist1)
         
        # Fetch the currently loaded vector layers
        vect_lyr_list = ['<Select the training sites layer>']
        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer:
                vect_lyr_list.append(layer.name())
                                      
        #Clear the contents of the comboBox from previous runs
        self.dlg.cb_shp.clear() 
        #Populate the comboBox with names of all the loaded vector layers
        self.dlg.cb_shp.addItems(vect_lyr_list)
        
        
        # Fetch the currently loaded vector layers
        msk_lyr_list = ['<Select the mask layer>']  
        layers1 = QgsProject.instance().mapLayers().values()
        for layer in layers1:
            if layer.type() == QgsMapLayer.VectorLayer:
                if layer not in msk_lyr_list:
                    msk_lyr_list.append(layer.name())
        
        #Populate the mask comboBox with names of all the loaded vector layers
        self.dlg.cb_msk.addItems(msk_lyr_list)
        self.dlg.cb_msk_wgt.addItems(msk_lyr_list)
        self.dlg.cb_msk_resp.addItems(msk_lyr_list)
      

        # show the dialog
        self.dlg.show()
        
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
