# -*- coding: utf-8 -*-
"""
/***************************************************************************
 WodyPolskieWMS
                                 A QGIS plugin
 Baza usług WMS publikowanych przez Państwowe Gospodarstwo Wodne Wody Polskie
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-07-23
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Państwowe Gospodarstwo Wodne Wody Polskie - KZGW - Wydział SIGW
        email                : lukasz.scislowski@wody.gov.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from PyQt5.QtCore import (QCoreApplication, QSettings, Qt, QTranslator,
                          QVariant, qVersion)
from PyQt5.QtGui import *
from PyQt5.QtWidgets import QAction, QShortcut
from qgis.core import *
from qgis.gui import QgsMessageBar
from qgis.core import QgsProject
from qgis.core import (QgsCoordinateReferenceSystem, QgsCoordinateTransform,
                       QgsCoordinateTransformContext, QgsMapLayerProxyModel,
                       QgsProject)
import json
import locale
import operator
import os
import sys
import time
from collections import OrderedDict
from urllib.request import urlopen

from PyQt5.QtCore import (QCoreApplication, QSettings, Qt, QTranslator,
                          QVariant, qVersion)
from PyQt5.QtGui import *
from PyQt5.QtWidgets import QAction, QShortcut
from qgis.core import *
from qgis.gui import QgsMessageBar
from qgis.core import QgsLayerTreeGroup

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Wody_Polskie_WMS_dialog import WodyPolskieWMSDialog
import os.path


class WodyPolskieWMS:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        self.project = QgsProject.instance()
        self.wms_mphp_layer = None
        
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'WodyPolskieWMS_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Wody Polskie - Baza WMS')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.project = QgsProject.instance().layerTreeRoot().children()
       
        self.dlg = None
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('WodyPolskieWMS', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Wody_Polskie_WMS/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Wody Polskie - Baza WMS'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Wody Polskie - Baza WMS'),
                action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        # Listy usług z warstwami

        PGWWP = [["0", "PGWWP-Nadzory Wodne", "https://wody.isok.gov.pl/gpservices/KZGW2/REG_ISOK_RZGW/MapServer/WMSServer?"],
        ["1", "PGWWP-Zarządy Zlewni", "https://wody.isok.gov.pl/gpservices/KZGW2/REG_ISOK_RZGW/MapServer/WMSServer?"],
        ["2", "PGWWP-Regionalne Zarządy Gospodarki Wodnej", "https://wody.isok.gov.pl/gpservices/KZGW2/REG_ISOK_RZGW/MapServer/WMSServer?"]]

        aPGW = [["0", "aPGW-Ekoregiony", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["1", "aPGW-Obszary Dorzeczy", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["2", "aPGW-Regiony wodne", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["3", "aPGW-Zlewnie JCWP", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["4", "aPGW-Jednolite Części Wód Podziemnych", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["5", "aPGW-JCWP Jeziornych", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["6", "aPGW-JCWP Przejściowych", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["7", "aPGW-JCWP Przybrzeżnych", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["8", "aPGW-Główne rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["9", "aPGW-Główne jeziora", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"],
        ["10", "aPGW-JCWP Rzecznych", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_PGW/MapServer/WMSServer?"]]

        worp1 = [["1", "WORP-Obszary narażone na niebezpieczeństwo powodzi-od morza", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_ONNP_1/MapServer/WMSServer?"]]

        worp2 = [["1", "WORP-Obszary narażone na niebezpieczeństwo powodzi-rzeczne", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_ONNP_2/MapServer/WMSServer?"]]

        worp3 = [["1", "WORP-Obszary narażone na niebezpieczeństwo powodzi-zniszczenie budowli piętrzących", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_ONNP_3/MapServer/WMSServer?"]]

        worp4 = [["0", "WORP-Powodzie historyczne, powodzie prawdopodobne-Obszary zalewowe-II cykl", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"],
        ["1", "WORP-Powodzie historyczne, powodzie prawdopodobne-Obszary zalewowe-I cykl", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"],
        ["3", "WORP-Powodzie historyczne, powodzie prawdopodobne-Powodzie prawdopodobne II cykl-poligon", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"],
        ["4", "WORP-Powodzie historyczne, powodzie prawdopodobne-Powodzie prawdopodobne II cykl-linia", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"],
        ["5", "WORP-Powodzie historyczne, powodzie prawdopodobne-Powodzie prawdopodobne II cykl-punkt", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"],
        ["6", "WORP-Powodzie historyczne, powodzie prawdopodobne-Powodzie prawdopodobne-I cykl", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"],
        ["8", "WORP-Powodzie historyczne, powodzie prawdopodobne-Powodzie historyczne II cykl-poligon", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"],
        ["9", "WORP-Powodzie historyczne, powodzie prawdopodobne-Powodzie historyczne II cykl-punkt", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"],
        ["11", "WORP-Powodzie historyczne, powodzie prawdopodobne-Powodzie historyczne I cykl-poligon", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"],
        ["12", "WORP-Powodzie historyczne, powodzie prawdopodobne-Powodzie historyczne I cykl-punkt", "https://wody.isok.gov.pl/gpservices/KZGW/ISOK_WORP_v2/MapServer/WMSServer?"]]

        mzp1 = [["1", "MZP-od morza-0,2%(raz na 500 lat)-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MZP-od morza-0,2%(raz na 500 lat)-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MZP-od morza-0,2%(raz na 500 lat)-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MZP-od morza-0,2%(raz na 500 lat)-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MZP-od morza-0,2%(raz na 500 lat)-wał przeciwpowodziowy, przeciwsztormowy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MZP-od morza-0,2%(raz na 500 lat)-miejsca przelania się wód przez wał przeciwpowodziowy, przeciwsztormowy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MZP-od morza-0,2%(raz na 500 lat)-granica portu i przystani morskiej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MZP-od morza-0,2%(raz na 500 lat)-granica pasa technicznego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MZP-od morza-0,2%(raz na 500 lat)-granica pasa ochronnego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MZP-od morza-0,2%(raz na 500 lat)-kilometraż brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["11", "MZP-od morza-0,2%(raz na 500 lat)-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["12", "MZP-od morza-0,2%(raz na 500 lat)-rzędna korony wału przeciwpowodziowego, przeciwsztormowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["13", "MZP-od morza-0,2%(raz na 500 lat)-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["14", "MZP-od morza-0,2%(raz na 500 lat)-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["16", "MZP-0,2%(raz na 500 lat)-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["17", "MZP-0,2%(raz na 500 lat)-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["18", "MZP-0,2%(raz na 500 lat)-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["19", "MZP-0,2%(raz na 500 lat)-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["20", "MZP-0,2%(raz na 500 lat)-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["21", "MZP-0,2%(raz na 500 lat)-miejsca przelania się wód przez wał przeciwpowodziowy lub zaporę boczną", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["22", "MZP-0,2%(raz na 500 lat)-rzędna korony wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["23", "MZP-0,2%(raz na 500 lat)-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["24", "MZP-0,2%(raz na 500 lat)-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["25", "MZP-0,2%(raz na 500 lat)-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"]]

        mzp2 = [["1", "MZP-od morza-1%(raz na 100 lat)-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MZP-od morza-1%(raz na 100 lat)-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MZP-od morza-1%(raz na 100 lat)-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MZP-od morza-1%(raz na 100 lat)-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MZP-od morza-1%(raz na 100 lat)-wał przeciwpowodziowy, przeciwsztormowy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MZP-od morza-1%(raz na 100 lat)-miejsca przelania się wód przez wał przeciwpowodziowy, przeciwsztormowy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MZP-od morza-1%(raz na 100 lat)-granica portu i przystani morskiej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MZP-od morza-1%(raz na 100 lat)-granica pasa technicznego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MZP-od morza-1%(raz na 100 lat)-granica pasa ochronnego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MZP-od morza-1%(raz na 100 lat)-kilometraż brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["11", "MZP-od morza-1%(raz na 100 lat)-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["12", "MZP-od morza-1%(raz na 100 lat)-rzędna korony wału przeciwpowodziowego, przeciwsztormowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["13", "MZP-od morza-1%(raz na 100 lat)-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["14", "MZP-od morza-1%(raz na 100 lat)-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["16", "MZP-1%(raz na 100 lat)-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["17", "MZP-1%(raz na 100 lat)-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["18", "MZP-1%(raz na 100 lat)-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["19", "MZP-1%(raz na 100 lat)-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["20", "MZP-1%(raz na 100 lat)-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["21", "MZP-1%(raz na 100 lat)-miejsca przelania się wód przez wał przeciwpowodziowy lub zaporę boczną", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["22", "MZP-1%(raz na 100 lat)-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["23", "MZP-1%(raz na 100 lat)-rzędna korony wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["24", "MZP-1%(raz na 100 lat)-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["25", "MZP-1%(raz na 100 lat)-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"]]

        mzp3 = [["1", "MZP-10%(raz na 10 lat)-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"],
        ["2", "MZP-10%(raz na 10 lat)-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"],
        ["3", "MZP-10%(raz na 10 lat)-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"],
        ["4", "MZP-10%(raz na 10 lat)-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"],
        ["5", "MZP-10%(raz na 10 lat)-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"],
        ["6", "MZP-10%(raz na 10 lat)-miejsca przelania się wód przez wał przeciwpowodziowy lub zaporę boczną", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"],
        ["7", "MZP-10%(raz na 10 lat)-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"],
        ["8", "MZP-10%(raz na 10 lat)-rzędna korony wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"],
        ["9", "MZP-10%(raz na 10 lat)-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"],
        ["10", "MZP-10%(raz na 10 lat)-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_WysokiePrawdopodPowodzi/MapServer/WMSServer"]]

        mzp4 = [["1", "MZP-0,2%(raz na 500 lat)-prędkość przepływu wody [m/s]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MZP-0,2%(raz na 500 lat)-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MZP-0,2%(raz na 500 lat)-kierunki przepływu wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MZP-0,2%(raz na 500 lat)-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MZP-0,2%(raz na 500 lat)-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MZP-0,2%(raz na 500 lat)-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MZP-0,2%(raz na 500 lat)-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MZP-0,2%(raz na 500 lat)-rzędna korony wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MZP-0,2%(raz na 500 lat)-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MZP-0,2%(raz na 500 lat)-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_NiskiePrawdopodPowodzi/MapServer/WMSServer?"]]

        mzp5 = [["1", "MZP-1%(raz na 100 lat)-prędkość przepływu wody [m/s]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MZP-1%(raz na 100 lat)-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MZP-1%(raz na 100 lat)-kierunki przepływu wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MZP-1%(raz na 100 lat)-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MZP-1%(raz na 100 lat)-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MZP-1%(raz na 100 lat)-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MZP-1%(raz na 100 lat)-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MZP-1%(raz na 100 lat)-rzędna korony wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MZP-1%(raz na 100 lat)-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MZP-1%(raz na 100 lat)-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_SredniePrawdopodPowodzi/MapServer/WMSServer?"]]

        mzp6 = [["1", "MZP-10%(raz na 10 lat)-prędkość przepływu wody [m/s]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MZP-10%(raz na 10 lat)-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MZP-10%(raz na 10 lat)-kierunki przepływu wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MZP-10%(raz na 10 lat)-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MZP-10%(raz na 10 lat)-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MZP-10%(raz na 10 lat)-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MZP-10%(raz na 10 lat)-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MZP-10%(raz na 10 lat)-rzędna korony wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MZP-10%(raz na 10 lat)-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MZP-10%(raz na 10 lat)-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Predkosc_WysokiePrawdopodPowodzi/MapServer/WMSServer?"]]

        mzp7 = [["0", "MZP-zniszczenie wału przeciwpow.-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["1", "MZP-zniszczenie wału przeciwpow.-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["2", "MZP-zniszczenie wału przeciwpow.-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["3", "MZP-zniszczenie wału przeciwpow.-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["4", "MZP-zniszczenie wału przeciwpow.-miejsce zniszczenia wału przeciwpow.", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["5", "MZP-zniszczenie wału przeciwpow.-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["6", "MZP-zniszczenie wału przeciwpow.-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["7", "MZP-zniszczenie wału przeciwpow.-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"]]

        mzp8 = [["1", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-warstwy referencyjne-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["2", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-warstwy referencyjne-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["4", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Świnna Poręba-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["5", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Świnna Poręba-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["6", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Świnna Poręba-miejsce uszkodzenia budowli piętrzącej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["7", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Świnna Poręba-budowle piętrzące", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["8", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Świnna Poręba-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["9", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Świnna Poręba-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["11", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Słup-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["12", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Słup-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["13", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Słup-miejsce uszkodzenia budowli piętrzącej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["14", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Słup-budowle piętrzące", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["15", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Słup-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["16", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Słup-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["18", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Przeczyce-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["19", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Przeczyce-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["20", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Przeczyce-miejsce uszkodzenia budowli piętrzącej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["21", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Przeczyce-budowle piętrzące", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["22", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Przeczyce-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["23", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Przeczyce-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["25", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Mietków-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["26", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Mietków-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["27", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Mietków-miejsce uszkodzenia budowli piętrzącej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["28", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Mietków-budowle piętrzące", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["29", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Mietków-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["30", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Mietków-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["32", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Dobromierz-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["33", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Dobromierz-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["34", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Dobromierz-miejsce uszkodzenia budowli piętrzącej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["35", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Dobromierz-budowle piętrzące", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["36", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Dobromierz-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["37", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Dobromierz-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["39", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Chańcza-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["40", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Chańcza-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["41", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Chańcza-miejsce uszkodzenia budowli piętrzącej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["42", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Chańcza-budowle piętrzące", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["43", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Chańcza-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["44", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Chańcza-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["46", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Besko-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["47", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Besko-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["48", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Besko-miejsce uszkodzenia budowli piętrzącej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["49", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Besko-budowle piętrzące", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["50", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Besko-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["51", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Zbiornik Besko-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["53", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Warstwy wspólne-wały przeciwpowodziowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["54", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Warstwy wspólne-rzędna korony wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"],
        ["55", "MZP-zniszczenie lub uszkodzenie budowli piętrzącej-Warstwy wspólne-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieBudowliPietrzacejj/MapServer/WMSServer?"]]

        mzp9 = [["0", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-głębokość wody w [m]", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["1", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["2", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["3", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["4", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-miejsce zniszczenia wału przeciwpowodziowego, przeciwsztormowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["5", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-granica portu i przystani morskiej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["6", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-granica pasa technicznego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["7", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-granica pasa ochronnego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["8", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-kilometraż brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["9", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["10", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-rzędna korony wału przeciwpowodziowego, przeciwsztormowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["11", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-maksymalna rzędna zwierciadła wody", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["12", "MZP od morza-całkowite zniszczenie wału przeciwsztormowego-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_Glebokosc_ZniszczenieWaluSztormowego/MapServer/WMSServer?"]]

        mzp10 = [["0", "MZP-Obszary szczególnego zagrożenia powodzią-Odcinki rzek, na których obowiązują OSZP ze studiów ochrony przeciwpowodziowej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_ObszarySzczegolnegoZagrozeniaPowodzia/MapServer/WMSServer?"],
        ["1", "MZP-Obszary szczególnego zagrożenia powodzią-OSZP 1% z studiów ochrony przeciwpowodziowej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_ObszarySzczegolnegoZagrozeniaPowodzia/MapServer/WMSServer?"],
        ["2", "MZP-Obszary szczególnego zagrożenia powodzią-OSZP 1% z map zagrożenia powodziowego od rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_ObszarySzczegolnegoZagrozeniaPowodzia/MapServer/WMSServer?"],
        ["3", "MZP-Obszary szczególnego zagrożenia powodzią-OSZP 1% z map zagrożenia powodziowego od morza", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20_ObszarySzczegolnegoZagrozeniaPowodzia/MapServer/WMSServer?"]]
        
        mzp11 = [["0", "MZP-Mapa orientacyjna-Zasięg MZP-zniszczenie lub uszkodzenie budowli pietrzącej", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20__MapaOrientacyjna/MapServer/WMSServer?"],
        ["1", "MZP-Mapa orientacyjna-Zasięg MZP od rzek-całkowite zniszczenie wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20__MapaOrientacyjna/MapServer/WMSServer?"],
        ["2", "MZP-Mapa orientacyjna-Zasięg MZP od rzek-0,2%(raz na 500 lat)", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20__MapaOrientacyjna/MapServer/WMSServer?"],
        ["3", "MZP-Mapa orientacyjna-Zasięg MZP od rzek-1%(raz na 100 lat)", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20__MapaOrientacyjna/MapServer/WMSServer?"],
        ["4", "MZP-Mapa orientacyjna-Zasięg MZP od rzek-10%(raz na 10 lat)", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20__MapaOrientacyjna/MapServer/WMSServer?"],
        ["5", "MZP-Mapa orientacyjna-Zasięg MZP od morza-całkowite zniszczenie wału przeciwsztormowego", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20__MapaOrientacyjna/MapServer/WMSServer?"],
        ["6", "MZP-Mapa orientacyjna-Zasięg MZP od morza-0,2%(raz na 500 lat)", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20__MapaOrientacyjna/MapServer/WMSServer?"],
        ["7", "MZP-Mapa orientacyjna-Zasięg MZP od morza-1%(raz na 100 lat)", "https://wody.isok.gov.pl/gpservices/KZGW/MZP20__MapaOrientacyjna/MapServer/WMSServer?"]]
        
        mrp1 = [["1", "MRP 10% (raz na 10lat) negatywne konsekwencje dla życia i zdrowia ludzi-wartości potencjalnych strat powodziowych", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MRP 10%(raz na 10lat) negatywne konsekwencje dla życia i zdrowia ludzi-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MRP 10%(raz na 10lat) negatywne konsekwencje dla życia i zdrowia ludzi-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MRP 10%(raz na 10lat) negatywne konsekwencje dla życia i zdrowia ludzi-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MRP 10%(raz na 10lat) negatywne konsekwencje dla życia i zdrowia ludzi-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MRP 10%(raz na 10lat) negatywne konsekwencje dla życia i zdrowia ludzi-miejscowości zagrożone powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MRP 10%(raz na 10lat) negatywne konsekwencje dla życia i zdrowia ludzi-budynki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MRP 10%(raz na 10lat) negatywne konsekwencje dla życia i zdrowia ludzi-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MRP 10%(raz na 10lat) negatywne konsekwencje dla życia i zdrowia ludzi-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_WysokiePrawdopodPowodzi/MapServer/WMSServer?"]]
        
        mrp2 = [["1", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-wartości potencjalnych strat powodziowych", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-wał przeciwpowodziowy, przeciwsztormowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-miejscowości zagrożone powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-budynki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-granica portu i przystani morskiej", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-granica pasa technicznego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-granica pasa ochronnego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["11", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-kilometraż brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["12", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["13", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["15", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-wartości potencjalnych strat powodziowych", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["16", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["17", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["18", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["19", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["20", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-miejscowości zagrożone powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["21", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-budynki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["22", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["23", "MRP 1%(raz na 100lat) negatywne konsekwencje dla życia i zdrowia ludzi-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_SredniePrawdopodPowodzi/MapServer/WMSServer?"]]
        
        mrp3 = [["1", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-wartości potencjalnych strat powodziowych", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-wał przeciwpowodziowy, przeciwsztormowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-miejscowości zagrożone powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-budynki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-granica portu i przystani morskiej", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-granica pasa technicznego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-granica pasa ochronnego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["11", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-kilometraż brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["12", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["13", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["15", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-wartości potencjalnych strat powodziowych", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["16", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["17", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["18", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["19", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["20", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-miejscowości zagrożone powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["21", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-budynki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["22", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["23", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla życia i zdrowia ludzi-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_NiskiePrawdopodPowodzi/MapServer/WMSServer?"]]
        
        mrp4 = [["0", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla życia i zdrowia ludzi-wartości potencjalnych strat powodziowych", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["1", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla życia i zdrowia ludzi-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["2", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla życia i zdrowia ludzi-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["3", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla życia i zdrowia ludzi-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["4", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla życia i zdrowia ludzi-miejsce zniszczenia wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["5", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla życia i zdrowia ludzi-miejscowości zagrożone powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["6", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla życia i zdrowia ludzi-budynki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["7", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla życia i zdrowia ludzi-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["8", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla życia i zdrowia ludzi-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"]]
        
        mrp5 = [["0", "MRP-zniszczenie wału przeciwsztormowego-potencjalne negatywne skutki dla życia i zdrowia ludzi-wartości potencjalnych strat powodziowych", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["1", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["2", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["3", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["4", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-wał przeciwpowodziowy, przeciwsztormowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["5", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-miejscowości zagrożone powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["6", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-budynki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["7", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-granica portu i przystani morskiej", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["8", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-granica pasa technicznego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["9", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-granica pasa ochronnego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["10", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-kilometraż brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["11", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["12", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla życia i zdrowia ludzi-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiZycieZdrowiePotencjalneStraty_ZniszczenieWaluSztormowego/MapServer/WMSServer?"]]
        
        mrp6 = [["1", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kulturowego i działalności gosp.-klasy użytkowania terenu", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ogród zoologiczny", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-składowisko odpadów", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cmentarz", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-strefa ochronna ujęcia wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-formy ochrony przyrody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["11", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["12", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-oczyszczalnia, przepompownia", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["13", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-zakład przemysłowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["14", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obiekt cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["15", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kąpielisko", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["16", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ujęcie wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["17", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["18", "MRP 10%(raz na 10lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_WysokiePrawdopodPowodzi/MapServer/WMSServer?"]]
        
        mrp7 = [["1", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-klasy użytkowania terenu", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ogród zoologiczny", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-składowisko odpadow", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cmentarz", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-strefa ochronna ujęcia wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-formy ochrony przyrody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["11", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wał przeciwpowodziowy, przeciwsztormowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["12", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-granica portu i przystani morskiej", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["13", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-granica pasa technicznego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["14", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-granica pasa ochronnego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["15", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-oczyszczalnia, przepompownia", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["16", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-zakład przemysłowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["17", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obiekt cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["18", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kąpielisko", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["19", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ujęcie wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["20", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["21", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["22", "MRP od morza 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["24", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-klasy użytkowania terenu", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["25", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["26", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["27", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar szczególnego zagrożenia powodzią", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["28", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ogród zoologiczny", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["29", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["30", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-składowisko odpadów", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["31", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cmentarz", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["32", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-strefa ochronna ujęcia wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["33", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-formy ochrony przyrody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["34", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["35", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-oczyszczalnia, przepompownia", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["36", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-zakład przemysłowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["37", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obiekt cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["38", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kąpielisko", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["39", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ujęcie wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["40", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"],
        ["41", "MRP 1%(raz na 100lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_SredniePrawdopodPowodzi/MapServer/WMSServer?"]]
        
        mrp8 = [["1", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-klasy użytkowania terenu", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["2", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["3", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["4", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["5", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ogród zoologiczny", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["6", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["7", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-składowisko odpadow", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["8", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cmentarz", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["9", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-strefa ochronna ujęcia wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["10", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-formy ochrony przyrody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["11", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wał przeciwpowodziowy, przeciwsztormowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["12", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-granica portu i przystani morskiej", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["13", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-granica pasa technicznego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["14", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-granica pasa ochronnego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["15", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-oczyszczalnia, przepompownia", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["16", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-zakład przemysłowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["17", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obiekt cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["18", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kąpielisko", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["19", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ujęcie wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["20", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["21", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["22", "MRP od morza 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["24", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-klasy użytkowania terenu", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["25", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["26", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["27", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["28", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ogród zoologiczny", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["29", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obszar cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["30", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-składowisko odpadów", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["31", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-cmentarz", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["32", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-strefa ochronna ujęcia wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["33", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-formy ochrony przyrody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["34", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-wał przeciwpowodziowy, zapora boczna", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["35", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-oczyszczalnia, przepompownia", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["36", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-zakład przemysłowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["37", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-obiekt cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["38", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kąpielisko", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["39", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-ujęcie wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["40", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"],
        ["41", "MRP 0,2%(raz na 500lat) negatywne konsekwencje dla środowiska, dziedzictwa kult. i działalności gosp.-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_NiskiePrawdopodPowodzi/MapServer/WMSServer?"]]
        
        mrp9 = [["0", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-klasy użytkowania terenu", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["1", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["2", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["3", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["4", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-ogród zoologiczny", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["5", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-obszar cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["6", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-składowisko odpadow", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["7", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-cmentarz", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["8", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-strefa ochronna ujęcia wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["9", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-formy ochrony przyrody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["10", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-miejsce zniszczenia wału przeciwpowodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["11", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-oczyszczalnia, przepompownia", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["12", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-zakład przemysłowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["13", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-obiekt cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["14", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-kąpielisko", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["15", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-ujęcie wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["16", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"],
        ["17", "MRP-zniszczenie wału przeciwpow.-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluPowodziowego/MapServer/WMSServer?"]]
        
        mrp10 = [["0", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-klasy użytkowania terenu", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["1", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-cieki naturalne i kanały", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["2", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-wody powierzchniowe", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["3", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-obszar zagrożenia powodziowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["4", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-ogród zoologiczny", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["5", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-obszar cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["6", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-składowisko odpadów", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["7", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-cmentarz", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["8", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-strefa ochronna ujęcia wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["9", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-formy ochrony przyrody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["10", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-miejsce zniszczenia wału przeciwpow., przeciwsztormowego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["11", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-granica portu i przystani morskiej", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["12", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-granica pasa technicznego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["13", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-granica pasa ochronnego brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["14", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-oczyszczalnia, przepompownia", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["15", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-zakład przemysłowy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["16", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-obiekt cenny kulturowo", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["17", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-kąpielisko", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["18", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-ujęcie wody", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["19", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż brzegu morskiego", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["20", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-kilometraż rzeki", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"],
        ["21", "MRP-zniszczenie wału przeciwsztormowego-negatywne skutki dla środowiska, dziedzictwa kult. i działalności gosp.-skorowidz arkuszy", "https://wody.isok.gov.pl/gpservices/KZGW/MRP20_SkutkiSrodowiskoKulturaGospodarka_ZniszczenieWaluSztormowego/MapServer/WMSServer?"]]
        
        """Run method that performs all the real work"""
        
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
        
            self.first_start = False
            self.dlg = WodyPolskieWMSDialog()
            #MPHP10k - wywołanie funkcji przycisków
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_dzialy)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie1)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie2)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie3)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie4)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie5)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie6)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie7)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie8)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie9)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie10)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie11)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie12)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie13)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlewnie14)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_zlew_element)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_cieki)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_odcinki_ciek)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_cieki_s)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_jeziora)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_morza)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_wezly_dzial)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_wezly_ciek)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_sekcje)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_nazwy_ciek)
            self.dlg.pbMPHP.clicked.connect(self.add_wms_mphp_nazwy_jezior)
            
            #Granice PGWWP - wywołanie funkcji przycisku
            self.dlg.pbPGWWP.clicked.connect(lambda: self.add_wms(PGWWP))
            #aPGW - wywołanie funkcji przycisków
            self.dlg.pbaPGW.clicked.connect(lambda: self.add_wms(aPGW))
            #WORP1 - od morza - wywołanie funkcji przycisku
            self.dlg.pbWORP1.clicked.connect(lambda: self.add_wms(worp1))
            #WORP2 - rzeczne - wywołanie funkcji przycisków
            self.dlg.pbWORP2.clicked.connect(lambda: self.add_wms(worp2))
            #WORP3 - zniszczenie budowli piętrzących - wywołanie funkcji przycisku
            self.dlg.pbWORP3.clicked.connect(lambda: self.add_wms(worp3))
            #WORP4 - Powodzie historyczne, powodzie prawdopodobne - wywołanie funkcji przycisku
            self.dlg.pbWORP4.clicked.connect(lambda: self.add_wms(worp4))
            #MZP1 - MZP z głębokością wody 0,2%, raz na 500 lat dla powodzi rzecznych oraz od strony morza - wywołanie funkcji przyciskuw 
            self.dlg.pbMZP1.clicked.connect(lambda: self.add_wms(mzp1))
            #MZP2 - MZP z głębokością wody 1%, raz na 100 lat dla powodzi rzecznych oraz od strony morza - wywołanie funkcji przycisków 
            self.dlg.pbMZP2.clicked.connect(lambda: self.add_wms(mzp2))
            #MZP3 - MZP z głębokością wody 10%, raz na 10 lat - wywołanie funkcji przycisków 
            self.dlg.pbMZP3.clicked.connect(lambda: self.add_wms(mzp3))
            #MZP4 - MZP z prędkością przepływu wody 0,2%, raz na 500 lat - wywołanie funkcji przycisków 
            self.dlg.pbMZP4.clicked.connect(lambda: self.add_wms(mzp4))
            #MZP5 - MZP z prędkością przepływu wody 1%, raz na 100 lat - wywołanie funkcji przycisków 
            self.dlg.pbMZP5.clicked.connect(lambda: self.add_wms(mzp5))
            #MZP6 - MZP z prędkością przepływu wody 10%, raz na 10 lat - wywołanie funkcji przycisków 
            self.dlg.pbMZP6.clicked.connect(lambda: self.add_wms(mzp6))
            #MZP7 - MZP - całkowite zniszczenie wału przeciwpowodziowego - wywołanie funkcji przycisków 
            self.dlg.pbMZP7.clicked.connect(lambda: self.add_wms(mzp7))
            #MZP8 - MZP - zniszczenie lub uszkodzenie budowli piętrzącej - wywołanie funkcji przycisków 
            self.dlg.pbMZP8.clicked.connect(lambda: self.add_wms(mzp8))
            #MZP9 - MZP od strony morza - całkowite zniszczenie wału przeciwsztormowego - wywołanie funkcji przycisków 
            self.dlg.pbMZP9.clicked.connect(lambda: self.add_wms(mzp9))
            #MZP10 - MZP - Obszary szczególnego zagrożenia powodzią
            self.dlg.pbMZP10.clicked.connect(lambda: self.add_wms(mzp10))
            #MZP11 - MZP - Mapa orientacyjna
            self.dlg.pbMZP11.clicked.connect(lambda: self.add_wms(mzp11))
            #MRP1 - MRP - MRP 10% potencjalne negatywne konsekwencje dla życia i zdrowia ludzi oraz wartości potencjalnych strat
            self.dlg.pbMRP1.clicked.connect(lambda: self.add_wms(mrp1))
            #MRP2 - MRP - MRP 1% potencjalne negatywne konsekwencje dla życia i zdrowia ludzi oraz wartości potencjalnych strat
            self.dlg.pbMRP2.clicked.connect(lambda: self.add_wms(mrp2))
            #MRP3 - MRP - MRP 0,2% potencjalne negatywne konsekwencje dla życia i zdrowia ludzi oraz wartości potencjalnych strat
            self.dlg.pbMRP3.clicked.connect(lambda: self.add_wms(mrp3))
            #MRP4 - MRP - całkowite zniszczenie wału przeciwpowodziowego - potencjalne negatywne skutki dla życia i zdrowia ludzi oraz wartości potencjalnych strat powodziowych
            self.dlg.pbMRP4.clicked.connect(lambda: self.add_wms(mrp4))
            #MRP5 - MRP - całkowite zniszczenie wału przeciwsztormowego - potencjalne negatywne skutki dla życia i zdrowia ludzi oraz wartości potencjalnych strat powodziowych
            self.dlg.pbMRP5.clicked.connect(lambda: self.add_wms(mrp5))
            #MRP6 - MRP 10% negatywne konsekwencje dla środowiska, dziedzictwa kulturowego i działalności gospodarczej
            self.dlg.pbMRP6.clicked.connect(lambda: self.add_wms(mrp6))
            #MRP7 - MRP 1% negatywne konsekwencje dla środowiska, dziedzictwa kulturowego i działalności gospodarczej
            self.dlg.pbMRP7.clicked.connect(lambda: self.add_wms(mrp7))
            #MRP8 - MRP 0,2% negatywne konsekwencje dla środowiska, dziedzictwa kulturowego i działalności gospodarczej
            self.dlg.pbMRP8.clicked.connect(lambda: self.add_wms(mrp8))
            #MRP9 - MRP - całkowite zniszczenie wału powodziowego - potencjalne negatywne skutki dla środowiska, dziedzictwa kulturowego i działalności gospodarczej
            self.dlg.pbMRP9.clicked.connect(lambda: self.add_wms(mrp9))
            #MRP10 - MRP - całkowite zniszczenie wału powodziowego - potencjalne negatywne skutki dla środowiska, dziedzictwa kulturowego i działalności gospodarczej
            self.dlg.pbMRP10.clicked.connect(lambda: self.add_wms(mrp10))
            
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
            
    def add_wms(self, usluga):
            for warstwa in usluga:
                    url = ("contextualWMSLegend=0&"
                            "crs=EPSG:2180&"
                            "dpiMode=7&"
                            "format=image/png&"
                            "layers="+ warstwa[0]+"&"
                            "styles=&"
                            "version=1.3.0&"
                            "url="+warstwa[2])
                    layer = QgsRasterLayer(url, warstwa[1], 'wms')
                    layer.setCustomProperty("PGWWP", "wms_pgwwp_layer")
                    self.wms_pgwwp_layer = layer
                    QgsProject.instance().addMapLayer(self.wms_pgwwp_layer)
                    self.dlg.pbPGWWP.setEnabled(True)
                    
    #MPHP10k - działy wodne
    def add_wms_mphp_dzialy(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=0&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-działy wodne', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 1      
    def add_wms_mphp_zlewnie1(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=1&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 1', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 2      
    def add_wms_mphp_zlewnie2(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=2&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 2', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 3      
    def add_wms_mphp_zlewnie3(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=3&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 3', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 4      
    def add_wms_mphp_zlewnie4(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=4&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 4', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 5      
    def add_wms_mphp_zlewnie5(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=5&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 5', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 6      
    def add_wms_mphp_zlewnie6(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=6&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 6', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 7      
    def add_wms_mphp_zlewnie7(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=7&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 7', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
                #MPHP10k - Zlewnie poziomu 8      
    def add_wms_mphp_zlewnie8(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=8&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 8', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 9      
    def add_wms_mphp_zlewnie9(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=9&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 9', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 10      
    def add_wms_mphp_zlewnie10(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=10&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 10', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 11      
    def add_wms_mphp_zlewnie11(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=11&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 11', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 12      
    def add_wms_mphp_zlewnie12(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=12&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 12', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 13      
    def add_wms_mphp_zlewnie13(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=13&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 13', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Zlewnie poziomu 14      
    def add_wms_mphp_zlewnie14(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=14&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie poziomu 14', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - zlewnie elementarne      
    def add_wms_mphp_zlew_element(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=15&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-zlewnie elementarne', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)

    #MPHP10k - cieki  
    def add_wms_mphp_cieki(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=16&layers=17&layers=18&"
                    "styles=&styles=&styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-cieki', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - odcinki cieków  
    def add_wms_mphp_odcinki_ciek(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=19&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-odcinki cieków (skala od 75k)', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - cieki szerokie 
    def add_wms_mphp_cieki_s(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=20&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-cieki szerokie (skala od 75k)', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - jeziora 
    def add_wms_mphp_jeziora(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=21&layers=22&"
                    "styles=&styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-jeziora', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
                        
    #MPHP10k - Morza i zatoki 
    def add_wms_mphp_morza(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=23&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-morza i zatoki', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Węzły na działach wodnych 
    def add_wms_mphp_wezly_dzial(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=24&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-węzły na działach wodnych', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Węzły na ciekach wyróżnionych 
    def add_wms_mphp_wezly_ciek(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=25&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-węzły na ciekach wyróżnionych', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Sekcje mapy 
    def add_wms_mphp_sekcje(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=26&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-sekcje mapy', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Nazwy cieków 
    def add_wms_mphp_nazwy_ciek(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=27&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-nazwy cieków', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)
            
    #MPHP10k - Nazwy jezior 
    def add_wms_mphp_nazwy_jezior(self):
            url = ("contextualWMSLegend=0&"
                    "crs=EPSG:2180&"
                    "dpiMode=7&"
                    "format=image/png&"
                    "layers=28&"
                    "styles=&"
                    "version=1.3.0&"
                    "url=https://wody.isok.gov.pl/gpservices/KZGW/ISOK_MPHP/MapServer/WMSServer")
            layer = QgsRasterLayer(url, 'MPHP10k-nazwy jezior', 'wms')
            layer.setCustomProperty("MPHP10k", "wms_mphp_layer")
            self.wms_mphp_layer = layer
            QgsProject.instance().addMapLayer(self.wms_mphp_layer)
            self.dlg.pbMPHP.setEnabled(True)