# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Wfs_DERA
                                 A QGIS plugin
 Carga de los servicios Wfs de los Datos Espaciales de Referencia DERA  
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-02-07
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Manuel Cano
        email                : mcanop29@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import urllib.request
import zipfile
import urllib
from urllib import request, parse
import sys

# Import the PyQt and QGIS libraries
from qgis.PyQt.QtCore import Qt
# from PyQt5 import QtCore, QtGui, QtWidgets
import os

# from PyQt5.QtWidgets import QDialog

try:
    from qgis.core import Qgis
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
    from PyQt5 import uic

    QT_VERSION = 5
    os.environ['QT_API'] = 'pyqt5'
except:
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
    from PyQt4 import uic
    from qgis.core import QgsMapLayerRegistry

    QT_VERSION = 4

import os.path
from qgis.core import *

# import resources
from .resources import *


from .wfs_from_dera_dialog import wfsfromderadialog
from .listacapa import *
from qgis.core import QgsProject
from qgis.gui import QgsMessageBar
from qgis.utils import iface
from time import sleep
import webbrowser

platform = sys.platform

listTema = LISTTEMA
listCapa = LISTCAPA

#nada = ''
#codmuni = ''

class Wfs_DERA:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Wfs_DERA_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Datos Espaciales de Referencia Wfs')
        # TODO: We are going to let the user set this up in a future iteration
        #Se desactiva para que no cree un toolbar independiente del de complemento
        #self.toolbar = self.iface.addToolBar(u'Wfs_DERA')
        #self.toolbar.setObjectName(u'Wfs_DERA')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Wfs_DERA', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """
        # Create the dialog (after translation) and keep reference
        self.dlg = wfsfromderadialog()
        self.dlg.setWindowFlags(Qt.WindowSystemMenuHint | Qt.WindowTitleHint)

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/wfs_from_dera/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'wfs wms DERA'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Datos Espaciales de Referencia Wfs'),
                action)
            self.iface.removeToolBarIcon(action)

    #def open_pdf(self):

       # path = 'https://www.juntadeandalucia.es/institutodeestadisticaycartografia/DERA/documentos/informacion_basica_de_los_datos.pdf'
       # webbrowser.open(path)


    def filter_capa(self, index):
        """Message for fields without information"""

        tema = self.dlg.comboBox_tema.currentText()
        self.dlg.comboBox_capa.clear()

        self.dlg.comboBox_capa.addItems([cap for cap in listCapa if cap[6:8] == tema[6:8]])

        capa = self.dlg.comboBox_capa.currentText()

        #codprov = capa[0:6]
        #codmuni = capa[0:6]




    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started



        #if self.first_start == True:
         #   self.first_start = False
          #  self.dlg = wfsfromderadialog()

        # show the dialog

        #self.dlg.pushButton.clicked.connect(self.open_pdf)
        self.dlg.show()
        self.dlg.comboBox_tema.clear()
        self.dlg.comboBox_capa.clear()
        self.dlg.comboBox_tema.addItems(listTema)
        self.dlg.comboBox_tema.currentIndexChanged.connect(self.filter_capa)
        self.dlg.checkBox_wms.setChecked(0)
        self.dlg.checkBox_wfs.setChecked(0)



        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            if self.dlg.checkBox_wms.isChecked():

                capa = self.dlg.comboBox_capa.currentText()
                tema = self.dlg.comboBox_tema.currentText()
                indice_c = capa.index(':')
                subcapa = capa[indice_c + 1:]

                tmpURL = 'crs=EPSG:25830&dpiMode=7&format=image/png&layers=%s&styles&url=http://www.ideandalucia.es/services/%s/wms?' % (
                subcapa, tema)

                tmpRasterLayer = QgsRasterLayer(tmpURL.format(capa=subcapa, tema=tema),
                                            self.dlg.comboBox_capa.currentText(), 'wms')

                QgsProject.instance().addMapLayer(tmpRasterLayer)

                layer = iface.activeLayer()
                crs = layer.crs().authid()
                nombre = layer.name()
                indice_c = nombre.index(':')
                subnombre = nombre[indice_c + 2:]
                layer.setName('{} ({})'.format(subnombre, crs))



            if self.dlg.checkBox_wfs.isChecked():

                tmp_tema = "pagingEnabled='false' restrictToRequestBBOX='1' srsname='EPSG:25830' typename='{capa}' url='http://www.ideandalucia.es/services/{tema}/wfs?'"

                capa = self.dlg.comboBox_capa.currentText()
                tema = self.dlg.comboBox_tema.currentText()

                tmp_capa = QgsVectorLayer(tmp_tema.format(capa=capa, tema=tema), self.dlg.comboBox_capa.currentText(),
                                      'wfs')

                QgsProject.instance().addMapLayer(tmp_capa)

                layer = iface.activeLayer()
                crs = layer.crs().authid()
                nombre = layer.name()
                indice_c = nombre.index(':')
                subnombre = nombre[indice_c + 2:]
                layer.setName('{} ({})'.format(subnombre, crs))

            if self.dlg.checkBox_wms.checkState() == 0 and self.dlg.checkBox_wfs.checkState() == 0:
                QMessageBox.information(None, "Datos Espaciales de Referencia de Andalucía", "Debe seleccionar Tema, Capa y al menos un tipo de servicio")


         # Do something useful here - delete the line containing pass and
        # substitute with your code