#!/usr/bin/env python
# -*- coding: utf-8 -*-

#-----------------------------------------------------------
#
# QGIS wincan 2 QGEP Plugin
# Copyright (C) 2016 Denis Rouzaud
#
#-----------------------------------------------------------
#
# licensed under the terms of GNU GPL 2
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
#---------------------------------------------------------------------


from PyQt4.QtCore import pyqtSlot, pyqtSignal
from PyQt4.QtGui import QWidget

from wincan2qgep.core.mysettings import MySettings
from wincan2qgep.ui.ui_inspectionwidget import Ui_InspectionWidget



class InspectionWidget(QWidget, Ui_InspectionWidget):
    importChanged = pyqtSignal()

    def __init__(self, parent):
        QWidget.__init__(self, parent)
        self.setupUi(self)
        self.settings = MySettings()
        self.data = None
        self.projectId = None
        self.sectionId = None
        self.inspectionId = None

    def finishInit(self, data):
        self.data = data
        self.observationTable.finishInit(data)

    def setSection(self, projectId, sectionId):
        self.inspectionCombo.clear()
        self.projectId = projectId
        self.sectionId = sectionId
        for i_id, inspection in self.data[self.projectId]['Sections'][self.sectionId]['Inspections'].items():
            self.inspectionCombo.addItem(inspection['InspDate'].toString('dd.MM.yyyy'), i_id)
            #self.observationTable.clear()

    @pyqtSlot(int)
    def on_inspectionCombo_currentIndexChanged(self, idx):
            self.inspMethodEdit.clear()
            self.inspectionDirEdit.clear()
            self.inspectedLengthEdit.clear()
            self.operatorEdit.clear()

            #self.observationTable.clear()

            if self.projectId is None or self.sectionId is None:
                return

            if idx < 0:
                return

            self.inspectionId = self.inspectionCombo.itemData(idx)
            inspection = self.data[self.projectId]['Sections'][self.sectionId]['Inspections'][self.inspectionId]

            self.inspMethodEdit.setText(inspection['InspMethod'])
            self.inspectionDirEdit.setText(inspection['InspectionDir'])
            self.inspectedLengthEdit.setText('{}'.format(inspection['InspectedLength']))
            self.operatorEdit.setText(inspection['Operator'])
            self.importCheckBox.setChecked(inspection['Import'])

            self.observationTable.setInspection(self.projectId, self.sectionId, self.inspectionId)

    @pyqtSlot(bool)
    def on_importCheckBox_clicked(self, toImport):
        if self.projectId is None or self.sectionId is None or self.inspectionId is None:
            return
        self.data[self.projectId]['Sections'][self.sectionId]['Inspections'][self.inspectionId]['Import'] = toImport
        self.importChanged.emit()









