# -*- coding: utf-8 -*-
"""
/***************************************************************************
 WhiteBoard
                                 A QGIS plugin
 Whiteboard client
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-02-14
        git sha              : $Format:%H$
        copyright            : (C) 2021 by jan vrobel
        email                : vrobel.jan@seznam.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QTimer
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import QIcon, QRegExpValidator, QDoubleValidator, QFont, QColor
from qgis.PyQt.QtWidgets import QAction, QTreeWidgetItem, QMessageBox

# Initialize Qt resources from file resources.py
from .resources import *
import requests
import threading
import time
import json
# Import the code for the dialog
from .WhiteBoard_dialog import WhiteBoardDialog
from qgis.PyQt.QtCore import QSettings
import os.path
import socket
import uuid
import os
import tempfile
from qgis.core import QgsVectorLayer,QgsProject, QgsApplication, QgsMessageLog, QgsJsonUtils, QgsFields, QgsField, QgsWkbTypes, QgsRasterLayer,QgsCoordinateReferenceSystem, QgsVectorFileWriter, Qgis, QgsFeature, QgsGeometry, QgsPointXY,QgsPalLayerSettings,QgsTextFormat,QgsTextBufferSettings,QgsVectorLayerSimpleLabeling
from qgis.core import *
from .packages import socketio
from .whiteboardInstance import WhiteboardInstance, WFeature
from qgis.utils import iface
from qgis.core.additions.edit import edit
from .dlg_createComposite import CreateCompositeDialog
from .dlg_createMap import CreateMapDialog
from .dlg_registerUser import RegisterUserDialog
from qgis.gui import QgsMapMouseEvent
import pandas as pd
#import socketio


class WhiteBoard:
    """QGIS Plugin Implementation."""
    
    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.sio = None
        QSettings().setValue("/qgis/map_update_interval", 150)
        QgsApplication.messageLog().messageReceived.connect(self.write_log_message)
        self.iface = iface
        self.featIds = 0
        self.layerCallback = None
        self.delFeatureCallback = None
        self.addFeatureCallback = None
        self.mapChangedCallback = None
        self.username = None
        self.ownMap = False
        self.mapId = None
        self.userPositions = list()
        self.layerEmited = False
        self.cursorCallback = ""
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'WhiteBoard_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&WhiteBoard')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        self.plugin_dir = os.path.dirname(__file__) 
        self.ownLayer = True
        ## prepare temp dir
        self.tempDir = tempfile.gettempdir() + os.sep + "Whiteboard" 
        try:
            os.mkdir(self.tempDir)
            print("Directory " , self.tempDir ,  " Created ") 
        except FileExistsError:
            print("Directory " , self.tempDir ,  " already exists")

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('WhiteBoard', message)
    def deleteMap(self,mapId):
        url = self.URI + "/maps/" + str(mapId) + "?session="+ self.session
        r = requests.delete(url)
        print(r.content)
        if r.status_code == 200:
            root = self.dlg.treeWidget.invisibleRootItem()
            for item in self.dlg.treeWidget.selectedItems():
                (item.parent() or root).removeChild(item)
            print("uspech")
    ### dialogs
    def buttonEnabled(self):
        try:
            print(self.dlg.treeWidget.selectedItems()[0].text(0))
            print(self.mapId)
            if self.dlg.treeWidget.selectedItems()[0].text(0) == self.mapId:
                self.dlg.pushButton_delete.setEnabled(False)
            else:
                self.dlg.pushButton_delete.setEnabled(True)
        except:
            self.dlg.pushButton_delete.setEnabled(False)
    def fillUsersAccess(self, mapId):
        self.dlg.treeWidget_users.clear()
        ## all users##
        print("all")
        print(self.session)
        #url = self.URI + "/users?session="+ self.session
        #r = requests.get(url)
        #res = self.fromByteToJson(r.content)
        #print(res)
        #users = list()

        #usersInMap = list()
        usersInMapRights = list()

        #if (res['success']) == False:
        #    QMessageBox.information(None, "Whiteboard", "Operation was not successfull!")
        #    return
        #for user in res['data']:
        #    users.append(user['email'])
        ##
        ## users in map##
        print("maps")
        url = self.URI + "/maps/" + mapId + "/privileges?session="+ self.session

        r = requests.get(url)
        print(r.content)
        res = self.fromByteToJson(r.content)
        #print(res)
        for user in res['data']:
            #usersInMap.append(user['user'])
            usersInMapRights.append(user['right'])
            item = QTreeWidgetItem([user['user'],user['right']])
            self.dlg.treeWidget_users.addTopLevelItem(item)
            if self.username == user['user'] and user['right'] != "own":
                self.dlg.pushButton_setPermissionsAdd.setEnabled(False)
                self.dlg.pushButton_setPermissions.setEnabled(False)
                self.ownMap = False
            if self.username == user['user'] and user['right'] == "own":
                self.dlg.pushButton_setPermissionsAdd.setEnabled(True)
                self.dlg.pushButton_setPermissions.setEnabled(True)
                self.ownMap = True

        ##
        #for i in range (len(usersInMap)):
        #    item = QTreeWidgetItem([usersInMap[i],usersInMapRights[i]])
        #    self.dlg.treeWidget_users.addTopLevelItem(item)
        #for i in range (len(users)):
        #    #if users[i] not in usersInMap:
        #    #    item = QTreeWidgetItem([users[i],"No access"])
        #        self.dlg.treeWidget_users.addTopLevelItem(item)
    def permissionsHelper(self):
        try: 
            self.setPermissions(self.dlg.treeWidget.selectedItems()[0].text(1), self.dlg.treeWidget_users.selectedItems()[0].text(0), self.dlg.comboBox_permissions.currentText()) 
        except:     
            self.setPermissions(self.dlg.treeWidget.selectedItems()[0].text(1), "", self.dlg.comboBox_permissions_2.currentText())

    def setPermissions(self, mapId, user, access):
        print(access)
        if (len(self.dlg.lineEdit_newUsername.text()) > 0):
            newUser = self.dlg.lineEdit_newUsername.text()
            url = self.URI + "/users/find/" + newUser + "?session="+ self.session
            r = requests.get(url)
            print(r.content)
            res = self.fromByteToJson(r.content)
            if res['success'] == True:
                user = newUser
            else:
                QMessageBox.information(None, "Whiteboard", "This user does not exits!")
        if access == "No access":
            url = self.URI + "/maps/" + mapId + "/privileges?session="+ self.session
            r = requests.get(url)
            res = self.fromByteToJson(r.content)
            privilegeId = None
            for usr in res['data']:
                if usr['user'] == user:
                    privilegeId = usr['_id']

            url = self.URI + "/maps/" + mapId + "/privileges/"+privilegeId+"?session="+ self.session
            r = requests.delete(url)
        else:
            data = {
              "user": user,
              "right": access
            }
            print (data)
            url = self.URI + "/maps/" + mapId + "/privileges?session="+ self.session
            r = requests.post(url, data=data)
            print(r.content)
            res = self.fromByteToJson(r.content)
            if res['success'] == False and res['message'] == "This user already has access to this map composition":
                url = self.URI + "/maps/" + mapId + "/privileges?session="+ self.session
                r = requests.get(url)
                res = self.fromByteToJson(r.content)
                privilegeId = None
                for usr in res['data']:
                    if usr['user'] == user:
                        privilegeId = usr['_id']
                data = {
                  "privilegeId": privilegeId,
                  "right": access
                }
                r = requests.put(url, data=data)
                res = self.fromByteToJson(r.content)
                print(res)
            elif res['success'] == False:
                QMessageBox.information(None, "Whiteboard", "Operation was not successfull!")
        self.fillUsersAccess(mapId)
    def registerUser(self):
        url = self.URI + "/users"
        data = {
          "username": self.dlg.lineEdit_usernameReg.text(),
          "email": self.dlg.lineEdit_emailReg.text(),
          "password": self.dlg.lineEdit_passReg.text()
        }
        r = requests.post(url,data)        
        res = self.fromByteToJson(r.content)
       # print(r.content)
        if res['success'] == True:
            iface.messageBar().pushWidget(iface.messageBar().createMessage("Whiteboard:", "User was successfully registered"), Qgis.Success, duration=5)
            self.afterCloseDialog()
        else:
            QMessageBox.information(None, "Whiteboard", "Operation was not successfull!")
        
    def run_RegisterUserDialog(self):
        self.dlg = RegisterUserDialog()
        self.dlg.show()
        self.dlg.pushButton_CreateUser.clicked.connect(lambda: self.registerUser())
        self.dlg.rejected.connect(lambda: self.afterCloseDialog())  

    def run_CreateMapDialog(self):
        self.dlg = CreateMapDialog()
        self.dlg.rejected.connect(lambda: self.afterCloseDialog())  
        self.dlg.pushButton_defaultExtent.clicked.connect(lambda: self.setCenter())  
        self.dlg.pushButton_CreateComposition.clicked.connect(lambda: self.createComposite(self.dlg.lineEdit_7.text(),self.dlg.lineEdit_2.text(), self.dlg.lineEdit_x.text(), self.dlg.lineEdit_y.text()))      
        self.dlg.pushButton_CreateComposition.setStyleSheet("""#pushButton_CreateComposition {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_CreateComposition:hover{background: #00b4ff ;}#pushButton_CreateComposition:disabled{background: #6d7481 ;}""")
        self.dlg.pushButton_defaultExtent.setStyleSheet("""#pushButton_defaultExtent {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_defaultExtent:hover{background: #00b4ff ;}#pushButton_defaultExtent:disabled{background: #6d7481 ;}""")
        self.dlg.lineEdit_x.setStyleSheet("""border-radius: 7px; border: 1px solid #0076ff;""")
        self.dlg.lineEdit_y.setStyleSheet("""border-radius: 7px; border: 1px solid #0076ff;""")
        self.dlg.lineEdit_7.setStyleSheet("""border-radius: 7px; border: 1px solid #0076ff;""")
        self.dlg.lineEdit_2.setStyleSheet("""border-radius: 7px; border: 1px solid #0076ff;""")
        self.dlg.show()

    def run_CreateCompositeDialog(self):
        self.dlg = CreateCompositeDialog()
        
        self.dlg.pushButton_close.hide()
        self.dlg.label_2.hide()
        self.dlg.lineEdit.hide()
        self.dlg.pushButton_url.setEnabled(False)
        #self.dlg.pushButton_save.hide()
        #self.dlg.pushButton_CreateComposition.clicked.connect(lambda: self.createComposite(self.dlg.lineEdit_7.text(),self.dlg.lineEdit_2.text(), self.dlg.lineEdit_x.text(), self.dlg.lineEdit_y.text()))              
        layers = QgsProject.instance().mapLayers().values()
        self.dlg.pushButton_delete.clicked.connect(lambda: self.deleteMap(self.dlg.treeWidget.selectedItems()[0].text(0)))
        self.dlg.pushButton_delete.setStyleSheet("""#pushButton_delete {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_delete:hover{background: #00b4ff ;}#pushButton_delete:disabled{background: #6d7481 ;}""")
        self.dlg.pushButton_unload.setStyleSheet("""#pushButton_unload {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_unload:hover{background: #00b4ff ;}#pushButton_unload:disabled{background: #6d7481 ;}""")
        self.dlg.pushButton_selectMap.setStyleSheet("""#pushButton_selectMap {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_selectMap:hover{background: #00b4ff ;}#pushButton_selectMap:disabled{background: #6d7481 ;}""")
        self.dlg.pushButton_setPermissions.setStyleSheet("""#pushButton_setPermissions {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_setPermissions:hover{background: #00b4ff ;}#pushButton_setPermissions:disabled{background: #6d7481 ;}""")       
        self.dlg.pushButton_CreateCompositionDlg.setStyleSheet("""#pushButton_CreateCompositionDlg {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_CreateCompositionDlg:hover{background: #00b4ff ;}#pushButton_CreateCompositionDlg:disabled{background: #6d7481 ;}""")
        self.dlg.pushButton_setPermissionsAdd.setStyleSheet("""#pushButton_setPermissionsAdd {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_setPermissionsAdd:hover{background: #00b4ff ;}#pushButton_setPermissionsAdd:disabled{background: #6d7481 ;}""")       
        self.dlg.pushButton_loadFromUrl.setStyleSheet("""#pushButton_loadFromUrl {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_loadFromUrl:hover{background: #00b4ff ;}#pushButton_loadFromUrl:disabled{background: #6d7481 ;}""")
        self.dlg.pushButton_url.setStyleSheet("""#pushButton_url {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_url:hover{background: #00b4ff ;}#pushButton_url:disabled{background: #6d7481 ;}""")       
        self.dlg.lineEdit_mapIDexternal.setStyleSheet("""border-radius: 7px; border: 1px solid #0076ff;""")
        self.dlg.lineEdit_newUsername.setStyleSheet("""border-radius: 7px; border: 1px solid #0076ff;""")
        self.dlg.groupBox_2.setStyleSheet(""" #comboBox_permissions_2 {border: 1px solid #0076ff;}""")
        self.dlg.tabWidget.setStyleSheet(""" #tabWidget tab {background: rgb(230, 230, 230);   border: 1px solid lightgray;   padding: 15px;}""")
        stylesheet = """ 
            QTabBar::tab {background: #6d7481;margin-right: 5px; color: white; border-top-left-radius: 5px; border-top-right-radius: 5px;padding:10px;}
            
            QTabBar::tab:selected {background: #0076ff!important;}
            
            """

        self.dlg.setStyleSheet(stylesheet)
        self.dlg.pushButton_setPermissions.setEnabled(False)
        self.dlg.pushButton_clearMap.hide()
        maps = self.getCompositionsList(self.session)
        sharedMaps = self.getSharedCompositionsList(self.session)
        if maps != None:
            for map in maps:
                item = QTreeWidgetItem([map['title'], map['_id']]) 
                self.dlg.treeWidget.addTopLevelItem(item)
            if sharedMaps:
                for map in sharedMaps:
                    item = QTreeWidgetItem([map['title'], map['_id']]) 
                    self.dlg.treeWidget.addTopLevelItem(item)
        
        #self.dlg.lineEdit_newUsername.textChanged.connect(lambda: self.dlg.pushButton_setPermissions.setEnabled(True))
        #for layer in layers:
        #   # self.dlg.listWidget_listLayers.addItem(layer.name())
        #    if (layer.type() == QgsMapLayer.VectorLayer):
        #        item = QTreeWidgetItem([layer.name()]) 
        self.dlg.comboBox_permissions.addItem('Read')
        self.dlg.comboBox_permissions.addItem('Write')
        self.dlg.comboBox_permissions.addItem('No access')
        self.dlg.comboBox_permissions_2.addItem('Read')
        self.dlg.comboBox_permissions_2.addItem('Write')
        self.dlg.comboBox_permissions_2.addItem('No access')
        self.dlg.pushButton_CreateCompositionDlg.clicked.connect(lambda: self.showCreateDialog())
        self.dlg.pushButton_unload.clicked.connect(lambda: self.clean())       
        self.dlg.pushButton_url.clicked.connect(lambda: self.copyToClipboard())
        self.dlg.pushButton_setPermissions.clicked.connect(lambda: self.permissionsHelper())
        self.dlg.pushButton_setPermissionsAdd.clicked.connect(lambda: self.permissionsHelper())
        self.dlg.treeWidget.itemClicked.connect(self.buttonEnabled)   
        self.dlg.pushButton_selectMap.clicked.connect(lambda: self.getLayers(self.session, self.dlg.treeWidget.selectedItems()[0].text(1), self.username, ""))
        self.dlg.pushButton_loadFromUrl.clicked.connect(lambda: self.getLayers(self.session, self.dlg.lineEdit_mapIDexternal.text(), self.username, ""))
        #        self.dlg.treeWidget.addTopLevelItem(item)
        self.dlg.treeWidget.itemClicked.connect(self.fillTextboxes)
        self.dlg.label_usr.setText(self.username)
        self.dlg.treeWidget.itemClicked.connect(lambda: self.fillUsersAccess(self.dlg.treeWidget.selectedItems()[0].text(1)))
        self.dlg.lineEdit.setValidator(QRegExpValidator(QRegExp("[a-z]{1}[a-z0-9]{1,30}")))      
        self.dlg.treeWidget_users.itemClicked.connect(lambda: self.enablePermissionsButton())
        self.dlg.treeWidget.itemClicked.connect(lambda: self.dlg.pushButton_setPermissions.setEnabled(False))
        #self.setCenter()
        #self.dlg.pushButton_defaultExtent.clicked.connect(lambda: self.setCenter())              
        #self.dlg.pushButton_defaultExtent.setStyleSheet("#pushButton_defaultExtent {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_defaultExtent:hover{background: #66ab27 ;}#pushButton_defaultExtent:disabled{background: #64818b ;}")
        #self.dlg.pushButton_CreateComposition.setStyleSheet("#pushButton_CreateComposition {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_CreateComposition:hover{background: #66ab27 ;}#pushButton_CreateComposition:disabled{background: #64818b ;}")
        #self.dlg.pushButton_close.setStyleSheet("#pushButton_close {color: #fff !important;text-transform: uppercase;  text-decoration: none;   background: #72c02c;   padding: 20px;  border-radius: 50px;    display: inline-block; border: none;transition: all 0.4s ease 0s;} #pushButton_close:hover{background: #66ab27 ;}")
        
        #self.dlg.setStyleSheet("#DialogBase {background: #f0f0f0 ;}")
        #self.dlg.rejected.connect(lambda: self.afterCloseDialog())  
        self.dlg.show()
        self.dlg.pushButton_close.clicked.connect(lambda: self.dlg.close())
        #if (fromImport):
            #self.dlg.rejected.connect(lambda: self.afterCloseCompositeDialog())
        result = self.dlg.exec_()

    def parseMapUrl(self, input):
        #url ="https://dih.bosc.lv/whiteboard-demo/admin/map/6065cda385d8250010787d79/?hs_panel=layermanager&hs_x=2838384.1419443055&hs_y=7837925.97841041&hs_z=9&visible_layers=Open%20street%20map%3BCursor%20layer%3BScratch%20layer"
       
        splitted = input.split('/')
       # print(splitted[6])
        print(splitted)
        #test = "6065cda385d8250010787d79"
        #test = test.split("/")
        #print(len(test))
        if len(splitted) == 1:
            return splitted[0]
        else:
            splitted = splitted[6].split("?")[0]
            return splitted

    ### end dialogs
    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action
    def copyToClipboard(self):
        values = self.instance.getCompositionInfo(self.mapId)
        data = {
          "title": values[0],          
          "description": values[1],
          "defaultRights": "anyone"
        }    
        url = self.URI + "/maps/"+self.mapId+"/metadata?session=" + self.session
        r = requests.put(url, data=data)

       
        res = self.fromByteToJson(r.content)
        if res['success'] == True:
            iface.messageBar().pushWidget(iface.messageBar().createMessage("Whiteboard:", "Link copied to clipboard."), Qgis.Success, duration=5)
        text = "https://dih.bosc.lv/whiteboard-demo/admin/map/" + self.mapId
        df=pd.DataFrame([text])
        df.to_clipboard(index=False,header=False)

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/WhiteBoard/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Whiteboard'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""       
        print("closing")   
        
       
         
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&WhiteBoard'),
                action)
            self.iface.removeToolBarIcon(action)
       

    def getTempFolder(self):
        return tempfile.gettempdir() + os.sep + "whiteboard" + os.sep
    def afterCloseDialog(self):
        self.dlg = self.old_dlg
        try:
            self.refreshCombobox()
        except:
            print("")
    def setCenter(self):
        ext = iface.mapCanvas().extent()
        x = str(int(iface.mapCanvas().extent().center().x()))
        y = str(int(iface.mapCanvas().extent().center().y()))        
        self.dlg.lineEdit_x.setText(x)
        self.dlg.lineEdit_y.setText(y)
    def write_log_message(self,message, tag, level):
        if message == "refreshLayers":
            #for layer in self.iface.mapCanvas().layers():
            #    layer.dataProvider().reloadData()
            pass
    def loadBaseMap(self):
        urlWithParams = 'type=xyz&url=http://a.tile.openstreetmap.org/%7Bz%7D/%7Bx%7D/%7By%7D.png&zmax=19&zmin=0&crs=EPSG4326'
        rlayer = QgsRasterLayer(urlWithParams, 'OpenStreetMap', 'wms') # EDIT THIS LINE
        rlayer.setCrs( QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId) )
        if rlayer.isValid():
            QgsProject.instance().addMapLayer(rlayer)
        else:
            print('invalid layer')
    def fromByteToJson(self, res):
        try:
            pom = res        
            pom = pom.decode('utf_8')
            pom = json.loads(pom)
        except:
            QMessageBox.information(None, "Whiteboard", "Connection failed!")
        return pom
    # TPtA6AdIoLM0lDxzxDvahBY5

    def fillTextboxes(self):
        mapId = self.dlg.treeWidget.selectedItems()[0].text(1)
        url = self.URI + "/maps/"+mapId+"/metadata?session=" + self.session
        r = requests.get(url)
        req = self.fromByteToJson(r.content)        
        #self.dlg.lineEdit_2.setText(req['data']['title'])
        #self.dlg.lineEdit_7.setText(req['data']['description'])

        pass
    def getSharedCompositionsList(self,session):
        url = self.URI + "/maps/shared?session="  + session     
        r = requests.get(url)     
        res = self.fromByteToJson(r.content)      
        if len(res['data']) == 0:
            return None
        else:            
            return res['data']

    def enablePermissionsButton(self):
        if self.ownMap:
            self.dlg.pushButton_setPermissions.setEnabled(True)
            self.dlg.pushButton_setPermissionsAdd.setEnabled(True)
        else:
            self.dlg.pushButton_setPermissions.setEnabled(False)
            self.dlg.pushButton_setPermissionsAdd.setEnabled(False)
    def getCompositionsList(self,session):     
        url = self.URI + "/maps?session="  + session
     
        r = requests.get(url)
       # print("xx")
       # print(r.content)
        res = self.fromByteToJson(r.content)
      #  print(res)
        if len(res['data']) == 0:
            return None
        else:
            
            return res['data']
    def getSharedCompositionsList(self,session):     
        url = self.URI + "/maps/shared?session="  + session
     
        r = requests.get(url)
       # print("xx")
       # print(r.content)
        res = self.fromByteToJson(r.content)
      #  print(res)
        if len(res['data']) == 0:
            return None
        else:
            
            return res['data']
    def refreshLayer(self, url, layerPath):
        while True:
            r = requests.get(url)      
       
            with open(layerPath, "wb") as f:
                f.write(r.content)
                QgsMessageLog.logMessage("refreshLayers")
                time.sleep(10)
        #while True:
        #    QgsMessageLog.logMessage("refreshLayers")
        #    time.sleep(3)

    def refresh(self):
       # print("xx")
        for layer in self.iface.mapCanvas().layers():
            layer.dataProvider().reloadData()


    def getLayerJson(self, layer):
        import uuid
        filePath = self.tempDir + os.sep +  layer.name()+ ".geojson"     
        ogr_driver_name = "GeoJSON" 
        layerCrs = layer.crs().authid()
        crs = QgsCoordinateReferenceSystem(layerCrs)          
        result = QgsVectorFileWriter.writeAsVectorFormat(layer, filePath, "utf-8", crs, ogr_driver_name) # export jsonu do souboru
        f = open(filePath, "r")
        geojson = f.read()
        f.close()
        #geojson = None
        layerId = str(uuid.uuid4()).replace("-","")[-24:]
        json = """{
           "metadata":{
              "id":\""""+layerId+""""
           },
           "visibility":true,
           "opacity":1,
           "title":\""""+layer.name()+"""\",
           "path":"User generated",
           "className":"Vector",
           "features": {
            "type": "FeatureCollection",
            "features": []
          },
           "maxResolution":null,
           "minResolution":0,
           "projection":"epsg:4326",           
           "whiteboardLayerId":\""""+layerId+"""\"
        }
        """
        path = self.tempDir + os.sep +  layer.name() + ".json"          
        f = open(path, "w")
        f.write(json)
        f.close()    
        
        url = self.URI + "/maps/"+self.mapId+"/layers?session="  + self.session
        print(url)       
        #headers = {'Content-type': 'application/json; charset=utf-8'}
        #headers = {'Content-type': 'multipart/form-data', 'accept': 'application/json'}
        files = {'file': (path, open(path, 'rb'))} 
        r = requests.post(url, files=files)        
       # print(r.content)
        res = self.fromByteToJson(r.content)
        print(res['success'])
        if res['success'] == True:
            print("successfully created layer")
            iface.messageBar().pushWidget(iface.messageBar().createMessage("Whiteboard:", " Layer was successfully created."), Qgis.Success, duration=5)
        return layerId
    def createComposite(self, abstract, title, x, y):
        composite = self.createEmptyComposite(abstract, title, x, y)
        path = self.tempDir + os.sep +  "map.json"
        f = open(path, "w")
        f.write(str(composite).replace("'","\""))
        f.close()          
        url = self.URI + "/maps?session="  + self.session
        files = {'file': (path, open(path, 'rb'))} 
        r = requests.post(url, files=files)
        print(r.content)
        res = self.fromByteToJson(r.content)

        #self.instance.setComposition(res['data']['_id'], title, abstract) 
        self.instance.setComposition(res['data']['_id'], title) 
        self.dlg.close()
        self.afterCloseDialog()
        if res['success'] == True:
            id = res['data']['_id']
            title = res['data']['title']
            ## add item to treewidget
            item = QTreeWidgetItem([title,id]) 
            self.dlg.treeWidget.addTopLevelItem(item)
            iface.messageBar().pushWidget(iface.messageBar().createMessage("Whiteboard", "Composition was created successfully"), Qgis.Success, duration=5)
        else:
            iface.messageBar().pushWidget(iface.messageBar().createMessage("Whiteboard", "Creating composition was not successfull."), Qgis.Warning, duration=5)



    def createEmptyComposite(self, abstract, title, x ,y ):
        epsg = "epsg:3857"
        json = {"abstract":abstract,"title":title, "user":{"email":self.username},"groups":{"guest":"r"}, "scale":1, "projection":epsg, "center":[ x, y ], "units":"m", "layers":[], "current_base_layer":{ "title":"Open street map"}   }
        print("######## new json ##########")
        print(json)
        print("############################")
        return json
    def checkMapChanges(self):       
        if self.mapChangedCallback != self.sio.getMapChangedCallback():
            self.mapChangedCallback = self.sio.getMapChangedCallback()
            if self.mapChangedCallback['reason'] == 'layer-remove':
                print(self.mapChangedCallback)
                try:
                    self.prj.layerWillBeRemoved.disconnect()
                except:
                    print("TypeError: disconnect() failed between 'layerWillBeRemoved' and all its connections")
                layerId = self.mapChangedCallback['layerId']
                layers = self.instance.getLayer(self.mapId, layerId)
                for layer in layers:
                    try:
                        QgsProject.instance().removeMapLayers([layer.id()]) 
                    except:
                        print("layer already deleted - nothing to do")                       

            if self.mapChangedCallback['reason'] == 'layer-add':
                pass
            if self.mapChangedCallback['reason'] == 'layer-update':
                pass
            if self.mapChangedCallback['reason'] == 'layer-style':
                pass
            if self.mapChangedCallback['reason'] == 'layer-order-change':
                pass
            if self.mapChangedCallback['reason'] == 'layer-remove':
                pass

            ###
#            {
#  mapId: string;
#  reason:
#    | "layer-add"
#    | "layer-update"
#    | "layer-style"
#    | "layer-order-change"
#    | "layer-remove";
#  layerId?: string;
#  definition: any;
#}              
            



    #def checkLayerChangesOld(self, url, layer, res):
    #    #print(res)
    #    while True:
    #        time.sleep(2)
    #        res2 = requests.get(url).content
    #        if (res != res2):                
    #            print("changed")
    #            res = res2
    #            #layer.featureAdded.disconnect()
    #            j = self.fromByteToJson(res)
    #            own = False
    #            ids = self.feats.getIds()       
               
               
    #            for f in j['features']:

    #                if (f['_id'] in ids):
    #                    own = True
                       
    #            if not own:
    #                self.refreshFeatures(layer, res2)
    #        else:
    #            pass
    #           # print("nochanged")
    def checkLayerChanges(self):
        #print(res)
        type = None        
        if (self.addFeatureCallback != self.sio.getAddFeatureCallback() or self.delFeatureCallback != self.sio.getDelFeatureCallback()):   
            
            if (self.addFeatureCallback != self.sio.getAddFeatureCallback()):
                if (self.sio.getAddFeatureCallback()['type'] == 'insert'):
                
                    try:
                        self.prj.layerWasAdded.disconnect()
                    except:
                        ## interrupted 
                        print("chyba disconnect") ## kdyz neco spadne v prubehu
                       # self.prj.layerWasAdded.connect(self.layerAdded)
                    self.addFeatureCallback = self.sio.getAddFeatureCallback()
                    print(self.sio.getAddFeatureCallback())
                    type = "add"

                    layerId = self.sio.getAddFeatureCallback()['layer']['id']
                    layerName = self.sio.getAddFeatureCallback()['layer']['name']
                    layerName = layerName.lower().replace(" ", "_")
                    featureId = self.sio.getAddFeatureCallback()['feature']['_id']
                    if layerId == None:
                        print("error: missing layerID")
                        return
                    layers = QgsProject.instance().mapLayersByName(layerName)
                    #layers = self.instance.getLayer(self.mapId, layerId)
                    json = self.addFeatureCallback
                    json = str(json).replace("'", "\"")
                    feats = QgsJsonUtils.stringToFeatureList(json, QgsFields(), None)

                    geom_type = feats[0].geometry().type()
                    print(geom_type)
                    if geom_type == QgsWkbTypes.PointGeometry:
                        print("point feature")
                        geotype = "MultiPoint"
                        presentLayer = False
                        for lay in layers:
                            print(lay)
                            if lay.wkbType() == QgsWkbTypes.MultiPoint:
                                presentLayer = True
                                layer = lay 
                        if presentLayer: 
                            try:
                                layer.featureAdded.disconnect()
                            except:
                                print ("except: TypeError: disconnect() failed between 'layerWasAdded' and all its connections ")
                            try:
                                with edit(layer):
                                    layer.addFeatures(feats)
                            except:
                                print("layers is already in editing mode")
                                layer.addFeatures(feats)
                            layer.updateExtents()
                            layer.featureAdded.connect(self.featAdded)
                        else:
                            layer = QgsVectorLayer(geotype,layerName, "memory")
                            self.instance.setLayer(self.mapId, layerId, layer)
                            QgsProject.instance().addMapLayer(layer)
                            with edit(layer):
                                layer.addFeatures(feats)
                            layer.updateExtents()
                            layer.featureAdded.connect(self.featAdded)
                            layer.featureDeleted.connect(self.featDel)
                    elif geom_type == QgsWkbTypes.LineGeometry:
                        print("line feature")
                        geotype = "MultiLineString"
                        presentLayer = False
                        for lay in layers:
                            print(lay)
                            if lay.wkbType() == QgsWkbTypes.MultiLineString:
                                presentLayer = True
                                layer = lay 
                        if presentLayer:                   
                    
                            layer.featureAdded.disconnect()
                            try:
                                with edit(layer):
                                    layer.addFeatures(feats)
                            except:
                                layer.addFeatures(feats)
                                print("layers is already in editing mode")
                            layer.updateExtents()
                            layer.featureAdded.connect(self.featAdded)

                        else:
                            layer = QgsVectorLayer(geotype,layerName, "memory")
                            self.instance.setLayer(self.mapId, layerId, layer)
                            QgsProject.instance().addMapLayer(layer)
                            with edit(layer):
                                layer.addFeatures(feats)
                            layer.updateExtents()
                            layer.featureAdded.connect(self.featAdded)
                            layer.featureDeleted.connect(self.featDel)
                    elif geom_type == QgsWkbTypes.PolygonGeometry:
                        print("polygon feature")
                        geotype = "MultiLinePolygon"
                        presentLayer = False
                        for lay in layers:                      
                            if lay.wkbType() == QgsWkbTypes.Polygon:
                                presentLayer = True
                                layer = lay 
                        if presentLayer:
                            layer.featureAdded.disconnect()
                            try:
                                with edit(layer):
                                    layer.addFeatures(feats)
                            except:
                                layer.addFeatures(feats)
                                print("layers is already in editing mode")
                            layer.updateExtents()
                            layer.featureAdded.connect(self.featAdded)
                        else:
                            layer = QgsVectorLayer("Polygon",layerName, "memory")
                            self.instance.setLayer(self.mapId, layerId, layer)
                            QgsProject.instance().addMapLayer(layer)
                            with edit(layer):
                                layer.addFeatures(feats)
                            layer.updateExtents()
                            layer.featureAdded.connect(self.featAdded)
                            layer.featureDeleted.connect(self.featDel)
                    
                

                    self.featIds = self.featIds + 1
                    feats[0].setId(self.featIds) 
                    self.feats.setFeature(feats[0], self.featIds, featureId, layerId, self.mapId)
                    self.prj.layerWasAdded.connect(self.layerAdded)

            if (self.delFeatureCallback != self.sio.getDelFeatureCallback()):
                #try:
                #    self.prj.layerWillBeRemoved.disconnect()
                #except:
                #    print("chyba: disconnect() failed between 'layerWillBeRemoved' and all its connections") 
                self.delFeatureCallback = self.sio.getDelFeatureCallback()
                layerId = self.sio.getDelFeatureCallback()['layer']['id']
                type = "del"
                layerName = self.sio.getDelFeatureCallback()['layer']['name']
                layerName = layerName.lower().replace(" ", "_")
                featureId = self.sio.getDelFeatureCallback()['featureId']
                print(layerName + "layerName")
                layers = QgsProject.instance().mapLayersByName(layerName)
                print(len(layers))
                feat = self.feats.getFeatureByWid(featureId)
                print(layerId, layerName, featureId, layers, feat, feat.id())

                ##teast
                for layer in layers:  
                    layer.featureDeleted.disconnect()
                    layer.featureAdded.disconnect()
                    feats = list(layer.getFeatures())
                    print("featureID" + str(feat.id()))
                    for f in layer.getFeatures():
                        print(f.id())
                    #del feature
                    if not layer.isEditable():
                        feature = layer.getFeature(feat.id()) 
                        with edit(layer):                        
                            layer.deleteFeature(feature.id())
                    else:
                        feature = layer.getFeature(feat.id()*(-1)-1) 
                        layer.deleteFeature(feature.id())
                    #newFeats = list()
                    #print(feat.id())
                    #for f in feats:
                    #    print("debug")
                    #    print(f.id(), feat.id())
                    #    print("debug")
                    #    if f.id() == feat.id():
                    #        print("match")
                    #    else:    
                                  
                    #        newFeats.append(f)
                    #        print("feat added to list")

                    #try: 
                    #    with edit(layer):
                    #        for feat in feats:
                    #            layer.deleteFeature(feat.id())
                    #           # self.feats.removeFeatByQid(feat.id())
                    #            print("deleting")
                    
                    #except:
                    #    print("deleting - editing mode")
                    #    for feat in feats:
                    #        layer.deleteFeature(feat.id()*(-1)) 
                    #       # self.feats.removeFeatByQid(feat.id())
                    ##self.feats.removeLayerFeatures(layerId)
                    ##self.featIds = self.featIds + 1
                    ##f.setId(self.featIds) 
                    ##self.feats.setFeature(f, self.featIds, featureId, layerId, self.mapId)
                    ##newFeats.append(f)
                        
                    #        #try: 
                    #        #    with edit(layer):
                    #        #        print("deleting")
                    #        #        layer.deleteFeature(f.id())
                    #        #except:
                    #        #    print("deleting - editing mode")
                    #        #    layer.deleteFeature(f.id())
                    ##    else:                            
                    ##        self.featIds = self.featIds + 1
                    ##        f.setId(self.featIds) 
                    ##        self.feats.setFeature(f, self.featIds, featureId, layerId, self.mapId)
                    ##        newFeats.append(f)
                    ##try:
                    ##    with edit(layer):
                    ##        print("deleting")
                    ##        for feat in feats:
                    ##            layer.deleteFeature(feat.id())
                    ##except:
                    ##    print("deleting - editing mode")
                    ##    for feat in feats:
                    ##        layer.deleteFeature(feat.id())
                    ##for feat in newFeats:
                    ##    self.featIds = self.featIds + 1
                    ##    self.feats.setFeature(feat, self.featIds, wid, wlayerId, self.mapId)
                    #pr = layer.dataProvider()                   
                    #pr.addFeatures(newFeats)
                    layer.updateExtents() 
                    layer.triggerRepaint() 
                    layer.featureAdded.connect(self.featAdded)
                    layer.featureDeleted.connect(self.featDel)
                    ## konec test
                
                #for layer in layers:   
                #    print("before")
                #    print(len(list(layer.getFeatures())))
                #    print("before")
                #    layer.featureDeleted.disconnect()
                #    try:
                #        with edit(layer):    
                #            try:
                #                print("deleting")
                #                print(layer.deleteFeature(feat.id()))
                #            except:
                #                print("attributed changed")
                #    except:
                #        print(layer.deleteFeature(feat.id()))
                #        print("layers is already in editing mode")
                #    print("after")
                #    print(len(list(layer.getFeatures())))
                #    print("after")
                #    layer.updateExtents()                   
                #    layer.featureDeleted.connect(self.featDel)



                #self.prj.layerWillBeRemoved.connect(self.layerRemoved) 
        #    url = self.URI + "/maps/"+self.mapId+"/layers/"+layerId+"/features?session=" + self.session
        #    res = requests.get(url).content
        #    print("changed")  
        #    print(res)
        #    #layers = self.instance.getLayer(self.mapId, layerId)
        #    layers = QgsProject.instance().mapLayersByName(layerName)
            
        #    #layer.featureAdded.disconnect()
        #    j = self.fromByteToJson(res)
        #   # own = False
        #    ids = self.feats.getIds()  
        #    for layer in layers:
        #        layer.featureAdded.disconnect()
        #        layer.featureDeleted.disconnect()
        #    for f in j['features']:

        #        if (f['_id'] in ids):
        #            own = True
                   
        #    #if not own:           
        #    self.prj.layerWasAdded.disconnect()
        #    self.prj.layerWillBeRemoved.disconnect()

        #    self.refreshFeatures(layers, res, layerId)

        #    self.prj.layerWasAdded.connect(self.layerAdded)
        #    self.prj.layerWillBeRemoved.connect(self.layerRemoved) 
        #    self.prj.layerWillBeRemoved.connect(self.layerRemoved) 
        #else:
        #    pass
        #   # print("nochanged")
    def getLayerFeatures(self, session, layerId, mapId, layerName):        
        #url = self.URI + "get-layer-features/"+mapId+"/"+layerId+"?session=" + session
        url = self.URI + "/maps/"+mapId+"/layers/"+layerId+"/features?session=" + session
        #print(url)
        r = requests.get(url)    
        print(r.content)
        
        try:
            res = self.fromByteToJson(r.content) 
            print(res)
            success = res['success'] 
        except:
            success = True
        print(success)
        if success == True:
            #try:
            vlayers = self.createMemoryLayerFromJson(r.content,layerName)
            for vlayer in vlayers:
                if not vlayer.isValid():
                    print("Layer failed to load!")
                else:
        
                    self.instance.setLayer(mapId, layerId, vlayer)
                    vlayer.setAutoRefreshInterval(1000)
                    vlayer.setAutoRefreshEnabled(True)            
                    QgsProject.instance().addMapLayer(vlayer)
                    vlayer.featureAdded.connect(self.featAdded) 
                    vlayer.featureDeleted.connect(self.featDel) 
                    ## symbology connection
                    vlayer.styleChanged.connect(self.updateLayerSymbology)
                    print(vlayer.name())     
                
                
        
            
                ##iface.mapCanvas().currentLayer().reload()
                #except:
                #    pass ## not instance of QGSVectorLayer
    def updateLayerSymbology(self):
        layer = iface.activeLayer()
        symbology = self.getStyleJson(layer)
        layer.styleChanged.disconnect()
        wid = self.instance.getLayerByQid(layer.id())
        path = self.tempDir + os.sep +  layer.name() + "_style.json"          
        f = open(path, "w")
        f.write(symbology)
        f.close()  
        url = self.URI + "/maps/" + self.mapId + "/layers/" + wid + "/style?session=" +self.session 
        files = {'file': (path, open(path, 'rb'))} 
        r = requests.post(url, files=files)
        print("######## posting symbology")
        print(r.content)
        res = self.fromByteToJson(r.content)       
       
        if "success" in res:        
            success = res['success']
            if success == "true":
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Whiteboard:", "Symbology was successfully uploaded"), Qgis.Success, duration=5)
            else:
                iface.messageBar().pushWidget(iface.messageBar().createMessage("Whiteboard:", "Symbology was not successfully uploaded"), Qgis.Warning, duration=5)
        
    def setCursorLabeling(self, layer):
        
        layer_settings  = QgsPalLayerSettings()
        text_format = QgsTextFormat()

        text_format.setFont(QFont("Arial", 8))
        text_format.setSize(12)

        buffer_settings = QgsTextBufferSettings()
        buffer_settings.setEnabled(True)
        buffer_settings.setSize(0.10)
        buffer_settings.setColor(QColor("black"))

        text_format.setBuffer(buffer_settings)
        layer_settings.setFormat(text_format)

        layer_settings.fieldName = "user"
        layer_settings.placement = 4

        layer_settings.enabled = True

        layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
        layer.setLabelsEnabled(True)
        layer.setLabeling(layer_settings)
        
    def checkCursorChanges(self):
        if self.cursorCallback != self.sio.getCursorUpdatedCallback():
            self.cursorCallback = self.sio.getCursorUpdatedCallback()
            print(self.cursorCallback)
            ## more users
            
            if len(self.userPositions) == 0:
                self.userPositions.append([self.cursorCallback['un'], self.cursorCallback['xy']])
            inList = False
            for item in self.userPositions:
                if item[0] == self.cursorCallback['un']:
                    item[1] = self.cursorCallback['xy']
                    inList = True
            if not inList:
                self.userPositions.append([self.cursorCallback['un'], self.cursorCallback['xy']])

            
            ##
           # print(self.cursorCallback['xy'])
            #print(self.cursorCallback['un'])
            layer = QgsProject.instance().mapLayersByName("cursor")[0]
            feats = layer.getFeatures()
            pr = layer.dataProvider()
            usr = layer.fields().lookupField('user')
            #atts = {usr: self.cursorCallback['un']}
            try:
                with edit(layer):        
                    for feat in feats:
                        layer.deleteFeature(feat.id())
                    for user in self.userPositions:
                        f = QgsFeature()
                        f.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(user[1][0],user[1][1])))
                        pr.addFeature(f)
                        atts = {usr: user[0]}
                        pr.changeAttributeValues({f.id(): atts})                    
                    layer.updateExtents()
                    self.setCursorLabeling(layer)
                    layer.triggerRepaint()
               # print("cursor changed")
            except:
                for feat in feats:
                    layer.deleteFeature(feat.id())
                for user in self.userPositions:
                    f = QgsFeature()
                    f.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(user[1][0],user[1][1])))
                    pr.addFeature(f)
                    atts = {usr: user[0]}
                    pr.changeAttributeValues({f.id(): atts})   
                #f = QgsFeature()
                #f.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(self.cursorCallback['xy'][0],self.cursorCallback['xy'][1])))
                #pr.addFeature(f)
                #pr.changeAttributeValues({f.id(): atts}) 
                layer.updateExtents()
                self.setCursorLabeling(layer)
                layer.triggerRepaint()
                #print("cursor assertion error")
    def checkLayerAdded(self):      
                               
        if self.layerCallback != self.sio.getAddLayerCallback():
            if self.layerEmited:
                self.layerCallback = self.sio.getAddLayerCallback()
            else:
                print ("layer was added by another user")
                self.layerCallback = self.sio.getAddLayerCallback()
                _id = self.layerCallback['metadata']['id']
                name = self.layerCallback['title']
                type = self.layerCallback['className']
                self.ownLayer = False
                self.layerEmited = False
                #if type == "HSLayers.Layer.WMS":
                #    print("wms added by another user")
                #    self.loadWms(url, name,name, self.layerCallback['projection'])
                #else:
                self.externalLayerAdded(_id, name)
    def loadWms(self, url, layerName,layerNameTitle, epsg):     
        layerName = self.parseWMSlayers(layerName)        
        epsg = QgsProject.instance().crs().authid()
        url = url.replace("%2F", "/").replace("%3A",":")
        urlWithParams = 'contextualWMSLegend=0&crs='+epsg+'&IgnoreReportedLayerExtents=1&dpiMode=7&featureCount=10&format=image/png&layers='+layerName+'&styles=&url=' + url        
  
        quri = QgsDataSourceUri()        
            #    print("dimension exception")
        quri.setParam("layers", layerName)
        quri.setParam("styles", '')
        quri.setParam("format", 'image/png')
        #quri.setParam("crs", 'EPSG:4326')
        quri.setParam("crs", epsg)
        quri.setParam("dpiMode", '7')
        quri.setParam("featureCount", '10')        
        quri.setParam("contextualWMSLegend", '0')
        quri.setParam("url", url)
        print(str(quri.encodedUri()))
        rlayer = QgsRasterLayer(str(quri.encodedUri(), "utf-8"), layerNameTitle, 'wms')
        #print(rlayer.isValid())
        ##quri end
       # rlayer = QgsRasterLayer(urlWithParams, layerNameTitle, 'wms')
        try:
            print("extents")
            print(rlayer.ignoreExtents())
        except:
            print("ignoreExtents works only with qgis 3.10 and higher")
            pass # pro qgis 3.10 a vys
            
        if (rlayer.isValid()): 
            QgsProject.instance().addMapLayer(rlayer)
       
    def checkFeatureAdded(self):      
        pass               
        #if self.addFeatureCallback != self.sio.getAddLayerCallback():
    def checkFeatureDel(self):      
        pass               
        #if self.delFeatureCallback != self.sio.getAddLayerCallback():     
    #def refreshFeatures(self, layers, geoj):    
    #    for layer in layers:
    #        layer.type()
    #    geoj = str(self.fromByteToJson(geoj))
    #    #print(geoj)
    #    geoj = geoj.replace("'", "\"")
    #    # PyQGIS has a parser class for JSON and GeoJSON
    #    feats = QgsJsonUtils.stringToFeatureList(geoj, QgsFields(), None)
    #    # if there are features in the list
    #    if len(feats) > 0:
    #        # define the geometry type of the layer
    #        geom_type = feats[0].geometry().type()
    #        print(geom_type)
    #        if geom_type == QgsWkbTypes.PointGeometry:
    #            geotype = "MultiPoint"
    #        elif geom_type == QgsWkbTypes.LineGeometry:
    #            geotype = "MultiLineString"
    #        elif geom_type == QgsWkbTypes.PolygonGeometry:
    #            geotype = "MultiLinePolygon"
            
    #        else:
    #            print("geometry type not defined in the script")
                    
            
    #        with edit(layer):
    #            for feat in layer.getFeatures():
    #                layer.deleteFeature(feat.id())
    #            layer.addFeatures(feats)
    #            layer.updateExtents()
    #        layer.featureAdded.connect(self.featAdded)
    #        layer.featureDeleted.connect(self.featDel)
            
    #            #print("own feature")
    #            #layer.featureAdded.connect(self.featAdded)
    #            #layer.featureDeleted.connect(self.featDel)
    #    else:
    #        with edit(layer):
    #            for feat in layer.getFeatures():
    #                layer.deleteFeature(feat.id())
    #            layer.updateExtents()
    #        layer.featureAdded.connect(self.featAdded)
    #        layer.featureDeleted.connect(self.featDel)
    def refreshFeatures(self, layers, geoj, layerId):           
        layerName = layers[0].name()
        polygon = False
        linestring = False
        point = False
        print("debug############")
        print(layers)
        for lay in layers:
            if lay.type == 0:
                point = lay
            if lay.type == 1:
                linestring = lay
            if lay.type == 2:
                polygon = lay
        geoj = str(self.fromByteToJson(geoj))
        #print(geoj)
        polyFeats = list()
        pointFeats = list()
        lineFeats = list()
        geoj = geoj.replace("'", "\"")
        # PyQGIS has a parser class for JSON and GeoJSON
        feats = QgsJsonUtils.stringToFeatureList(geoj, QgsFields(), None)
        # if there are features in the list        
        if len(feats) > 0:
            for i in range(0, len(feats)):
                # define the geometry type of the layer
                geom_type = feats[i].geometry().type()
                #print(geom_type)
                if geom_type == QgsWkbTypes.PointGeometry:       
                    pointFeats.append(feats[i])
                    if point: 
                        pass
                        #layer = point
                    else:                        
                        layer = QgsVectorLayer("MultiPoint",layerName, "memory")
                        layers.append(layer)
                        point = layer
                        self.instance.setLayer(self.mapId, layerId, layer)
                        QgsProject.instance().addMapLayer(layer)
                    geotype = "MultiPoint"

                elif geom_type == QgsWkbTypes.LineGeometry:   
                    lineFeats.append(feats[i])
                    if linestring:
                        pass
                        #layer = linestring 
                    else:
                        layer = QgsVectorLayer("LineString",layerName, "memory")
                        layers.append(layer)
                        linestring = layer
                        self.instance.setLayer(self.mapId, layerId, layer)
                        QgsProject.instance().addMapLayer(layer)
                    geotype = "MultiLineString"

                elif geom_type == QgsWkbTypes.PolygonGeometry:  
                    polyFeats.append(feats[i])
                    if polygon:
                        pass
                        #layer = polygon 
                    else:
                        layer = QgsVectorLayer("Polygon",layerName, "memory")
                        polygon = layer
                        layers.append(layer)
                        self.instance.setLayer(self.mapId, layerId, layer)
                        QgsProject.instance().addMapLayer(layer)
                    geotype = "MultiLinePolygon"
            
                else:
                    print("geometry type not defined in the script")
                    
            ## rozdělit na features
            print("debug2############")
            print(pointFeats)
            print(lineFeats)
            print(polyFeats)
            for layer in layers:
                with edit(layer):
                    for feat in layer.getFeatures():
                        layer.deleteFeature(feat.id())
                    if layer.type() == 0:
                        layer.addFeatures(pointFeats)
                    if layer.type() == 1:
                        layer.addFeatures(lineFeats)
                    if layer.type() == 2:
                        layer.addFeatures(polyFeats)
                    layer.updateExtents()
                layer.featureAdded.connect(self.featAdded)
                layer.featureDeleted.connect(self.featDel)
            
                #print("own feature")
                #layer.featureAdded.connect(self.featAdded)
                #layer.featureDeleted.connect(self.featDel)
        else:
            for layer in layers:
                with edit(layer):
                    for feat in layer.getFeatures():
                        layer.deleteFeature(feat.id())
                    layer.updateExtents()
                layer.featureAdded.connect(self.featAdded)
                layer.featureDeleted.connect(self.featDel)
        
    def createMemoryLayerFromJson(self, geoj, layerName):
        layers = list()
        #geoj = """
        #{"type":"FeatureCollection","features":[{"geometry":{"coordinates":[2700129.2556731687,7619409.75065106],"type":"Point"},"_id":"iNTBGO2dc","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"iNTBGO2dc"},"type":"Feature"},{"geometry":{"coordinates":[2734333.4902159194,7629276.35676916],"type":"Point"},"_id":"4AQodxiVw","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"4AQodxiVw"},"type":"Feature"},{"geometry":{"coordinates":[2740911.227627987,7596387.669708823],"type":"Point"},"_id":"2oJi1le6w","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"2oJi1le6w"},"type":"Feature"},{"geometry":{"coordinates":[2759799.421166787,7610228.515482999],"type":"Point"},"_id":"Dv8c-TUmd","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"Dv8c-TUmd"},"type":"Feature"},{"geometry":{"coordinates":[2781521.006449988,7633838.934269087],"type":"Point"},"_id":"PJvvWk1Nk","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"PJvvWk1Nk"},"type":"Feature"},{"geometry":{"coordinates":[2764521.5049240044,7641394.268280636],"type":"Point"},"_id":"0Cfn_5l-o","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"0Cfn_5l-o"},"type":"Feature"},{"geometry":{"coordinates":[2751299.6704037953,7649894.019043627],"type":"Point"},"_id":"ywO3AuyrL","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"ywO3AuyrL"},"type":"Feature"},{"geometry":{"coordinates":[2793856.428744849,7664808.330336467],"type":"Point"},"_id":"0UvEyUlVB","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"0UvEyUlVB"},"type":"Feature"},{"geometry":{"coordinates":[2872127.945708869,7697829.1265556635],"type":"Point"},"_id":"YNwYuRGdc","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"YNwYuRGdc"},"type":"Feature"},{"geometry":{"coordinates":[2947016.428264974,7860167.972115404],"type":"Point"},"_id":"XoQ9KE2je","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"XoQ9KE2je"},"type":"Feature"},{"geometry":{"coordinates":[2884032.3169579892,7865671.438151936],"type":"Point"},"_id":"AlC1VtG9-X","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"AlC1VtG9-X"},"type":"Feature"},{"geometry":{"coordinates":[2800257.333957436,7860167.972115404],"type":"Point"},"_id":"PmMHxGQQa","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"PmMHxGQQa"},"type":"Feature"},{"geometry":{"coordinates":[3095610.011251357,7835096.626837866],"type":"Point"},"_id":"Bhn7QhWwM","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"Bhn7QhWwM"},"type":"Feature"},{"geometry":{"coordinates":[3115177.890492362,7909087.670217916],"type":"Point"},"_id":"IssshpHa8","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"IssshpHa8"},"type":"Feature"},{"geometry":{"coordinates":[2627203.901919797,7851607.0249474645],"type":"Point"},"_id":"jLPj7hY0d","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"jLPj7hY0d"},"type":"Feature"},{"geometry":{"coordinates":[3252764.541405679,7833873.634385304],"type":"Point"},"_id":"VMl9LjVvE","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"VMl9LjVvE"},"type":"Feature"},{"geometry":{"coordinates":[3261936.9847999006,7918871.60983842],"type":"Point"},"_id":"ydJAOeUbL","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"ydJAOeUbL"},"type":"Feature"},{"geometry":{"coordinates":[3178162.0017993473,7874232.3853198765],"type":"Point"},"_id":"sDySh3rvy","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"sDySh3rvy"},"type":"Feature"},{"geometry":{"coordinates":[3184888.4602884427,7917648.617385857],"type":"Point"},"_id":"UYefA3FuD","__v":0,"_layer":"pAB7Toh9raAYbQSmONlXKjXa","_map":"6026a4728f3b3600104b715f","properties":{"id":"UYefA3FuD"},"type":"Feature"}]}
        #"""
        #print(geoj)
        geoj = str(self.fromByteToJson(geoj))
        #print(geoj)
        geoj = geoj.replace("'", "\"")
        # PyQGIS has a parser class for JSON and GeoJSON
        feats = QgsJsonUtils.stringToFeatureList(geoj, QgsFields(), None)       
        if len(feats) > 0:
            # if there are features in the list
            i = 0   
            polyFeats = list()
            pointFeats = list()
            lineFeats = list()
            for feat in feats:
                wid = json.loads(geoj)["features"][i]["_id"]
                wlayerId = json.loads(geoj)["features"][i]["_layer"]
                wmapId = json.loads(geoj)["features"][i]["_map"]            
                self.featIds = self.featIds + 1
                i = i + 1
                feat.setId(self.featIds) 
                print(feat)
                print(feat.geometry().type())
                self.feats.setFeature(feat, self.featIds, wid, wlayerId, wmapId)
                if feat.geometry().type() == QgsWkbTypes.PolygonGeometry:
                    polyFeats.append(feat)
                if feat.geometry().type() == QgsWkbTypes.LineGeometry:
                    lineFeats.append(feat)
                if feat.geometry().type() == QgsWkbTypes.PointGeometry:
                    pointFeats.append(feat)
            #if len(feats) > 0:
            #    # define the geometry type of the layer
            #    geom_type = feats[0].geometry().type()
            #    print(geom_type)
            #    if geom_type == QgsWkbTypes.PointGeometry:
            #        geotype = "MultiPoint"
            #    elif geom_type == QgsWkbTypes.LineGeometry:
            #        geotype = "MultiLineString"
            #    elif geom_type == QgsWkbTypes.PolygonGeometry:
            #        geotype = "MultiLinePolygon"
                
            
            #    else:
            #        print("geometry type not defined in the script")
            #    # create a new memory layer with the features
            #    vl = QgsVectorLayer(geotype, layerName, "memory")
            #    print(vl)
            
            if len(polyFeats) > 0:
                vl = QgsVectorLayer("Polygon", layerName, "memory")
                layers.append(vl)
                with edit(vl):
                    vl.addFeatures(polyFeats)
                    vl.updateExtents()
                QgsProject.instance().addMapLayer(vl)
            if len(lineFeats) > 0:
                vl = QgsVectorLayer("MultiLineString", layerName, "memory")
                layers.append(vl)
                with edit(vl):
                    vl.addFeatures(lineFeats)
                    vl.updateExtents()
                QgsProject.instance().addMapLayer(vl)
            if len(pointFeats) > 0:
                vl = QgsVectorLayer("MultiPoint", layerName, "memory")
                layers.append(vl)
                with edit(vl):
                    vl.addFeatures(pointFeats)
                    vl.updateExtents()
                QgsProject.instance().addMapLayer(vl)
            # add this brand new layer
            
            return layers
        else:
            vl = QgsVectorLayer("MultiPoint", layerName, "memory")
            print("no features found in the geoJSON")
            QgsProject.instance().addMapLayer(vl)
            layers.append(vl)
            return layers
    def showRegisterDialog(self):
        self.old_dlg = self.dlg
        self.run_RegisterUserDialog()        
    def showMapsDialog(self):
        self.old_dlg = self.dlg
        self.run_CreateCompositeDialog()
    def showCreateDialog(self):
        self.old_dlg = self.dlg
        self.run_CreateMapDialog()
    def layerRemoved(self, qid):
        wid = self.instance.getLayerByQid(qid)
        print("layer to remove " + wid)
        url = self.URI + "/maps/" + self.mapId + "/layers/" + wid + "?session=" +self.session
        r = requests.delete(url)
        print(r.content)
        

    def layerAdded(self, layer):       
        if self.ownLayer:
            layerId = self.getLayerJson(layer)        
            print("lay add "+ layer.name())
            self.instance.setLayer(self.mapId, layerId, layer)
            #url = self.URI + "/maps/"+self.mapId+"/layers/"+layerId+"/features?session=" + self.session
            #r = requests.get(url)
            layer.featureAdded.connect(self.featAdded)
            layer.featureDeleted.connect(self.featDel)
            layer.styleChanged.connect(self.updateLayerSymbology)
            #threading.Thread(target=lambda: self.checkLayerChanges(url, layer, r.content)).start()
            self.layerEmited = True
        else:
            print("external")
            #QgsProject.instance().addMapLayer(layer)
            self.ownLayer = True
            self.layerEmited = False
            

       
            
    def externalLayerAdded(self, layerId, layerName):           
       
        self.getLayerFeatures(self.session, layerId, self.mapId, layerName)
   
    def featDel(self, fId):
        if (fId < 0):
            fId = (fId * (-1)) -1  ## neuložená feature je zaporna
        wId = self.feats.getWid(fId)
        wlayerId = self.feats.getWlayerId(fId)
        wmapId = self.feats.getWMapId(fId)
        name = self.iface.activeLayer().name()
        if wlayerId == None:
            return
        json = {
              "mapId": wmapId,
              "layer": { "id": wlayerId, "name": name },
              "type": "delete",
              "featureId": wId
        }
        print(json)
        
        self.sio.delFeature(json)
    def featAdded(self, fId):        
        import json
        import uuid
        layer = self.iface.activeLayer()
        feature = layer.getFeature(fId)        
        prov = layer.dataProvider()       
        fields = [field.name() for field in prov.fields()]        
        geojson = {
            "type": "FeatureCollection",
            "features": [{
                "type": "Feature",
            
                "geometry": i.geometry().asJson()
            } for i in layer.getFeatures()]
        }       
        xx = (json.loads(feature.geometry().asJson()))
        #print(type(xx))
        wid = str(uuid.uuid4())[-9:]
        #try:
        feat ={
	    "mapId": self.mapId,
	    "layer": {
		    "id": self.instance.getLayerByQid(layer.id()),
		    "name": layer.name()
	    },
	    "type": "insert",
	    "feature":{ 
            "geometry": {
            "type": xx["type"],
            "coordinates": xx["coordinates"]
          },
          "_id": wid,
          "__v": 0,
          "_layer": self.instance.getLayerByQid(layer.id()),
          "_map": self.mapId,
          "properties": {
            "id": wid
          },
          "type": "Feature"
        }
        }
        #print(feat)
        self.featIds = self.featIds + 1
        feature.setId(self.featIds) 
        print(feature.id())
        self.feats.setFeature(feature, self.featIds, wid, self.instance.getLayerByQid(layer.id()), self.mapId)
        self.sio.sendFeature(feat)
        #except:
        #    print("exception")
        #    pass ## comes from server, not from user
    def clean(self):
        try:
            self.sio.disconnectSio()
        except:
            print("AttributeError: 'NoneType' object has no attribute 'disconnectSio'" )
        try:
            self.prj.layerWasAdded.disconnect()
        except:
            print("disconnect layer was added unsuccessul")

        try:
            self.prj.layerWillBeRemoved.disconnect()
        except:
            print("disconnect() failed between 'layerWillBeRemoved' and all its connections")
        try:
            self.timerCursor.timeout.disconnect()
        except:
            print("disconnect() timecursor")
        try:    
            self.timer.timeout.disconnect()
        except:
            print("disconnect() timer")
        try:
            self.timerLayer.timeout.disconnect()
        except:
            print("disconnect() timerLayer")
        try:
            self.timerLayerChanged.disconnect()
        except:
            print("disconnect() timerLayerChanged")
        try:
            self.timerMap.timeout.disconnect()
        except:
            print("disconnect() timerMap")
        try:
            self.canvas.xyCoordinates.disconnect()
        except:
            print("disconnect() canvas")
        layers = QgsProject.instance().mapLayers().values()
        for layer in layers:
            if isinstance(layer, QgsVectorLayer):
                try:
                    layer.featureDeleted.disconnect()
                except:
                    print("TypeError: disconnect() failed between 'featureDeleted' and all its connections")
        self.sio = None
        self.featIds = 0
        self.layerCallback = None
        self.delFeatureCallback = None
        self.addFeatureCallback = None
        self.mapChangedCallback = None
        self.username = None
        self.ownMap = False
        self.mapId = None
        self.userPositions = list()
        self.layerEmited = False
        self.cursorCallback = ""
        self.ownLayer = True
        self.first_start = True
        self.dlg.close()
     
        

    def disableEnv(self):
        self.dlg.pushButton_selectMap.setEnabled(False)
        self.dlg.pushButton_maps.setEnabled(False)
        self.dlg.pushButton_clearMap.setEnabled(False)

    def getStyleJson(self, layer):
        layerStyles = layer.renderer().symbol().symbolLayers()[0].properties()
        ## example {'angle': '0', 'color': '232,113,141,255', 'horizontal_anchor_point': '1', 'joinstyle': 'bevel', 'name': 'circle', 'offset': '0,0', 'offset_map_unit_scale': '3x:0,0,0,0,0,0', 'offset_unit': 'MM', 'outline_color': '35,35,35,255', 'outline_style': 'solid', 'outline_width': '0', 'outline_width_map_unit_scale': '3x:0,0,0,0,0,0', 'outline_width_unit': 'MM', 'scale_method': 'diameter', 'size': '2', 'size_map_unit_scale': '3x:0,0,0,0,0,0', 'size_unit': 'MM', 'vertical_anchor_point': '1'}
        ## example server
        #{
        #   "visibility":true,
        #   "opacity":1,
        #   "title":"test layer",
        #   "path":"User generated",
        #   "className":"Vector",
        #   "maxResolution":null,
        #   "minResolution":0,
        #   "projection":"epsg:4326",
        #   "style":{
        #      "fill":"rgba(255,255,255,0.4)",
        #      "stroke":{
        #         "color":"rgba(0, 153, 255, 1)",
        #         "width":1.25
        #      },
        #      "image":{
        #         "fill":"rgba(255,255,255,0.4)",
        #         "stroke":{
        #            "color":"rgba(0, 153, 255, 1)",
        #            "width":1.25
        #         },
        #         "radius":5,
        #         "type":"circle"
        #      }
        #   }
        #}
        
        json = """
        {
           "visibility":true,
           "opacity":1,
           "title":"test layer",
           "path":"User generated",
           "className":"Vector",
           "maxResolution":null,
           "minResolution":0,
           "projection":"epsg:4326",
           "style":{
              "fill":"rgba("""+layerStyles['color']+""")",
              "stroke":{
                 "color":"rgba("""+layerStyles['outline_color']+""")",
                 "width":"""+layerStyles['size']+"""
              }             
           }
        }
        """
        return json
    def enableEnv(self):
        self.dlg.pushButton_selectMap.setEnabled(True)
        self.dlg.pushButton_maps.setEnabled(True)
        self.dlg.pushButton_clearMap.setEnabled(True)
    def parseWMSlayers(self, layerString):
        ### ocekavany string je ve formatu pole napr [vrstva1,vrstva2,...]
        if (layerString[0] == "[" and layerString[-1:] == "]"):    
            s = layerString.replace("[","").replace("]","").split(",")
            res = ""
            for i in range(0, len(s)):
              
                if (i == 0):
                    res = res+ s[i].replace(" ", "") + "&layers="
                elif (i == len(s)-1):
                    res = res+ s[i].replace(" ", "")
                else:
                    res = res+ s[i].replace(" ", "") + "&layers="


            for i in range(0, len(s)-1):
                res = res + "&styles"
            return res.replace("_","")
        else:
            return layerString
    def loadService2(self, data):   
        print("loadService2")
        print(len(data['layers']))
        try:
            test = data['layers']
        except:
            print("corrupted composition")        
        for x in range(len(data['layers'])- 1, -1, -1):       ## descending order           
            
            className = data['layers'][x]['className']  
            print(className)
            if className == 'HSLayers.Layer.WMS':
                layerName = data['layers'][x]['params']['LAYERS']
            #if className == 'OpenLayers.Layer.Vector' or className == 'Vector': 
            #    print(data['layers'][x])
            #    try:
            #        layerName = data['layers'][x]['name']
            #    except:
            #        layerName = data['layers'][x]['protocol']['LAYERS']
            if className == 'HSLayers.Layer.WMS':       
                
                layerName = data['layers'][x]['params']['LAYERS']
                format = data['layers'][x]['params']['FORMAT']           
                epsg = data['layers'][x]['projection']          
                wmsName = data['layers'][x]['params']['LAYERS']  
                layerNameTitle = data['layers'][x]['title']
                repairUrl = data['layers'][x]['url']

                repairUrl = self.convertUrlFromHex(repairUrl)                  
                #self.loadWms(repairUrl, layerName,layerNameTitle, format,epsg, groupName)
                self.loadWms(repairUrl, layerName,layerNameTitle, epsg)
                #if className == 'XYZ':
                #    repairUrl = self.URI+"/geoserver/"+self.laymanUsername+"/ows"
                #    layerName = data['layers'][x]['params']['LAYERS']
                #    format = data['layers'][x]['params']['FORMAT']           
                #    epsg = 'EPSG:4326'             
                #    wmsName = data['layers'][x]['params']['LAYERS']  
                #    layerNameTitle = data['layers'][x]['title']
                #    repairUrl = data['layers'][x]['url']
                #    repairUrl = self.convertUrlFromHex(repairUrl)
                #    self.loadXYZ(data['layers'][x]['url'], layerName,layerNameTitle, format,epsg, groupName, subgroupName)
                
                    
                #if className == 'OpenLayers.Layer.Vector' or className == 'Vector': 
                #    epsg = 'EPSG:4326'         
                
                #    layerNameTitle = data['layers'][x]['title']                    
                #    repairUrl = data['layers'][x]['protocol']['url']
                #    repairUrl = self.convertUrlFromHex(repairUrl)
                #    try: ## nove rozdeleni
                #        if (data['layers'][x]['protocol']['type'] == "hs.format.WFS" or data['layers'][x]['protocol']['type'] == "hs.format.externalWFS"):
                        
                #            self.loadWfs(repairUrl, layerName,layerNameTitle, groupName, subgroupName)
                #    except:
                #        self.loadWfs(repairUrl, layerName,layerNameTitle, groupName, subgroupName)
                    #elif (data['layers'][x]['protocol']['type'] == "hs.format.externalWFS"):
                    #    self.loadWfs(wfsUrl, layerName, layerNameTitle) 
       
    def convertUrlFromHex(self, url):
        url = url.replace('%3A',':')
        url = url.replace('%2F','/')
        url = url.replace('%3F','?')
        url = url.replace('%3D','=')
        url = url.replace('%26','&') 
        return url
    def getLayers(self, session, mapId, username, password):       
        ## set Env
        iface.newProject()
        print(self.dlg.lineEdit_mapIDexternal.text())       
        if len(self.dlg.lineEdit_mapIDexternal.text()) > 22:
            self.mapId = self.parseMapUrl(self.dlg.lineEdit_mapIDexternal.text())
            print("xx")
            print(self.mapId)
            #self.mapId = self.dlg.lineEdit_mapIDexternal.text()
        else:            
            #self.mapId = mapId
            print("yy")
            print(mapId)
            #self.mapId = self.instance.getCompositionId(mapId)
            self.mapId = mapId
        print(self.mapId)
        self.instance.setCurrent(self.mapId)        
        #self.dlg.lineEdit_currentMapId.setText(self.mapId)
        
        url = self.URI + "/maps/"+self.mapId +"?session=" + session
        r = requests.get(url)
        print("map info")
        print(r.content)
        ### get privileges for map
        print(self.URI,self.mapId,session)
        url = self.URI + "/maps/"+self.mapId+"/privileges?session=" + session
        r = requests.get(url)
        print(r.content)
        res = self.fromByteToJson(r.content)
        access = False
        try:
            for prev in res['data']:
                print (username)
                print(prev['user'])
                if username == prev['user']:
                    print ("user have access rights")
                    self.dlg.label_access.setText(prev['right'])
                
                    access = True
        except:
            QMessageBox.information(None, "Whiteboard", "URL is not set!")
            return
        if not access:
            QMessageBox.information(None, "Whiteboard", "You do not have access rights for this map!")
            return
                

        ###
        ##
        url = self.URI + "/maps/"+self.mapId+"/metadata?session=" + session
        r = requests.get(url)
        print(r.content)
        res = self.fromByteToJson(r.content)
        self.mapName = res['data']['title']
        self.dlg.label_map.setText(self.mapName)
        self.dlg.pushButton_url.setEnabled(True)
  
        ### enable sio
        
        if self.sio:
            self.sio.disconnectSio()
        self.sio = Sio_wrapper()
        self.sio.run(session, self.mapId)
        self.layerCallback = self.sio.getAddLayerCallback()
        self.addFeatureCallback = self.sio.getAddFeatureCallback()
        self.cursorCallback = self.sio.getCursorUpdatedCallback()
        ###
       # url = self.URI + "list-editable-layers/"+mapId+"?session=" + session
        url = self.URI + "/maps/"+self.mapId+"/layers?session=" + session
        print(url)
        
        r = requests.get(url)
        #print(r.content)
        res = self.fromByteToJson(r.content)
        print(res)        
        #return
        ##print(layerId)    
        for x in res['data']:
            print(x)     
            try:
                layerId = x['id']
                print(layerId)
            except:
                pass
            try:
                layerName = x['name']
            except:
                pass
            print(layerName)
            
            self.getLayerFeatures(session, layerId,self.mapId, layerName)
        
        #### loading raster layers
        url = self.URI + "/maps/"+self.mapId +"?session=" + session
        r = requests.get(url)    
        data = self.fromByteToJson(r.content)
        self.loadService2(data)

        ###
        #layerId = res[0]['id']
        #self.getLayerFeatures(session, mapId, layerId)
       # self.refreshLayer()

       ### basemap
        print("data")
        print(data)
        #if data['current_base_layer']['title'] == "Open street map":
        self.loadBaseMap()

        ##
       ## cursor
        layer = QgsVectorLayer("Point","cursor", "memory")    
        layer.dataProvider().addAttributes([QgsField("user", QVariant.String)])
        self.setCursorLabeling(layer)
        layer.updateFields()
        QgsProject.instance().addMapLayer(layer)
        qmlPath = self.plugin_dir + os.sep + "symbology" + os.sep + "cursor.qml"
        layer.loadNamedStyle(qmlPath)

       ##
        #self.timer = QTimer()
        #self.timer.setInterval(1000) 
        #self.timer.timeout.connect(self.refresh) 
        #self.timer.start()
        ### check for new layers
        self.prj=QgsProject.instance()
        self.prj.layerWasAdded.connect(self.layerAdded)
        #self.prj.cleared.connect(self.clean)
        self.prj.layerWillBeRemoved.connect(self.layerRemoved) 
        #threading.Thread(target=lambda: self.checkLayerAdded()).start()
        self.timerLayer = QTimer()
        self.timerLayer.setInterval(100)
        self.timerLayer.timeout.connect(self.checkLayerAdded) 
        self.timerLayer.start()
        ###

        self.timerLayerChanged = QTimer()
        self.timerLayerChanged.setInterval(100) 
        self.timerLayerChanged.timeout.connect(self.checkLayerChanges) 
        self.timerLayerChanged.start()


        ## cursor
        self.timerCursor = QTimer()
        self.timerCursor.setInterval(50) 
        self.timerCursor.timeout.connect(self.checkCursorChanges) 
        self.timerCursor.start()


        ## map changed
        self.timerMap = QTimer()
        self.timerMap.setInterval(100) 
        self.timerMap.timeout.connect(self.checkMapChanges) 
        self.timerMap.start()

        ## emit cursor        
        self.canvas = self.iface.mapCanvas()
        self.canvas.xyCoordinates.connect(self.emitCursor)
    def emitCursor(self, point):
        #print(point)
        json = {"xy":[point.x(), point.y()]}            
        self.sio.updateCursor(json)
    def getAllMaps(self, session):
        url = self.URI + "/maps?session=" + session
        r = requests.get(url)
        res = self.fromByteToJson(r.content)
        print("compositions")
        print(res['data'])       
        #for x in res:
        #    layerId = x['id']
        #    layerName = x['name']
    def refreshCombobox(self):
        mapIds = self.getCompositionsList(self.session)          
        self.dlg.comboBox_maps.clear() 
        if mapIds == None:
            pass
        else:
            for i in range (0,len(mapIds)):
                self.instance.setComposition(mapIds[i]['_id'], mapIds[i]['title'], mapIds[i]['description'])               
    def loadMapsToMemory(self):
        mapIds = self.getCompositionsList(self.session)          
        self.dlg.comboBox_maps.clear() 
        if mapIds == None:
            pass
        else:
            for i in range (0,len(mapIds)):
                self.instance.setComposition(mapIds[i]['_id'], mapIds[i]['title'], mapIds[i]['description'])
               
    def auth(self, username, password=""):       


        data = {
          "username": username,
          "provider": "",
          "password": password
        }
        url = self.URI + "/session/authenticate"

        r = requests.post(url,data) 
        
        res = self.fromByteToJson(r.content)
        
        print(r.content)
        ## osetrit spatnou konetivitu zde
        try:
            success = res['success']
        except:
            print("server unavailable")
            QMessageBox.information(None, "Whiteboard", "Server is not available!")
            return
        if success == False:
            QMessageBox.information(None, "Whiteboard", "Login was not successfull!")
            return
        session = res['data']['sessionID']            
        self.session = res['data']['sessionID']            
        self.getAllMaps(session)
        
        self.username = username
        self.instance.setInstanceId(session)
        mapIds = self.getCompositionsList(session)
        self.dlg.label_session.setText(session)
        if mapIds == None:
            pass
        else:
            for i in range (0,len(mapIds)):
                print(mapIds)
                #♣upravit
                #print(mapIds[i]['_id'], mapIds[i]['title'], mapIds[i]['description'])
                #self.instance.setComposition(mapIds[i]['_id'], mapIds[i]['title'], mapIds[i]['description'])
                self.instance.setComposition(mapIds[i]['_id'], mapIds[i]['title'])
                self.dlg.comboBox_maps.addItem(mapIds[i]['title'])
        #self.enableEnv()
        self.dlg.close()
        self.run_CreateCompositeDialog()
        #self.getLayers(session,mapId)

    def run(self):
        """Run method that performs all the real work"""
        
        #self.URI = "http://localhost:3101"
        self.URI = "https://mapwhiteboard.net/map-whiteboard"
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        
        if self.first_start == True:
            self.first_start = False
            self.dlg = WhiteBoardDialog()
            ##self.dlg.lineEdit_session.text()
        else:
            self.dlg.show()
            return
       # self.auth(self.dlg.lineEdit_username.text())
        self.dlg.pushButton_url.setEnabled(False)
        self.dlg.pushButton_maps.clicked.connect(lambda: self.showMapsDialog())
        self.dlg.pushButton_unload.clicked.connect(lambda: self.clean())
        self.dlg.pushButton_register.clicked.connect(lambda: self.showRegisterDialog())
        self.dlg.pushButton_url.clicked.connect(lambda: self.copyToClipboard())

        self.instance = WhiteboardInstance()
        self.feats = WFeature()
        #self.getMap("uMC5nt53nT5mZzS4WjAxK4xFEF6Y40Sp") 
        self.dlg.lineEdit_username.setStyleSheet("""border-radius: 7px; border: 1px solid #0076ff;""")
        self.dlg.lineEdit_password.setStyleSheet("""border-radius: 7px; border: 1px solid #0076ff;""")
        self.dlg.pushButton_start.setStyleSheet("""#pushButton_start {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_start:hover{background: #00b4ff ;}#pushButton_start:disabled{background: #6d7481 ;}""")
        self.dlg.pushButton_register.setStyleSheet("""#pushButton_register {color: #fff !important;text-transform: uppercase; border-radius: 6px; text-decoration: none;  background: #0076ff;   padding: 20px;  border-radius: 5px!important;} #pushButton_register:hover{background: #00b4ff ;}#pushButton_register:disabled{background: #6d7481 ;}""")
        self.dlg.pushButton_start.clicked.connect(lambda: self.auth(self.dlg.lineEdit_username.text(), self.dlg.lineEdit_password.text()))
        # show the dialog
        self.dlg.show()
        self.dlg.pushButton_selectMap.clicked.connect(lambda: self.getLayers(self.session, self.dlg.comboBox_maps.currentText(), self.dlg.lineEdit_username.text(), self.dlg.lineEdit_password.text()))
        self.disableEnv()
        #sio = SocketioClass()
        #sio.run()
        

        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass


class Sio_wrapper():
    sio = socketio.Client()

    def __init__(self):
        self.addLayerCallback = None
        self.addFeatureCallback = None
        self.delFeatureCallback = None
        self.cursorUpdatedCallback = None
        self.mapChangedCallback = None
    def setup(self, sessionId, mapId):
        #self.addLayerCallback = None
        self.call_backs(sessionId, mapId)
        
        #self.username = username
        #self.password = password
        #self.sio.connect('https://dih.bosc.lv',socketio_path='whiteboard-demo/map-whiteboard/socket.io')
        self.sio.connect('https://mapwhiteboard.net',socketio_path='map-whiteboard/socket.io')
        #self.sio.connect('http://localhost:3101')
        #self.sio.emit("authentication", {"sessionID": sessionId,"provider": ""})
        #self.sio.emit("get-connection-info", mapId)
        #self.sessionId = sessionId
        #self.mapId = mapId
    def disconnectSio(self):
        self.sio.disconnect()

    def loop(self): 
        self.sio.wait()
    def getCursorUpdatedCallback(self):
        return self.cursorUpdatedCallback
    def getAddLayerCallback(self):
        return self.addLayerCallback
    def getAddFeatureCallback(self):
        return self.addFeatureCallback
    def getDelFeatureCallback(self):
        return self.delFeatureCallback

    def getMapChangedCallback(self):
        return self.mapChangedCallback
    def sendFeature(self, json): 
        self.sio.emit("upsert-feature", json)
        print("upsert-feature")
        print(json)
    def delFeature(self, json): 
        self.sio.emit("delete-feature", json)
        print("delete-feature")
    def updateCursor(self, json):       
        self.sio.emit("update-cursor", json)
   
    def call_backs(self, sessionId, mapId):
        @self.sio.event
        def connect():            
            #self.sio.emit("authentication", {"username": self.username,"provider": "", "password": self.password})
            self.sio.emit("authentication", {"sessionID": sessionId,"provider": ""})
            self.sio.emit("get-connection-info", mapId)
            print('socket connection established')
            
        @self.sio.on("authenticated")
        def raw_data(data):
            print(f"Data Received {data}")

        @self.sio.on("upsert-feature")
        def raw_data(data):
            self.addFeatureCallback = data
            print(f"Data Received {data}")

        @self.sio.on("delete-feature")
        def raw_data(data):
            self.delFeatureCallback = data
            print(f"Data Received {data}")


        @self.sio.on("map-definition-change")
        def raw_data(data):
            self.mapChangedCallback = data
            print(f"Data Received {data}")
            print(f"Data Received {data}")
        @self.sio.on("add-layer")
        def raw_data(data):
            self.addLayerCallback = data
            print(f"Data Received {data}")        
        @self.sio.on("delete-layer")
        def raw_data(data):            
            print(f"Data Received {data}")
            print("delete layer")
        @self.sio.on("update-cursor")
        def raw_data(data):
            self.cursorUpdatedCallback = data
            #print(f"Data Received {data}")

        @self.sio.on("remove-cursor")
        def raw_data(data):
            print(f"Data Received {data}")

        @self.sio.event
        def auth(data):
            print(f"Data Received {data}")


        @self.sio.event
        def disconnect():
            print('disconnected from server')

    def run(self,sessionId, mapId):        
        self.setup(sessionId,  mapId)
        print("setup")
       