"""
/***************************************************************************
 WfsClientDialog
                                 A QGIS plugin
 WFS 2.0 Client
                             -------------------
        begin                : 2012-05-17
        copyright            : (C) 2012 by Juergen Weichand
        email                : juergen@weichand.de
        website              : http://www.weichand.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4 import QtCore, QtGui
from PyQt4.QtNetwork import QHttp
from ui_wfsclient import Ui_WfsClient
from qgis.core import *
from xml.etree import ElementTree 
import urllib2 
import string
import random
import tempfile
import os
import os.path
import wfs20lib

class WfsClientDialog(QtGui.QDialog):

    def __init__(self, parent):
        QtGui.QDialog.__init__(self)
        # Set up the user interface from Designer.
        self.parent = parent
        self.ui = Ui_WfsClient()
        self.ui.setupUi(self)

        self.ui.frmExtent.show()
        self.ui.frmParameter.hide()
        self.ui.progressBar.setVisible(False)
        self.ui.txtUrl.setText(self.get_url())

        self.parameter_lineedits = []
        self.parameter_labels = []

        self.settings = QtCore.QSettings()
        self.init_variables()

        self.ui.lblMessage.setText("CRS is set to EPSG: {0}".format(str(self.parent.iface.mapCanvas().mapRenderer().destinationSrs().epsg())))

        QtCore.QObject.connect(self.ui.cmdGetCapabilities, QtCore.SIGNAL("clicked()"), self.getCapabilities)
        QtCore.QObject.connect(self.ui.cmdListStoredQueries, QtCore.SIGNAL("clicked()"), self.listStoredQueries)
        QtCore.QObject.connect(self.ui.cmdGetFeature, QtCore.SIGNAL("clicked()"), self.getFeature)
        QtCore.QObject.connect(self.ui.cmdSaveUrl, QtCore.SIGNAL("clicked()"), self.save_url)
        QtCore.QObject.connect(self.ui.chkExtent, QtCore.SIGNAL("clicked()"), self.update_extent_frame)
        QtCore.QObject.connect(self.ui.cmbFeatureType, QtCore.SIGNAL("currentIndexChanged(int)"), self.update_ui)

    def init_variables(self):
        self.columnid = 0
        self.bbox = ""
        self.querytype = ""
        self.onlineresource = ""
        self.featuretypes = {}
        self.storedqueries = {}

    # Process GetCapabilities-Request
    def getCapabilities(self):
        self.init_variables()
        self.ui.cmdGetFeature.setEnabled(False);
        self.ui.cmbFeatureType.clear()
        self.ui.frmExtent.show()
        self.ui.frmParameter.hide()
        self.ui.chkExtent.setChecked(False)
        self.ui.txtExtentWest.setText("")
        self.ui.txtExtentEast.setText("")
        self.ui.txtExtentNorth.setText("")
        self.ui.txtExtentSouth.setText("")
        self.ui.lblCount.setVisible(True)
        self.ui.txtCount.setText("50")
        self.ui.txtCount.setVisible(True)
        self.ui.txtFeatureTypeTitle.setVisible(False)
        self.ui.txtFeatureTypeDescription.setVisible(False)
        self.ui.lblInfo.setText("FeatureTypes")
        self.ui.lblMessage.setText("")
        try:
            self.onlineresource = self.ui.txtUrl.text().trimmed()
            request = "{0}{1}".format(self.onlineresource, self.fix_acceptversions(self.onlineresource))
            # request = "http://geoserv.weichand.de:8080/geoserver/wfs?service=WFS&version=2.0.0&request=getcapabilities"
            self.setup_urllib2()
            response = urllib2.urlopen(request)
            buf = response.read()
        except urllib2.HTTPError, e:  
            self.ui.lblMessage.setText("HTTP Error: {0}".format(e.code))   
        except urllib2.URLError, e:
            self.ui.lblMessage.setText("URL Error: {0}".format(e.reason))
        else:
            # process Response
            root = ElementTree.fromstring(buf)
            # WFS 2.0 Namespace
            namespace = "{http://www.opengis.net/wfs/2.0}"
            # check correct Rootelement 
            if root.tag == "{0}WFS_Capabilities".format(namespace):       
                for target in root.findall("{0}FeatureTypeList/{0}FeatureType".format(namespace)):
                    for name in target.findall("{0}Name".format(namespace)):
                        self.ui.cmbFeatureType.addItem(name.text,name.text)
                        featuretype = wfs20lib.FeatureType(name)
                        for title in target.findall("{0}Title".format(namespace)):
                            featuretype.setTitle(title.text)
                        for abstract in target.findall("{0}Abstract".format(namespace)):
                            featuretype.setAbstract(abstract.text)
                        self.featuretypes[QtCore.QString(name.text)] = featuretype   
                        self.querytype="adhocquery"
            else:
                self.ui.lblMessage.setText("Not a valid GetCapabilities-Response")        
            self.update_ui()

   
    #Process ListStoredQueries-Request
    def listStoredQueries(self):
        self.init_variables()
        self.ui.cmdGetFeature.setEnabled(False);
        self.ui.cmbFeatureType.clear()
        self.ui.frmExtent.hide()
        self.ui.frmParameter.show()
        self.layout_reset()
        self.ui.lblCount.setVisible(False)
        self.ui.txtCount.setText("")
        self.ui.txtCount.setVisible(False)
        self.ui.txtFeatureTypeTitle.setVisible(False)
        self.ui.txtFeatureTypeDescription.setVisible(False)
        self.ui.lblInfo.setText("StoredQueries")
        self.ui.lblMessage.setText("")
        try:
            self.onlineresource = self.ui.txtUrl.text().trimmed()
            request = "{0}?service=WFS&version=2.0.0&request=DescribeStoredQueries".format(self.onlineresource)
            self.setup_urllib2()
            response = urllib2.urlopen(request)
            buf = response.read()
        except urllib2.HTTPError, e:  
            self.ui.lblMessage.setText("HTTP Error: {0}".format(e.code))        
        except urllib2.URLError, e:
            self.ui.lblMessage.setText("URL Error: {0}".format(e.reason))
        else:
            # process Response
            root = ElementTree.fromstring(buf)
            # WFS 2.0 Namespace
            namespace = "{http://www.opengis.net/wfs/2.0}"
            # check correct Rootelement
            if root.tag == "{0}DescribeStoredQueriesResponse".format(namespace):  
                for target in root.findall("{0}StoredQueryDescription".format(namespace)):
                    self.ui.cmbFeatureType.addItem(target.get("id"),target.get("id"))
                    lparameter = []
                    for parameter in target.findall("{0}Parameter".format(namespace)):
                        lparameter.append(wfs20lib.StoredQueryParameter(parameter.get("name"), parameter.get("type")))                     
                    storedquery = wfs20lib.StoredQuery(QtCore.QString(target.get("id")), lparameter)
                    for title in target.findall("{0}Title".format(namespace)):
                        storedquery.setTitle(title.text)
                    for abstract in target.findall("{0}Abstract".format(namespace)):
                        storedquery.setAbstract(abstract.text)
                    self.storedqueries[QtCore.QString(target.get("id"))] = storedquery
                    self.querytype="storedquery" #R
            else:
                self.ui.lblMessage.setText("Not a valid DescribeStoredQueries-Response")  
            self.update_ui()


    # Process GetFeature-Request
    def getFeature(self):
        self.ui.lblMessage.setText("Please wait while downloading!")
        if self.querytype == "storedquery":
            request = "?service=WFS&request=GetFeature&version=2.0.0&STOREDQUERY_ID={0}".format(self.ui.cmbFeatureType.currentText())
            storedquery = self.storedqueries[self.ui.cmbFeatureType.currentText()]
            lparameter = storedquery.getStoredQueryParameterList()
            for i in range(len(lparameter)):
                if not lparameter[i].isValidValue(self.parameter_lineedits[i].text()):
                    self.ui.lblMessage.setText(lparameter[i].getName() + ": Value validation failed!")
                    return
                request+= "&{0}={1}".format(lparameter[i].getName(),self.parameter_lineedits[i].text())
        else :
            if len(self.bbox)<1:
                request = "?service=WFS&request=GetFeature&version=2.0.0&srsName=EPSG:{0}&typeName={1}".format(self.parent.iface.mapCanvas().mapRenderer().destinationSrs().epsg(), self.ui.cmbFeatureType.currentText())
            else: 
                request = "?service=WFS&request=GetFeature&version=2.0.0&srsName=EPSG:{0}&typeName={1}&bbox={2}".format(self.parent.iface.mapCanvas().mapRenderer().destinationSrs().epsg(), self.ui.cmbFeatureType.currentText(), self.bbox)
            if len(self.ui.txtCount.text()) > 0:
                request+= "&count={0}".format(self.ui.txtCount.text())
        
        # self.ui.txtDebug.setPlainText(request)
        # response = urllib2.urlopen(request)
        # buf = response.read()

        self.httpGetId = 0
        self.httpRequestAborted = False
        
        self.setup_qhttp()
        self.http.requestFinished.connect(self.httpRequestFinished)
        self.http.dataReadProgress.connect(self.updateDataReadProgress)
        self.http.responseHeaderReceived.connect(self.readResponseHeader)
        
        layername="wfs{0}".format(''.join(random.choice(string.ascii_uppercase + string.digits) for x in range(6)))
        self.downloadFile(self.onlineresource, request, self.get_temppath("{0}.gml".format(layername)))


    """
    ############################################################################################################################
    # UI
    ############################################################################################################################
    """

    # UI: Update Parameter-Frame
    def update_ui(self):       
        if self.querytype == "adhocquery":
            featuretype = self.featuretypes[self.ui.cmbFeatureType.currentText()]

            if featuretype.getTitle():
                if len(featuretype.getTitle()) > 0:
                    self.ui.txtFeatureTypeTitle.setVisible(True)
                    self.ui.txtFeatureTypeTitle.setPlainText(featuretype.getTitle())
                else:
                    self.ui.txtFeatureTypeTitle.setVisible(False)
            else: 
                self.ui.txtFeatureTypeTitle.setVisible(False)

            if featuretype.getAbstract():
                if len(featuretype.getAbstract()) > 0:
                    self.ui.txtFeatureTypeDescription.setVisible(True)
                    self.ui.txtFeatureTypeDescription.setPlainText(featuretype.getAbstract())
                else:
                    self.ui.txtFeatureTypeDescription.setVisible(False)
            else: 
                self.ui.txtFeatureTypeDescription.setVisible(False)

            self.ui.cmdGetFeature.setEnabled(True);
            self.ui.lblMessage.setText("")

        if self.querytype == "storedquery":
            storedquery = self.storedqueries[self.ui.cmbFeatureType.currentText()]

            if storedquery.getTitle():
                if len(storedquery.getTitle()) > 0:
                    self.ui.txtFeatureTypeTitle.setVisible(True)
                    self.ui.txtFeatureTypeTitle.setPlainText(storedquery.getTitle())
                else:
                    self.ui.txtFeatureTypeTitle.setVisible(False)
            else: 
                self.ui.txtFeatureTypeTitle.setVisible(False)
            if storedquery.getAbstract():
                if len(storedquery.getAbstract()) > 0:
                    self.ui.txtFeatureTypeDescription.setVisible(True)
                    self.ui.txtFeatureTypeDescription.setPlainText(storedquery.getAbstract())
                else:
                    self.ui.txtFeatureTypeDescription.setVisible(False)
            else: 
                self.ui.txtFeatureTypeDescription.setVisible(False)

            self.ui.cmdGetFeature.setEnabled(True);
            self.ui.lblMessage.setText("")
            self.layout_reset()
            for parameter in storedquery.getStoredQueryParameterList(): 
                self.layout_add_parameter(parameter)

    # UI: Update Extent-Frame
    def update_extent_frame(self):
        if self.ui.chkExtent.isChecked():
            canvas=self.parent.iface.mapCanvas()
            ext=canvas.extent()
            self.ui.txtExtentWest.setText(QtCore.QString('%s'%ext.xMinimum()))                                                                                                                                                                                                                                                                                                                                                                                                  
            self.ui.txtExtentEast.setText(QtCore.QString('%s'%ext.xMaximum()))                                                                                                                                                                                                                                                                                                                                                                                                  
            self.ui.txtExtentNorth.setText(QtCore.QString('%s'%ext.yMaximum()))                                                                                                                                                                                                                                                                                                                                                                                                  
            self.ui.txtExtentSouth.setText(QtCore.QString('%s'%ext.yMinimum()))
            self.bbox=QtCore.QString('%s'%ext.xMinimum()) + "," + QtCore.QString('%s'%ext.yMinimum()) + "," + QtCore.QString('%s'%ext.xMaximum()) + "," + QtCore.QString('%s'%ext.yMaximum()) + ",EPSG:{0}".format(self.parent.iface.mapCanvas().mapRenderer().destinationSrs().epsg())
        else: 
            self.ui.txtExtentWest.setText("")
            self.ui.txtExtentEast.setText("")
            self.ui.txtExtentNorth.setText("")
            self.ui.txtExtentSouth.setText("")
            self.bbox=""

  
    # GridLayout reset (StoredQueries)
    def layout_reset(self):
        for qlabel in self.parameter_labels:
            self.ui.gridLayout.removeWidget(qlabel)
            qlabel.setParent(None) # http://www.riverbankcomputing.com/pipermail/pyqt/2008-March/018803.html

        for qlineedit in self.parameter_lineedits:
            self.ui.gridLayout.removeWidget(qlineedit)
            qlineedit.setParent(None) # http://www.riverbankcomputing.com/pipermail/pyqt/2008-March/018803.html
        
        del self.parameter_labels[:]
        del self.parameter_lineedits[:]
        self.columnid = 0

    # GridLayout addParameter (StoredQueries)
    def layout_add_parameter(self, storedqueryparameter):
        qlineedit = QtGui.QLineEdit()
        qlabelname = QtGui.QLabel()
        qlabelname.setText(storedqueryparameter.getName())
        qlabeltype = QtGui.QLabel()
        qlabeltype.setText(storedqueryparameter.getType().replace("xsd:", ""))
        self.ui.gridLayout.addWidget(qlabelname, self.columnid, 0)
        self.ui.gridLayout.addWidget(qlineedit, self.columnid, 1)
        self.ui.gridLayout.addWidget(qlabeltype, self.columnid, 2)
        self.columnid = self.columnid + 1
        self.parameter_labels.append(qlabelname)
        self.parameter_labels.append(qlabeltype)
        self.parameter_lineedits.append(qlineedit)
        # newHeight = self.geometry().height() + 21
        # self.resize(self.geometry().width(), newHeight)
  
 
    def lock_ui(self):
        self.ui.cmdGetCapabilities.setEnabled(False)
        self.ui.cmdListStoredQueries.setEnabled(False)
        self.ui.cmdGetFeature.setEnabled(False)
        self.ui.cmdSaveUrl.setEnabled(False)
        self.ui.cmbFeatureType.setEnabled(False)

    def unlock_ui(self):
        self.ui.cmdGetCapabilities.setEnabled(True)
        self.ui.cmdListStoredQueries.setEnabled(True)
        self.ui.cmdGetFeature.setEnabled(True)
        self.ui.cmdSaveUrl.setEnabled(True)
        self.ui.cmbFeatureType.setEnabled(True)


    """
    ############################################################################################################################
    # UTIL
    ############################################################################################################################
    """
    def save_url(self):
        self.save_tempfile("defaultwfs.txt", str(self.ui.txtUrl.text().trimmed()))
        QtGui.QMessageBox.information(self.parent.iface.mainWindow(),"Info", "Successfully saved OnlineResource!" )

    def get_url(self):
        try:
            tmpdir = os.path.join(tempfile.gettempdir(),'wfs20client')
            tmpfile= os.path.join(tmpdir, "defaultwfs.txt")
            fobj=open(tmpfile,'r')
            url = fobj.readline()
            fobj.close()
            return url
        except IOError, e:
            return "http://geoserv.weichand.de:8080/geoserver/wfs"

    def get_temppath(self, filename):
        tmpdir = os.path.join(tempfile.gettempdir(),'wfs20client')
        if not os.path.exists(tmpdir):
            os.makedirs(tmpdir)
        tmpfile= os.path.join(tmpdir, filename)
        return tmpfile

    def save_tempfile(self, filename, content):
        tmpdir = os.path.join(tempfile.gettempdir(),'wfs20client')
        if not os.path.exists(tmpdir):
            os.makedirs(tmpdir)
        tmpfile= os.path.join(tmpdir, filename)
        fobj=open(tmpfile,'wb')
        fobj.write(content)
        fobj.close()  
        return tmpfile

    # Receive Proxy from QGIS-Settings
    def getProxy(self):
        if self.settings.value("/proxy/proxyEnabled").toString() == "true":
           proxy = "{0}:{1}".format(self.settings.value("/proxy/proxyHost").toString(), self.settings.value("/proxy/proxyPort").toString())
           if proxy.startswith("http://"):
               return proxy
           else:
               return proxy
        else: 
            return ""
    
    # Setup urllib2 (Proxy)
    def setup_urllib2(self):
        if not self.getProxy() == "":
            proxy_support = urllib2.ProxyHandler({"http" : self.getProxy()})
            opener = urllib2.build_opener(proxy_support)
            urllib2.install_opener(opener)
        else: 
            proxy_support = urllib2.ProxyHandler({})
            opener = urllib2.build_opener(proxy_support)
            urllib2.install_opener(opener)

    # Setup Qhttp (Proxy)
    def setup_qhttp(self):
        self.http = QHttp(self)
        if not self.getProxy() == "":
            self.http.setProxy(QgsNetworkAccessManager.instance().fallbackProxy()) # Proxy       
        

    # WFS 2.0 UTILS
    # Check for empty GetFeature result
    def is_empty_response(self, filename):
        # Parse and check only small files
        if os.path.getsize(filename) < 2000:
            root = ElementTree.parse(filename).getroot()
            if root.get("numberReturned") == "unknown":
                return True
            if root.get("numberReturned") == "0":
                return True
            return False

    # Hack to fix version/acceptversions Request-Parameter
    def fix_acceptversions(self, onlineresource):
        if onlineresource.contains("geoserver"):
           return "?service=WFS&version=2.0.0&request=GetCapabilities"
        else:
           return "?service=wfs&acceptversions=2.0.0&request=GetCapabilities"




    #############################################################################################################
    # QHttp GetFeature-Request - http://stackoverflow.com/questions/6852038/threading-in-pyqt4
    #############################################################################################################

    def downloadFile(self, onlineResource, queryString, fileName):
        self.lock_ui()
        url = QtCore.QUrl(onlineResource)

        if QtCore.QFile.exists(fileName):
            QtCore.QFile.remove(fileName)

        self.outFile = QtCore.QFile(fileName)
        if not self.outFile.open(QtCore .QIODevice.WriteOnly):
            QtGui.QMessageBox.information(self, 'Error',
                    'Unable to save the file %s: %s.' % (fileName, self.outFile.errorString()))
            self.outFile = None
            return

        mode = QHttp.ConnectionModeHttp
        port = url.port()
        if port == -1:
            port = 0
        self.http.setHost(url.host(), mode, port)
        self.httpRequestAborted = False
        # Download the file.
        self.ui.progressBar.setVisible(True)
        self.httpGetId = self.http.get(url.path() + queryString, self.outFile)

    # Currently unused
    def cancelDownload(self):
        self.httpRequestAborted = True
        self.http.abort()
        self.close()

        self.ui.progressBar.setMaximum(1)
        self.ui.progressBar.setValue(0)
        self.unlock_ui()

    def httpRequestFinished(self, requestId, error):
        if requestId != self.httpGetId:
            return

        if self.httpRequestAborted:
            if self.outFile is not None:
                self.outFile.close()
                self.outFile.remove()
                self.outFile = None
            return

        self.outFile.close()

        self.ui.progressBar.setMaximum(1)
        self.ui.progressBar.setValue(1)

        if error:
            self.outFile.remove()
            self.ui.lblMessage.setText('Download failed: %s.' % self.http.errorString())
        else:      
             if not self.is_empty_response(str(self.outFile.fileName())):
                 vlayer = QgsVectorLayer(str(self.outFile.fileName()), self.ui.cmbFeatureType.currentText(), "ogr")            
                 if not vlayer.isValid():
                     self.ui.lblMessage.setText("Response is not a valid QGIS-Layer!")
                 else: 
                     self.ui.lblMessage.setText("")
                     QgsMapLayerRegistry.instance().addMapLayer(vlayer)
                     self.parent.iface.zoomToActiveLayer()
             else:
                 self.ui.lblMessage.setText("0 Features returned!")

        self.ui.progressBar.setMaximum(1)
        self.ui.progressBar.setValue(0)
        self.unlock_ui()

    def readResponseHeader(self, responseHeader):
        # Check for genuine error conditions.
        if responseHeader.statusCode() not in (200, 300, 301, 302, 303, 307):
            QMessageBox.information(self, 'Error',
                    'Download failed: %s.' % responseHeader.reasonPhrase())
            self.httpRequestAborted = True
            self.http.abort()

    def updateDataReadProgress(self, bytesRead, totalBytes):
        if self.httpRequestAborted:
            return
        self.ui.progressBar.setMaximum(totalBytes)
        self.ui.progressBar.setValue(bytesRead)
        self.ui.lblMessage.setText("Please wait while downloading - {0} Bytes downloaded!".format(str(bytesRead)))
