# -*- coding: utf-8 -*-
"""
/***************************************************************************
 WfsClientDialog
                                 A QGIS plugin
 WFS 2.0 Client
                             -------------------
        begin                : 2012-05-17
        copyright            : (C) 2012 by Juergen Weichand
        email                : juergen@weichand.de
        website              : http://www.weichand.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.PyQt import QtCore, QtGui, QtWidgets, uic
from qgis.core import QgsSettings

UI_WFS_PATH = os.path.join(os.path.dirname(__file__), "ui_wfsclientconfig.ui")


class _UiProxy:
    """Redirects self.ui.<name> to widgets on self so that existing code remains unchanged."""
    def __init__(self, owner):
        self._o = owner
    def __getattr__(self, name):
        return getattr(self._o, name)


def _to_bool(val):
    if isinstance(val, bool):
        return val
    if isinstance(val, str):
        return val.strip().lower() == "true"
    return False


class WfsClientConfigDialog(QtWidgets.QDialog):
    def __init__(self, parent: QtWidgets.QWidget | None = None, plugin=None):
        super().__init__(parent)
        self.plugin = plugin

        uic.loadUi(UI_WFS_PATH, self)
        self.ui = _UiProxy(self)

        self.settings = QgsSettings()

        int_validator = QtGui.QIntValidator(1, 1_000_000, self)
        self.ui.txtFeatureLimit.setValidator(int_validator)

        resolvexlinkhref = self.settings.value("/Wfs20Client/resolveXpathHref")
        attributestofields = self.settings.value("/Wfs20Client/attributesToFields")
        disablenasdetection = self.settings.value("/Wfs20Client/disableNasDetection")
        resolvedepth = self.settings.value("/Wfs20Client/resolveDepth")
        defaultwfs = self.settings.value("/Wfs20Client/defaultWfs")
        defaultfeaturelimit = self.settings.value("/Wfs20Client/defaultFeatureLimit")

        if resolvedepth is None:
            resolvedepth = ""
        idx = self.ui.cmbResolveDepth.findText(str(resolvedepth))
        self.ui.cmbResolveDepth.setCurrentIndex(idx if idx >= 0 else 0)

        self.ui.chkResolveXlinkHref.setChecked(_to_bool(resolvexlinkhref))
        self.ui.chkAttributesToFields.setChecked(_to_bool(attributestofields))
        self.ui.chkDisableNasDetection.setChecked(_to_bool(disablenasdetection))

        if defaultwfs:
            self.ui.txtUrl.setText(str(defaultwfs))
        if defaultfeaturelimit:
            self.ui.txtFeatureLimit.setText(str(defaultfeaturelimit))

        # Signals
        self.ui.cmdSaveConfig.clicked.connect(self.save_config)
        # self.ui.buttonBox.accepted.connect(self.save_config)
        # self.ui.buttonBox.rejected.connect(self.reject)

        # self.setWindowModality(QtCore.Qt.WindowModality.NonModal)
        # self.setWindowTitle("WFS 2.0 Client – Einstellungen")

    def save_config(self):
        # Save Settings
        self.settings.setValue("/Wfs20Client/resolveXpathHref", self.ui.chkResolveXlinkHref.isChecked())
        self.settings.setValue("/Wfs20Client/attributesToFields", self.ui.chkAttributesToFields.isChecked())
        self.settings.setValue("/Wfs20Client/disableNasDetection", self.ui.chkDisableNasDetection.isChecked())
        self.settings.setValue("/Wfs20Client/resolveDepth", self.ui.cmbResolveDepth.currentText().strip())
        self.settings.setValue("/Wfs20Client/defaultWfs", self.ui.txtUrl.text().strip())
        self.settings.setValue("/Wfs20Client/defaultFeatureLimit", self.ui.txtFeatureLimit.text().strip())

        QtWidgets.QMessageBox.information(self, "Information", "Configuration saved!")
        self.accept()  # sauber schließen (statt close), falls via exec() geöffnet
