# -*- coding: utf-8 -*-
"""
/***************************************************************************
 World from Space
                                 A QGIS plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-08-04
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Test
        email                : test
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os, json
from qgis.PyQt import QtWidgets,QtCore, QtGui, uic
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtWidgets import *
from qgis.core import *
from qgis.gui import *
from PyQt5.QtCore import QDateTime
import csv, io

try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    _fromUtf8 = lambda s: s

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'settings_base.ui'))

class Ui_Settings(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, pluginPath, parent=None):
        """Constructor."""
        super(Ui_Settings, self).__init__(parent)
        self.parent = parent
        self.setupUi(self)
        self.pushButtonBrowse.clicked.connect(self.browseDir)
        self.pluginPath = pluginPath
        self.settingsPath = pluginPath + "/../../../qgis_world_from_space_settings"
        self.settings = {}

    def accept(self):
        """
        Save settings into the file and close the dialog.
        :return:
        """
        self.writeSettings()
        self.close()

    def browseDir(self):
        """
        Opens Directory browse dialog.
        Sets the selected path to the self.lineEditLayersDirectory
        :return: None
        """
        path = self.pluginPath
        if self.lineEditLayersDirectory.text() != "" and os.path.exists(self.lineEditLayersDirectory.text()):
            path = self.lineEditLayersDirectory.text()
        destDir = QFileDialog.getExistingDirectory(None,
                                                   'Open working directory',
                                                   path,
                                                   QFileDialog.ShowDirsOnly)
        if destDir is not None:
            self.lineEditLayersDirectory.setText(destDir)

    def updateSettings(self):
        """
        Loads settings from file and populates the dialog items.
        :return:
        """
        if os.path.exists(self.settingsPath + "/settings.json"):
            with open(self.settingsPath + "/settings.json") as json_file:
                self.settings = json.load(json_file)
                self.lineEditAPIKey.setText(self.settings['apikey'])
                self.lineEditLayersDirectory.setText(self.settings['layers_directory'])
                if "log_level" in self.settings:
                    if self.settings["log_level"] == 'ALL':
                        self.comboBoxLogLevel.setCurrentIndex(1)
        else:
            self.lineEditLayersDirectory.setText(self.pluginPath + "/data")

    def showRestartInfo(self):
        QMessageBox.information(None, QApplication.translate("World from Space", "INFO", None),
                                QApplication.translate("World from Space", "You have to restart QGIS", None))

    def writeSettings(self):
        """
        Saves values from dialog into the file.
        :return:
        """
        if "log_level" not in self.settings or ("log_level" in self.settings and self.settings['log_level'] != self.comboBoxLogLevel.currentText()):
            self.showRestartInfo()
        self.settings['apikey'] = self.lineEditAPIKey.text()
        self.settings['layers_directory'] = self.lineEditLayersDirectory.text()
        self.settings['log_level'] = self.comboBoxLogLevel.currentText()
        with open(self.settingsPath + "/settings.json", 'w') as outfile:
            json.dump(self.settings, outfile)
        self.parent.loadSettings()
