# -*- coding: utf-8 -*-

"""
/***************************************************************************
 WetlandVulnerabilityAnalysisTools
                                 A QGIS plugin
 Analyze the vulnerability of wetlands
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-07-20
        copyright            : (C) 2020 by ESIPPS
        email                : katxeus@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'ESIPPS'
__date__ = '2020-07-20'
__copyright__ = '(C) 2020 by ESIPPS'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingMultiStepFeedback,
                       QgsProcessingParameterDefinition,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterNumber,
                       QgsProcessingUtils,
                       QgsProcessingParameterRasterDestination,
                       QgsExpression,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink)
from qgis import processing
from qgis.utils import iface
import os
import gdal

class WetlandVulnerabilityAnalysisToolAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'
    degradationweight = 'degradationweight'
    ecosystemweight = 'ecosystemweight'
    landcoverweight = 'landcoverweight'
    populationweight = 'populationweight'
    ndbiweight = 'ndbiweight'
    mndwiweight = 'mndwiweight'
    ndviweight = 'ndviweight'
    inundationweight = 'inundationweight'
    exposuredomainweight = 'exposuredomainweight'
    resiliencedomainweight = 'resiliencedomainweight'
    sensitivitydomainweight = 'sensitivitydomainweight'
    WetlandVulnerabilityTemp = 'WetlandVulnerabilityTemp'
    

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def shortHelpString(self):
        return self.tr("<hr>"
                "<h2>Exposure (Drivers,Threats and pressures)</h2>"
                "Measures the threats to a wetland arising from pressures and drivers. The weights should be assigned based on the importance of the threat towards contributing towards wetland vulnerability, the severity of the threat’s anticipated impact in case it happens and the probability that it may happen.  This information could be derived from the country-level data forms and time-series analysis of the threat/drivers/pressures datasets."
                "<h2>Sensitivity (state of the wetland)</h2>"
                "Sensitivity is characterised by internal factors to the wetland. Measures the capacity of the wetland to use its mechanisms to deal with the threat. That’s to say, incase the threat happens, the wetland has built its own capacity to deal with the impacts of the threat to some extent."
                "<h2>Resilience (external factors) </h2>"
                "Measures the additional external measures for enhancing the wetland to overcome the impacts of a threat.Usually external factors  to the wetland e.g-response factors such as policy framework, Governance and interventions etc. "
                "measurable by EO datasets."
                "<style>"
                "table, th, td {"
                "border: 2px solid black;"
                "border-collapse: collapse;"
                "}"
                "th, td {"
                "padding: 5px;"
                "text-align: left;"
                "}"
                "</style>"
                "\n\n "
                "<table>"
                "<tr>"
                "<th><h3>Vulnerability Variables</h3></th>"
                "<th><h3>EO Dataset Inputs</h3></th>"
                "</tr>"
                "<tr>"
                "<td><b>Climate change</b></td>"
                "<td>Drought--NDVI/SPI</td>"
                "</tr>"
                "<tr>"
                "<td><b>Urbanization and settlements</b></td>"
                "<td>Normalized difference Built-up index-NDBI</td>"
                "</tr>"
                "<tr>"
                "<td><b>Soil erosion and sedimentation</b></td>"
                "<td>Land degredation</td>"
                "</tr>"
                "<tr>"
                "<td><b>Land Use</b></td>"
                "<td>Agricultural land use</td>"
                "</tr>"
                "<tr>"
                "<td><b>Wetland Seasonality</b></td>"
                "<td>Modified Normalized Difference Water Index (MNDWI)</td>"
                "</tr>"
                "<tr>"
                "<td><b>Wetland Ecosystem </b></td>"
                "<td>Ecosystem services</td>"
                "</tr>"
                "<tr>"
                "<td><b>Wetland habitat cover and state</b></td>"
                "<td>Normalized Difference Vegetation Index (NDVI)</td>"
                "</tr>"
                "<tr>"
                "<td><b>wetland extent Versus response factors such as wetland management plans, governance, policies </b></td>"
                "<td>innudation or Weland extent</td>"
                "</tr>"
                "</table>"
                       )

    def initAlgorithm(self, config):
        self.addParameter(
            QgsProcessingParameterRasterLayer(
                'Population',
                'Exposure: Population',
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                #'population',
                self.populationweight,
                'Population Weight',
                type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=30.0
            )
        )

        self.addParameter(
            QgsProcessingParameterRasterLayer(
                'Landcover',
                'Exposure: Land Cover',
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                #'landcover',
                self.landcoverweight,
                'Land Cover Weight',
                type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=20.0
            )
        )

        self.addParameter(QgsProcessingParameterRasterLayer(
            'NDBI',
            'Exposure: NDBI',
            defaultValue=None
            )
        )

        self.addParameter(QgsProcessingParameterNumber(
            #'normalizeddifferencebuiltupindex',
            self.ndbiweight,
            'NDBI Weight',
            type=QgsProcessingParameterNumber.Double,
            minValue=0.0,
            maxValue=100,
            defaultValue=20.0
            )
        )

        self.addParameter(
            QgsProcessingParameterRasterLayer(
                'Degredation', 
                'Exposure: Degredation',
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                #'degredation',
                self.degradationweight,
                'Degredation Weight',
                type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=30.0
            )
        )

        self.addParameter(
            QgsProcessingParameterRasterLayer(
                'Ecosystem',
                'Sensitivity: Ecosystem',
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                #'ecosystem',
                self.ecosystemweight,
                'Ecosystem Weight',
                type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=30.0
            )
        )


        self.addParameter(
            QgsProcessingParameterRasterLayer(
                'MNDWI',
                'Sensitivity: MNDWI',
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                #'mndwiweight',
                self.mndwiweight,
                'MNDWI Weight',
                type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=30.0
            )
        )

        self.addParameter(
            QgsProcessingParameterRasterLayer(
                'NDVI',
                'Sensitivity: NDVI',
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                #'ndviweight',
                self.ndviweight,
                'NDVI Weight',
                type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=40.0
            )
        )

        self.addParameter(
            QgsProcessingParameterRasterLayer(
                'Inundation',
                'Resilience: Inundation',
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                #'Inundationweight',
                self.inundationweight,
                'Inundation Weight',
                type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=100.0
            )
        )

        exposure_field_param = QgsProcessingParameterNumber(
            #'exposuredomainweight',
            self.exposuredomainweight,
            'Exposure Domain Weight',
            type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=40.0
        )
        exposure_field_param.setFlags(
            exposure_field_param.flags() | QgsProcessingParameterDefinition.FlagAdvanced
        )
        self.addParameter(
            exposure_field_param
        )

        resilience_field_param = QgsProcessingParameterNumber(
            #'resiliencedomainweight',
            self.resiliencedomainweight,
            'Resilience Domain Weight',
            type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=40.0
        )
        resilience_field_param.setFlags(
            resilience_field_param.flags() | QgsProcessingParameterDefinition.FlagAdvanced
        )
        self.addParameter(
            resilience_field_param
        )

        sensitivity_field_param = QgsProcessingParameterNumber(
            #'sensitivitydomainweight',
            self.sensitivitydomainweight,
            'Sensitivity Domain Weight',
            type=QgsProcessingParameterNumber.Double,
                minValue=0.0,
                maxValue=100,
                defaultValue=20.0
        )
        sensitivity_field_param.setFlags(
            sensitivity_field_param.flags() | QgsProcessingParameterDefinition.FlagAdvanced
        )
        self.addParameter(
            sensitivity_field_param
        )

        self.addParameter(
            QgsProcessingParameterRasterDestination(
                'Exposure',
                'Exposure',
                createByDefault=True,
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterRasterDestination(
                'Sensitivity',
                'Sensitivity',
                createByDefault=True,
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterRasterDestination(
                'Resilience',
                'Resilience',
                createByDefault=True,
                defaultValue=None
            )
        )

        self.addParameter(
            QgsProcessingParameterRasterDestination(
                'WetlandVulnerabilityIndex',
                'Wetland Vulnerability Index',
                createByDefault=True,
                defaultValue=None
            )
        )

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model 

        degradation_weight = self.parameterAsDouble(
            parameters, 
            self.degradationweight,
            context
        )
        
        ecosystem_weight = self.parameterAsDouble(
            parameters, 
            self.ecosystemweight,
            context
        )

        landcover_weight = self.parameterAsDouble(
            parameters, 
            self.landcoverweight,
            context
        )

        population_weight  = self.parameterAsDouble(
            parameters, 
            self.populationweight,
            context
        )

        ndbi_weight  = self.parameterAsDouble(
            parameters, 
            self.ndbiweight,
            context
        )

        mndwi_weight  = self.parameterAsDouble(
            parameters, 
            self.mndwiweight,
            context
        )

        ndvi_weight  = self.parameterAsDouble(
            parameters, 
            self.ndviweight,
            context
        )

        inundation_weight  = self.parameterAsDouble(
            parameters, 
            self.inundationweight,
            context
        )

        exposure_domainweight  = self.parameterAsDouble(
            parameters, 
            self.exposuredomainweight,
            context
        )

        resilience_domainweight  = self.parameterAsDouble(
            parameters, 
            self.resiliencedomainweight,
            context
        )

        sensitivity_domainweight  = self.parameterAsDouble(
            parameters, 
            self.sensitivitydomainweight,
            context
        )



        feedback = QgsProcessingMultiStepFeedback(4, model_feedback)
        results = {}
        outputs = {}

        # Compute Resilience
        alg_params = {
            'BAND_A': 1,
            'BAND_B': None,
            'BAND_C': None,
            'BAND_D': None,
            'BAND_E': None,
            'BAND_F': None,
            'EXTRA': '',
            'FORMULA': QgsExpression(' \'(A*\'||'+str(inundation_weight)+'||\')\'').evaluate(),
            'INPUT_A': parameters['Inundation'],
            'INPUT_B': None,
            'INPUT_C': None,
            'INPUT_D': None,
            'INPUT_E': None,
            'INPUT_F': None,
            'NO_DATA': None,
            'OPTIONS': '',
            'RTYPE': 0,
            'OUTPUT': parameters['Resilience']
        }
        outputs['ComputeResilience'] = processing.run('gdal:rastercalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Resilience'] = outputs['ComputeResilience']['OUTPUT']

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Compute Sensitivity
        alg_params = {
            'BAND_A': 1,
            'BAND_B': 1,
            'BAND_C': 1,
            'BAND_D': None,
            'BAND_E': None,
            'BAND_F': None,
            'EXTRA': '',
            'FORMULA': QgsExpression(' \'(A*\'||'+str(ecosystem_weight)+'||\')\'||\'+\'||\'(B*\'||'+str(mndwi_weight)+'||\')\'||\'+\'||\'(C*\'||'+str(ndvi_weight)+'||\')\'').evaluate(),
            'INPUT_A': parameters['Ecosystem'],
            'INPUT_B': parameters['MNDWI'],
            'INPUT_C': parameters['NDVI'],
            'INPUT_D': None,
            'INPUT_E': None,
            'INPUT_F': None,
            'NO_DATA': None,
            'OPTIONS': '',
            'RTYPE': 0,
            'OUTPUT': parameters['Sensitivity']
        }
        outputs['ComputeSensitivity'] = processing.run('gdal:rastercalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Sensitivity'] = outputs['ComputeSensitivity']['OUTPUT']

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Compute Exposure
        alg_params = {
            'BAND_A': 1,
            'BAND_B': 1,
            'BAND_C': 1,
            'BAND_D': 1,
            'BAND_E': None,
            'BAND_F': None,
            'EXTRA': '',
            'FORMULA': QgsExpression(' \'(A*\'||'+str(population_weight)+'||\')\'||\'+\'||\'(B*\'||'+str(landcover_weight)+'||\')\'||\'+\'||\'(C*\'||'+str(ndbi_weight)+'||\')\'||\'+\'||\'(D*\'||'+str(degradation_weight)+'||\')\'').evaluate(),
            'INPUT_A': parameters['Population'],
            'INPUT_B': parameters['Landcover'],
            'INPUT_C': parameters['NDBI'],
            'INPUT_D': parameters['Degredation'],
            'INPUT_E': None,
            'INPUT_F': None,
            'NO_DATA': None,
            'OPTIONS': '',
            'RTYPE': 0,
            'OUTPUT': parameters['Exposure']
        }
        outputs['ComputeExposure'] = processing.run('gdal:rastercalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Exposure'] = outputs['ComputeExposure']['OUTPUT']

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}


        # Set Exposure layer style
        # exposure_style_path = os.path.join(os.path.dirname(__file__), 'styles/exposure.qml')
        # alg_params = {
        #     'INPUT': outputs['ComputeExposure']['OUTPUT'],
        #     'STYLE': exposure_style_path
        # }
        # outputs['SetExposureLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        # feedback.setCurrentStep(4)
        # if feedback.isCanceled():
        #     return {}

        # Set Sensitivity layer style
        # sensitivity_style_path = os.path.join(os.path.dirname(__file__), 'styles/resilience.qml')
        # alg_params = {
        #     'INPUT': outputs['ComputeSensitivity']['OUTPUT'],
        #     'STYLE': sensitivity_style_path
        # }
        # outputs['SetSensitivityLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # feedback.setCurrentStep(5)
        # if feedback.isCanceled():
        #     return {}

        # Set Resilience layer style
        # resilience_style_path = os.path.join(os.path.dirname(__file__), 'styles/exposure.qml')
        # alg_params = {
        #     'INPUT': outputs['ComputeResilience']['OUTPUT'],
        #     'STYLE': resilience_style_path
        # }
        # outputs['SetResilienceLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        # ComputeWetlandVulnerability
        alg_params = {
            'BAND_A': 1,
            'BAND_B': 1,
            'BAND_C': 1,
            'BAND_D': None,
            'BAND_E': None,
            'BAND_F': None,
            'EXTRA': '',
            'FORMULA': QgsExpression(' \'(A*\'||'+str(exposure_domainweight)+'||\')\'||\'+\'||\'(B*\'||'+str(sensitivity_domainweight)+'||\')\'||\'+\'||\'(C*\'||'+str(resilience_domainweight)+'||\')\'').evaluate(),
            'INPUT_A': outputs['ComputeExposure']['OUTPUT'],
            'INPUT_B': outputs['ComputeSensitivity']['OUTPUT'],
            'INPUT_C': outputs['ComputeResilience']['OUTPUT'],
            'INPUT_D': None,
            'INPUT_E': None,
            'INPUT_F': None,
            'NO_DATA': None,
            'OPTIONS': '',
            'RTYPE': 0,
            'OUTPUT': 'WetlandVulnerabilityTemp'
        }
        outputs['ComputeWetlandVulnerability'] = processing.run('gdal:rastercalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        #results['WetlandVulnerabilityIndex'] = outputs['ComputeWetlandVulnerability']['OUTPUT']
        WetlandVulnerabilityraster = gdal.Open(outputs['ComputeWetlandVulnerability']['OUTPUT'])
        WetlandVulnerabilityband = WetlandVulnerabilityraster.GetRasterBand(1)
        WetlandVulnerabilityband.GetMetadata()
        if WetlandVulnerabilityband.GetMinimum() is None or WetlandVulnerabilityband.GetMaximum() is None:
            WetlandVulnerabilityband.ComputeStatistics(0)
        WetlandVulnerabilityband.GetMetadata()
        WetlandVulnerability_max = WetlandVulnerabilityband.GetMaximum()
        WetlandVulnerability_min = WetlandVulnerabilityband.GetMinimum()

        print("[ MAX ] =", WetlandVulnerability_max)
        print("[ MIN ] =", WetlandVulnerability_min)

        #ComputeNormalizedWetlandVulnerabilityIndex
        alg_params = {
            'BAND_A': 1,
            'BAND_B': None,
            'BAND_C': None,
            'BAND_D': None,
            'BAND_E': None,
            'BAND_F': None,
            'EXTRA': '',
            'FORMULA': QgsExpression(' \'(A-\'|| '+str(WetlandVulnerability_min)+'||\')\'||\'/\'||\'(\'||'+str(WetlandVulnerability_max)+'||\'-\'||'+str(WetlandVulnerability_min)+'||\')\'').evaluate(),
            'INPUT_A': outputs['ComputeWetlandVulnerability']['OUTPUT'],
            'INPUT_B': None,
            'INPUT_C': None,
            'INPUT_D': None,
            'INPUT_E': None,
            'INPUT_F': None,
            'NO_DATA': None,
            'OPTIONS': '',
            'RTYPE': 0,
            'OUTPUT': parameters['WetlandVulnerabilityIndex']
        }
        outputs['ComputeNormalizedWetlandVulnerabilityIndex'] = processing.run('gdal:rastercalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['WetlandVulnerabilityIndex'] = outputs['ComputeNormalizedWetlandVulnerabilityIndex']['OUTPUT']


        # Set layer style
        wvi_style_path = os.path.join(os.path.dirname(__file__), 'styles/wetland_vulnerability_index.qml')
        alg_params = {
            'INPUT': outputs['ComputeNormalizedWetlandVulnerabilityIndex']['OUTPUT'],
            'STYLE': wvi_style_path
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context,
                                                  feedback=feedback, is_child_algorithm=True)

        return results

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'WetlandVulnerabilityAnalysisProcessing'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return 'Wetland Vulnerability Analysis Tool'#self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'ESIPPS'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return WetlandVulnerabilityAnalysisToolAlgorithm()
