"""
Model exported as python.
Name : WVA
Group : ESIPPS
With QGIS : 31201
"""

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsExpression
from qgis import processing
import os
import gdal

class WetlandVulnerabilityIndexAlgorithm(QgsProcessingAlgorithm):

    exposuredomainweight = 'exposuredomainweight'
    resiliencedomainweight = 'resiliencedomainweight'
    sensitivitydomainweight = 'sensitivitydomainweight'
    WetlandVulnerabilityTemp = 'WetlandVulnerabilityTemp'

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterRasterLayer('Exposure', 'Exposure', defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterLayer('Resilience', 'Resilience', defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterLayer('Sensitivity', 'Sensitivity', defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber(self.exposuredomainweight, 'Exposure Domain Weight', type=QgsProcessingParameterNumber.Double, minValue=0, maxValue=100.0, defaultValue=40.0))
        self.addParameter(QgsProcessingParameterNumber(self.resiliencedomainweight, 'Resilience Domain Weight', type=QgsProcessingParameterNumber.Double, minValue=0, maxValue=100.0, defaultValue=20.0))
        self.addParameter(QgsProcessingParameterNumber(self.sensitivitydomainweight, 'Sensitivity Domain Weight', type=QgsProcessingParameterNumber.Double, minValue=0, maxValue=100.0, defaultValue=40.0))
        self.addParameter(QgsProcessingParameterRasterDestination('WetlandVulnerabilityIndex', 'Wetland Vulnerability Index', createByDefault=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model

        exposure_domainweight  = self.parameterAsDouble(
            parameters, 
            self.exposuredomainweight,
            context
        )

        resilience_domainweight  = self.parameterAsDouble(
            parameters, 
            self.resiliencedomainweight,
            context
        )

        sensitivity_domainweight  = self.parameterAsDouble(
            parameters, 
            self.sensitivitydomainweight,
            context
        )

        feedback = QgsProcessingMultiStepFeedback(2, model_feedback)
        results = {}
        outputs = {}

        # Compute Wetland Vulnerability Index
        alg_params = {
            'BAND_A': 1,
            'BAND_B': 1,
            'BAND_C': 1,
            'BAND_D': None,
            'BAND_E': None,
            'BAND_F': None,
            'EXTRA': '',
            'FORMULA': QgsExpression(' \'(A*\'||'+str(exposure_domainweight)+'||\')\'||\'+\'||\'(B*\'||'+str(sensitivity_domainweight)+'||\')\'||\'+\'||\'(C*\'||'+str(resilience_domainweight)+'||\')\'').evaluate(),
            'INPUT_A': parameters['Exposure'],
            'INPUT_B': parameters['Sensitivity'],
            'INPUT_C': parameters['Resilience'],
            'INPUT_D': None,
            'INPUT_E': None,
            'INPUT_F': None,
            'NO_DATA': None,
            'OPTIONS': '',
            'RTYPE': 5,
            'OUTPUT': 'WetlandVulnerabilityTemp'
        }
        outputs['ComputeWetlandVulnerability'] = processing.run('gdal:rastercalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        WetlandVulnerabilityraster = gdal.Open(outputs['ComputeWetlandVulnerability']['OUTPUT'])
        WetlandVulnerabilityband = WetlandVulnerabilityraster.GetRasterBand(1)
        WetlandVulnerabilityband.GetMetadata()
        if WetlandVulnerabilityband.GetMinimum() is None or WetlandVulnerabilityband.GetMaximum() is None:
            WetlandVulnerabilityband.ComputeStatistics(0)
        WetlandVulnerabilityband.GetMetadata()
        WetlandVulnerability_max = WetlandVulnerabilityband.GetMaximum()
        WetlandVulnerability_min = WetlandVulnerabilityband.GetMinimum()

        # ComputeNormalizedWetlandVulnerabilityIndex
        alg_params = {
            'BAND_A': 1,
            'BAND_B': None,
            'BAND_C': None,
            'BAND_D': None,
            'BAND_E': None,
            'BAND_F': None,
            'EXTRA': '',
            'FORMULA': QgsExpression(' \'(A-\'|| '+str(WetlandVulnerability_min)+'||\')\'||\'/\'||\'(\'||'+str(WetlandVulnerability_max)+'||\'-\'||'+str(WetlandVulnerability_min)+'||\')\'').evaluate(),
            'INPUT_A': outputs['ComputeWetlandVulnerability']['OUTPUT'],
            'INPUT_B': None,
            'INPUT_C': None,
            'INPUT_D': None,
            'INPUT_E': None,
            'INPUT_F': None,
            'NO_DATA': None,
            'OPTIONS': '',
            'RTYPE': 5,
            'OUTPUT': parameters['WetlandVulnerabilityIndex']
        }
        outputs['ComputeNormalizedWetlandVulnerabilityIndex'] = processing.run('gdal:rastercalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['WetlandVulnerabilityIndex'] = outputs['ComputeNormalizedWetlandVulnerabilityIndex']['OUTPUT']


        # Set layer style
        wvi_style_path = os.path.join(os.path.dirname(__file__), 'styles/wetland_vulnerability_index.qml')
        alg_params = {
            'INPUT': outputs['ComputeNormalizedWetlandVulnerabilityIndex']['OUTPUT'],
            'STYLE': wvi_style_path
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context,
                                                  feedback=feedback, is_child_algorithm=True)
        return results

    def name(self):
        return 'WVA'

    def displayName(self):
        return 'Wetland Vulnerability Index'

    def group(self):
        return 'ESIPPS'

    def groupId(self):
        return 'ESIPPS'

    def createInstance(self):
        return WetlandVulnerabilityIndexAlgorithm()
