# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Config
                                 A QGIS plugin
 wide are mapping
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-11-13
        git sha              : $Format:%H$
        copyright            : (C) 2020 by forschung@ciss.de
        email                : forschung@ciss.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.core import QgsGeometry


class Config:
    """
    class which holds information about one configuration

    - a configuration does nothing
    - it holds the information only
    """

    def __init__(self, parameters: dict = None, name: str = "", qgis_layer=None, config_section=None):
        self._module_list = []  # holds the modules
        self._parameters = parameters  # holds the parameters
        self._name = name  # holds the configuration name
        self._config_section = config_section  # holds the whole section as an xml object
        self._qgis_layer = qgis_layer  # holds the qgis layer information
        self._layer_geom = QgsGeometry()

        first = True
        for f in qgis_layer.getFeatures():
            if first:
                self._layer_geom = f.geometry()
                first = False
            else:
                self._layer_geom = self._layer_geom.combine(f.geometry())

    def __str__(self):
        return "configuration: " + self._name + "\nparameters: " + str(self._parameters) + \
               "\nmodules:\n" + ',\n '.join(map(str, self._module_list))

    @property
    def qgis_layer(self):
        """
        returns the qgis layer
        """
        return self._qgis_layer

    @property
    def layer_geom(self):
        """
        returns the layer geom
        """
        return self._layer_geom

    @property
    def name(self) -> str:
        """
        returns the name of the config
        """
        return self._name

    @property
    def parameters(self) -> dict:
        """
        returns the parameters of the config
        """
        return self._parameters

    @property
    def config_section(self):
        """
        get the config section
        """
        return self._config_section

    @property
    def module_list(self) -> list:
        """
        returns the module list as 'list'
        """
        return self._module_list

    def add_module(self, module):
        """
        adds a module to the intern module list
        """
        self._module_list.append(module)

    def add_modules(self, modules: list):
        """
        adds a module to the intern module list
        """
        for module in modules:
            self._module_list.append(module)
