from PyQt5.QtGui import QColor


class COLOR:
    SHADOW_BASE_COLOR = QColor(0, 0, 0, 150)
    SHADOW_ERROR_COLOR = QColor(220, 81, 81)
    SHADOW_ALERT_COLOR = QColor(220, 218, 81)
    SHADOW_RANGE: int = 20

    BTN_BACK = QColor(81, 84, 145, 255)
    BTN_SELECTION = QColor(85, 170, 255, 255)


class WIDGET:
    FRAME_MENU_SELECTION = (
        """
        QFrame#OBJECTID { 
            padding-left: 2px; 
            border-left: 2px solid rgb(85, 224, 185); 
        }
        """
    )

    BUTTON_MENU = (
        """
    QPushButton {
        background-image: ICON_REPLACE;
        background-position: left center;
        background-repeat: no-repeat;
        border: none;
        border-left: 24px solid rgb(27, 29, 35);
        background-color: rgb(24, 29, 34);
        text-align: left;
        font: 75 12pt "Segoe UI";
        color: rgb(177, 181, 186);
        padding-left: 45px;
    }
    /*
    QPushButton[Active=true] {
        background-image: ICON_REPLACE;
        background-position: left center;
        background-repeat: no-repeat;
        border: none;
        border-left: 28px solid rgb(27, 29, 35);
        border-right: 5px solid rgb(44, 49, 60);
        background-color: rgb(27, 29, 35);
        text-align: left;
        padding-left: 45px;
    }
    */
    QPushButton:hover {
        background-color: rgb(33, 37, 43);
        border-left: 24px solid rgb(33, 37, 43);
    }
    QPushButton:pressed {
        background-color: rgb(61, 70, 86);
        border-left: 24px solid rgb(61, 70, 86);
    }
    """
    )

    BUTTON = (
        """
        QPushButton {
            border: 2px solid rgb(52, 59, 72);
            border-radius: 5px;	
            color: rgb(255, 255, 255);
            background-color: rgba(52, 59, 72, 255);
        }
        QPushButton:hover {
            background-color: rgb(57, 65, 80);
            border: 2px solid rgb(43, 49, 60);
        }
        QPushButton:pressed {	
            background-color: rgb(35, 40, 49);
            border: 2px solid rgb(43, 50, 61);
        }
        """
    )

    LINE_EDIT = """QLineEdit {
                    border: 2px solid rgb(58, 58, 90);
                    color:  rgb(255, 255, 255);
                    border-radius: 5px;
                    padding-left: 10px;
                }

                QLineEdit:hover{
                    border: 2px solid rgb(69, 69, 103)
                }
                """

    ABSTRACT_LIST_VIEW = """   
     QAbstractItemView {
        {BACK}
        {FONT}
        border: none;
        border-radius:10px;
        selection-background-color: rgb(85, 170, 255);
        selection-color: rgb(200, 200, 200);
     }
     
    QScrollBar:vertical
    {
        background-color: #2A2929;
        width: 15px;
        margin: 15px 3px 15px 3px;
        border: 1px transparent #2A2929;
        border-radius: 4px;
    }

    QScrollBar::handle:vertical
    {
        {HANDLE}
        min-height: 5px;
        border-radius: 4px;
    }

    QScrollBar::sub-line:vertical
    {
        margin: 3px 0px 3px 0px;
        background: none;
        height: 10px;
        width: 10px;
        subcontrol-position: top;
        subcontrol-origin: margin;
    }

    QScrollBar::add-line:vertical
    {
        margin: 3px 0px 3px 0px;
        border-image: url(:/qss_icons/rc/down_arrow_disabled.png);
        height: 10px;
        width: 10px;
        subcontrol-position: bottom;
        subcontrol-origin: margin;
    }

    QScrollBar::sub-line:vertical:hover,QScrollBar::sub-line:vertical:on
    {
        border-image: url(:/qss_icons/rc/up_arrow.png);
        height: 10px;
        width: 10px;
        subcontrol-position: top;
        subcontrol-origin: margin;
    }

    QScrollBar::add-line:vertical:hover, QScrollBar::add-line:vertical:on
    {
        border-image: url(:/qss_icons/rc/down_arrow.png);
        height: 10px;
        width: 10px;
        subcontrol-position: bottom;
        subcontrol-origin: margin;
    }

    QScrollBar::up-arrow:vertical, QScrollBar::down-arrow:vertical
    {
        background: none;
    }

    QScrollBar::add-page:vertical, QScrollBar::sub-page:vertical
    {
        background: none;
    }
            """
