# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Legend
                                 A QGIS plugin
 wide are mapping
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-11-13
        git sha              : $Format:%H$
        copyright            : (C) 2020 by forschung@ciss.de
        email                : forschung@ciss.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import weissflaechenkartierung.src.xml.xml_config_ctrl as xml
from weissflaechenkartierung.src.exceptions import LegendError


class Legend:
    def __init__(self, xml_section, module):
        """
        :param xml_section: section of an xml dom
        :param module: an module instance
        """
        self._xml_section = xml_section
        self._module = module
        self._parameters = xml.XMLConfigCtrl.get_parameter_from_xml(xml=self._xml_section)

    @property
    def parameters(self):
        """
        returns the parameters
        """
        return self._parameters

    @property
    def xml_section(self):
        """
        returns the xml section
        """
        return self._xml_section

    @property
    def module(self):
        """
        returns the module of the legend
        """
        return self._module

    def add_wfk_layer_to_map(self):
        out = []
        layer_name = "WFK"
        if "wfk_layer_name" in self._parameters:
            layer_name = self._parameters["wfk_layer_name"]
        self._module.wfk_layer.setName(layer_name)
        out.append(self._module.wfk_layer)
        return out

    def add_wfk_layer_to_map_param(self, wfk_layer):
        layer_name = "WFK"
        if "wfk_layer_name" in self._parameters:
            layer_name = self._parameters["wfk_layer_name"]
        wfk_layer.setName(layer_name)
        return wfk_layer

    def add_analyze_layer_to_map(self):
        out = []
        layer_name = "WFK (analyzed)"
        if "ana_layer_name" in self._parameters:
            layer_name = self._parameters["ana_layer_name"]
        self._module.analyze_layer.setName(layer_name)
        out.append(self._module.analyze_layer)
        return out

    def set_analyze_layer_name_param(self, analyzed_layer):
        layer_name = "WFK (analyzed)"
        if "wfk_ana_layer_name" in self._parameters:
            layer_name = self._parameters["wfk_ana_layer_name"]
        analyzed_layer.setName(layer_name)

    def set_blacklisted_layer_name(self, analyzed_blacklisted_layer):
        layer_name = "Blacklist (analyzed)"
        if "black_ana_layer_name" in self._parameters:
            layer_name = self._parameters["black_ana_layer_name"]
        analyzed_blacklisted_layer.setName(layer_name)

    def add_mod_layer_to_map(self):
        out = []

        if self._module.layer is None:
            raise LegendError("The layer of module: {" + self._module.name + "} is None")

        diff_layer_name = self._module.name
        show_diff_layer = False
        if "show_diff_layer" in self._parameters:
            show_diff_layer = xml.XMLConfigCtrl.get_bool_value(self._parameters["show_diff_layer"], False)
        if "diff_layer_name" in self._parameters:
            diff_layer_name = self._parameters["diff_layer_name"]
        if show_diff_layer and self._module.difference.diff_layer is not None:
            self._module.difference.diff_layer.setName(diff_layer_name)
            out.append(self._module.difference.diff_layer)

        layer_name = self._module.name
        show_layer = True
        if "layer_name" in self._parameters:
            layer_name = self._parameters["layer_name"]
        if "show_layer" in self._parameters:
            show_layer = xml.XMLConfigCtrl.get_bool_value(self._parameters["show_layer"], False)
        if show_layer and self._module.layer.layer is not None:
            self._module.layer.layer.setName(layer_name)
            out.append(self._module.layer.layer)
        return out
