# Weißflächenkartierung (WFK)

**Currently this plugin is only available in German. The plugin was tested on Windows 10 and macOS 12.**

If you have any questions, please contact us via [e-mail](mailto:forschung@ciss.de) or visit our [homepage](https://www.ciss.de).

## Abstract

**English:**

This plugin helps project planner to find potential areas for a wind plant. It provides a simple configurable approach to find potential areas by reviewing all limiting factors on a map. After the selection of a project area all of the following steps are carried out automatically: Loading of the relevant layers, buffering according to adjustable distance rules, and "punching out"/subtracting the buffered areas from the project area. The result is a map that shows the remaining potential areas immediately. For easy ordering of owner information of the remaining area, the plugin provides a simple export function to save the parcel numbers.
In addition, the plugin offers an easy integration of your exclusive special knowledge. Thus, on the one hand side you can easily monitor your knowledge on a map, and on the other hand side you can blacklist properties where you already know that the owner is against your project.
Furthermore, the tool provides an initial assessment of the remaining sites based on their distance to relevant infrastructure such as transformer stations.

Take a look at our [webinar](https://www.ciss.de/datenveredelung/werkzeuge/#wfk) (only in german) and our [presentation](https://pretalx.com/fossgis2022/talk/PHEDNN/) at FOSSGIS22.

**German:**

Das QGIS-Plug-in "WFK" von CISS TDI ist nach Installation über die reguläre QGIS-Werkzeugleiste aufrufbar und kann per einfachem Klick gestartet werden. Nach Auswahl eines Projektgebietes für welches die Weißflächenkartierung durchgeführt werden soll, werden alle folgenden Arbeitsschritte nach einmalig festgelegtem Ablaufplan automatisiert abgearbeitet: Laden der relevanten Layer, Pufferbildung entsprechend eingestellter Abstandsregeln, „Ausstanzen“/Subtrahieren der gepufferten Ausschluss-Flächen vom Projektgebiet. Das Ergebnis ist eine Kartendarstellung, welche auf einen Blick mögliche Weißflächen aufzeigt, die wiederum die Grundlage für weitere Planungen und Analysen bilden. Zur einfachen Bestellung von Eigentümerinformationen der relevanten Weißflächen bietet das Plugin eine einfache Export-Funktion von Flurstücksnummern und Umringen. Zudem bietet das Plugin eine einfach Integration Ihres exklusiven Spezialwissens, das Sie zu bereits betrachteten Grundstücken gesammelt haben. So können Sie beispielsweise bestimmte Grundstücke von der Weißflächenkartierung ausschließen und halten durch die Visualisierung und Direktanzeige von QGIS auch über dieses Spezialwissen stets den Überblick. Eine erste Bewertung der gefundenen Weißflächen anhand eines bestimmten Kriteriums (z.B. Abstand zum nächsten Umspannwerk, ....) ist ebenfalls möglich, um so eine weitere Entscheidungsebene zu erzeugen.

Mehr Informationen in dem zugehörigen [Webinar](https://www.ciss.de/datenveredelung/werkzeuge/#wfk) und unserer [Präsentation](https://pretalx.com/fossgis2022/talk/PHEDNN/) auf der FOSSGIS22.

## Installation

Das Plguin kann über das [Code-Repository](https://git.osgeo.org/gitea/CISSTDI/weissflaechenkartierung) heruntergeladen oder über die [Pluginverwaltung](https://docs.qgis.org/2.14/de/docs/user_manual/plugins/plugins.html) von QGIS direkt installiert werden. Ein [Demoprojekt](https://git.osgeo.org/gitea/CISSTDI/weissflaechenkartierung/archive/master.zip) ist ebenfalls im Code-Repository zu finden.

### Installation über das Coderepository

```shell
git clone https://git.osgeo.org/gitea/CISSTDI/weissflaechenkartierung.git
make dist
```

Im Anschluss muss das Plugin aus `dist/weissflaechenkartierung-xxx.zip` über [QGIS installiert](https://docs.qgis.org/3.22/en/docs/user_manual/plugins/plugins.html#the-install-from-zip-tab) werden.

## Oberfläche

Nach Installation und Auswahl des [Demoprojekts](https://git.osgeo.org/gitea/CISSTDI/weissflaechenkartierung/archive/master.zip):

![Oberfläche des Plugins](res/ui_picture.PNG)

## Konfiguration

Eine Konfigurations-Datei kann aus mehreren Konfigurationen bestehen. Diese können vor dem Start der Weißflächenkartierung über die Oberfläche ausgewählt werden. Eine Konfiguration enthält bestimmte Module. Ein Modul steuert die Ausschneide- oder Analyse Funktion fuer einen Datensatz. Die Module werden der Reihe nach abgearbeitet.

```xml
<!-- Umfasst alle Konfigurationen -->
<configs type="file">
    <!-- Beispiel Konfiguration -->
    <config name="Konfigurationsname">
        <!-- Globale Parameter -->
        <parameter key="default_crs" value="EPSG:32632"/>
        <parameter key="default_buffer" value="5"/>

        <modules>
        .
        .
        .
</configs>
```

Ein Modul wird mit bestimmten Klassen beschrieben. Einmal muss angegeben werden woher die zuverschneidenden Daten herkommen, des Weiteren muss angegeben werden, was der Datensatz behinhaltet. In dem unten stehenden Beispiel wird ein öffentlich zugänglicher Datensatz verwendet. Dieser beinhaltet das Shape Format.

```xml
<!-- Ein Modul steuert die Ausschneide- oder Analyse Funktion fuer einen Datensatz -->
<module name="Lanschaftsschutzgebiete">
    <!-- Wo liegt der Datensatz?! -->
    <connector type="RemoteFileConnector">
        <parameter key="path" value="https://www.opengeodata.nrw.de/produkte/umwelt_klima/naturschutz/linfos/Landschaftsschutzgebiete_EPSG25832_Shape.zip"/>
        <parameter key="zipped" value="true"/>
        <parameter key="zip_sub_path" value="vw_lsgpolygonproved.shp"/>
    </connector>
    <layer type="ShapeLayer"/>
    .
    .
    .
</module>
```

Wenn die zuverwendenden Daten lokal vorliegen, kann statt dem **RemoteFileConnector** ein **LocalFileConnector** verwendet werden.

```xml
<connector type="LocalFileConnector" >
    <parameter key="path" value="../custom_layer/custom_layer.shp"/>
</connector>
```

Um zu steuern, wie ein Datensatz ausgestanzt werden soll muss eine **difference** Klasse ausgewählt werden.

```xml
<difference type="BufferDifference">
    <parameter key="buffer" value="100"/>
</difference>
```

Des weiteren kann noch eine **SelectiveBufferDifference**-Klasse ausgwählt werden.

```xml
<difference type="SelectiveBufferDifference">
    <parameter key="selector" value="Objektart"/>
    <parameter key="type_list" value="__items__">
        .
        .
        .
    </parameter>
    <parameter key="buffer_list" value="__items__">
        .
        .
        .
    </parameter>
</difference>
```

Damit der resultierende Layer angezeigt werden kann, muss angegeben werden wie dieser aussehen soll.

``` xml
<legend>
    <parameter key="layer_name" value="Layer-Name"/>
    <parameter key="show_layer" value="ja"/>
</legend>
```

Bei **difference** Klassen kann der Input-Layer und Output-Layer wie im folgenden angegeben werden.

``` xml
<legend>
    <parameter key="layer_name" value="Input-Layer-Name"/>
    <parameter key="show_layer" value="ja"/>
    <parameter key="diff_layer_name" value="Output-Layer-Name"/>
    <parameter key="show_diff_layer" value="ja"/>
</legend>
```

Wenn zum Beispiel bekannt ist, dass bestimmte Flächen oder Gebiete im Vorhinein nicht zur Verfügung stehen, möchte man diese vielleicht ausschließen. Dies ist mittels **BlackListing** der Flächen möglich.

``` xml
<module name="Blacklisting">
    <connector type="LocalFileConnector">
        <parameter key="path" value="..\datei\mit\Geometrien.shp"/>
    </connector>
    <layer type="ShapeLayer"/>
    <difference type="BlacklistingDifference">
        <parameter key="path" value="pfad\zu\einer\datei\mit\angegeben\Gebieten.csv"/>
        <parameter key="position_selector" value="Schlüssel-der-Gemometrien"/>
        <parameter key="csv_selector" value="Spaltenname-in-der-CSV-der-Schlüssel"/>
        <parameter key="csv_black_list_selector" value="Spaltenname-in-der-CSV-des-Blacklistings"/> <!-- Wert der Zelle 1 oder 0 -->
        <parameter key="save_blacklisted_layer" value="true"/>
    </difference>
</module>
```

Weitere Informationen erhalten Sie in unserem Webinar oder auf Anfrage.

## Lizenz

[GPL](https://www.gnu.de/documents/gpl-2.0.de.html)
