"""
/***************************************************************************
 MessageBoxWindow

 wide are mapping
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-01-01
        git sha              : $Format:%H$
        copyright            : (C) 2022 by forschung@ciss.de
        email                : forschung@ciss.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from enum import Enum

from PyQt5 import QtCore
from PyQt5.QtGui import QCursor
from weissflaechenkartierung.ui.base.WndBase import BaseMainDialog
from weissflaechenkartierung.src.WndFunctions import WindowFunctions
from weissflaechenkartierung.ui.MessageBoxInterface import Ui_Form
from weissflaechenkartierung.res.styles import COLOR


class MESSAGE_BOX_STATE(Enum):
    ERROR = "Error"
    INFO = "Information"
    WARNING = "Warnung"
    IMPORTANT = "Wichtige Meldung"


class MessageBoxWindow(BaseMainDialog):
    def __init__(self, parent=None):
        self.ui = Ui_Form()
        super(MessageBoxWindow, self).__init__(dlg=self,
                                               parent=parent,
                                               save_last_pos=False,
                                               shadow=True,
                                               resize=True,
                                               move_window=True)

        self.resize_to_middle_of_parent()

        self._WindowFunctions = WindowFunctions(self)

        # signals and slots
        self.ui.btn_minimize.clicked.connect(lambda: self.setWindowState(QtCore.Qt.WindowMinimized))
        self.ui.btn_exit.clicked.connect(self.close)
        self.ui.btn_ok.clicked.connect(self.ok_clicked)

        self._txt: str = ""
        self._state: MESSAGE_BOX_STATE = MESSAGE_BOX_STATE.INFO

        self.ui.btn_minimize.hide()     # hide the minimize button

    def closeEvent(self, event):
        self._set_ui_to_std()
        self.resize_to_middle_of_parent()

    def _set_ui_to_std(self):
        """
        sets the ui input to standard
        """
        self.shadow.setColor(COLOR.SHADOW_BASE_COLOR)
        self.ui.label_info_kind.setText("")
        self.ui.plainTextEdit_info_txt.setPlainText("")

    def ok_clicked(self):
        """
        set ui to std
        """
        self.close()

    @property
    def txt(self):
        """
        returns the txt
        """
        return self._txt

    def set_txt(self, p_text: str, p_state: MESSAGE_BOX_STATE) -> None:
        """
        sets the text of the information field
        """
        self._txt = p_text
        self._state = p_state

        self._update()

    def _update(self):
        self.ui.label_info_kind.setText(self._state.value)
        self.ui.plainTextEdit_info_txt.appendHtml(self._txt)

        if self._state == MESSAGE_BOX_STATE.IMPORTANT:
            self.shadow.setColor(COLOR.SHADOW_ALERT_COLOR)
        if self._state == MESSAGE_BOX_STATE.ERROR:
            self.shadow.setColor(COLOR.SHADOW_ERROR_COLOR)
        if self._state == MESSAGE_BOX_STATE.WARNING:
            self.shadow.setColor(COLOR.SHADOW_ALERT_COLOR)
