# -*- coding: utf-8 -*-
"""
/***************************************************************************
 RunResult
                                 A QGIS plugin
 wide are mapping
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-11-13
        git sha              : $Format:%H$
        copyright            : (C) 2020 by forschung@ciss.de
        email                : forschung@ciss.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import time


class RunResult:
    """
    holds all information about the module run
    """

    def __init__(self):
        self._start_time: float = time.time()
        self._end_time = None
        self._run_result = None     # could be anything

    def __str__(self):
        return "started: " + self.get_time_formatted(self._start_time) + \
               "\nended: " + self.get_time_formatted(self._end_time) + "\nrun_result: " + str(self._run_result) + \
               "elapsed time: " + str(self.get_elapsed_time())

    @property
    def start_time(self) -> float:
        """
        returns the start time
        """
        return self._start_time

    @start_time.setter
    def start_time(self, value):
        """
        returns the start time
        """
        self._start_time = value

    @property
    def end_time(self) -> float:
        """
        returns the end time
        """
        return self._end_time

    @end_time.setter
    def end_time(self, value: float = 0.0):
        """
        sets the end time
        """
        if value == 0.0:
            self._end_time = time.time()
        else:
            self._end_time = value

    @property
    def run_result(self):
        """
        returns the run result
        """
        return self._run_result

    @run_result.setter
    def run_result(self, value):
        """
        sets the run result
        """
        self._run_result = value

    def get_elapsed_time(self) -> float:
        """
        returns the elapsed time
        """
        if self._end_time is None:
            self._end_time = time.time()
        return self._end_time - self._start_time

    def get_time_formatted(self, elapsed_time: float = 0.0, formatter: str = "%m/%d/%Y-%H:%M:%S") -> str:
        """
        returns the elapsed time formatted
        """
        if elapsed_time == 0.0:
            elapsed_time = self.get_elapsed_time()

        return time.strftime(formatter, time.gmtime(elapsed_time))
