# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MessageBoxDlg
                                 A QGIS plugin
 wide are mapping
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-11-13
        git sha              : $Format:%H$
        copyright            : (C) 2020 by forschung@ciss.de
        email                : forschung@ciss.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtGui import QColor
from qgis.PyQt.QtWidgets import QGraphicsDropShadowEffect, QSizeGrip
from qgis.PyQt import QtWidgets, QtCore
from qgis.PyQt.QtCore import Qt

from .ui_styles import Style
from .message_box_gui import Ui_MainWindow


class MsgMode:
    error = 0
    successfully = 1


class MessageBoxDlg(QtWidgets.QMainWindow):
    def __init__(self, parent: QtWidgets.QMainWindow, mode: MsgMode, txt: str = ""):
        super(MessageBoxDlg, self).__init__()

        # initialize
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)

        # center window relative to parent
        self.move(parent.frameGeometry().center() - self.frameGeometry().center())

        # activate the window
        self.activateWindow()

        # mode
        self._mode = mode

        # wnd pos
        self.dragPos = 0

        # shadow
        self.shadow = QGraphicsDropShadowEffect(self)
        self.shadow.setBlurRadius(20)
        self.shadow.setXOffset(0)
        self.shadow.setYOffset(0)
        self.shadow.setColor(QColor(0, 0, 0, 150))
        self.ui.msg_main_frame.setGraphicsEffect(self.shadow)

        # shadow props
        self.setWindowFlags(QtCore.Qt.FramelessWindowHint)
        self.setAttribute(QtCore.Qt.WA_TranslucentBackground)

        # grip
        self.sizegrip = QSizeGrip(self.ui.msg_size_grip_frame)
        self.sizegrip.setStyleSheet("width: 20px; height: 20px; margin 0px; padding: 0px;")

        # bind events
        self.ui.btn_msg_apply.clicked.connect(self.applied_clicked)
        self.ui.btn_msg_exit.clicked.connect(self.close)
        self.ui.msg_top_frame_title.mouseMoveEvent = self.move_window

        if txt == "":
            self.ui.plainTextEdit_result.deleteLater()
            self.setMinimumHeight(200)
            self.setMaximumHeight(200)
        else:
            self.ui.plainTextEdit_result.setPlainText(txt)

        if self._mode == MsgMode.error:
            self.ui.btn_msg_apply.setStyleSheet(Style.style_btn_error)
            self.ui.label_msg_info.setText("Fehler")
            self.ui.label_msg_window_name.setText("Fehlerhaft")
        elif self._mode == MsgMode.successfully:
            self.ui.btn_msg_apply.setStyleSheet(Style.style_btn_standard)
            self.ui.label_msg_info.setText("Info")
            self.ui.label_msg_window_name.setText("Information")

        self.show()

    def resizeEvent(self, event):
        event.accept()

    def mousePressEvent(self, event):
        self.dragPos = event.globalPos()

    def move_window(self, event):
        if event.buttons() == Qt.LeftButton:
            self.move(self.pos() + event.globalPos() - self.dragPos)
            self.dragPos = event.globalPos()
            event.accept()

    def closeEvent(self, event):
        event.accept()

    def applied_clicked(self):
        self.close()
