# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Connector
                                 A QGIS plugin
 wide are mapping
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-11-13
        git sha              : $Format:%H$
        copyright            : (C) 2020 by forschung@ciss.de
        email                : forschung@ciss.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import zipfile
import urllib.request as ulr_req

from abc import ABC, abstractmethod
import weissflaechenkartierung.wfk_sources.xml_config_ctrl as xml_ctrl
from qgis._core import QgsMessageLog, Qgis


class Connector(ABC):
    def __init__(self, xml_section, module):
        """
        :param xml_section: section of an xml dom
        :param module: an module instance
        """
        self._xml_section = xml_section
        self._module = module
        self._connection = None
        self._parameters = xml_ctrl.XMLConfigCtrl.get_parameter_from_xml(xml=self._xml_section)
        self._temp_zip_file = "temp.zip"

    @property
    def temp_zip_file(self):
        """
        returns the path of the temp zip file
        """
        return self._temp_zip_file

    @temp_zip_file.setter
    def temp_zip_file(self, value):
        """
        sets the path of the temp zip file
        """
        self._temp_zip_file = value

    @property
    def connection(self) -> str:
        """
        returns the connection of the connector
        """
        return self._connection

    @connection.setter
    def connection(self, value):
        """
        sets the connection string
        """
        self._connection = value

    @property
    def xml_section(self):
        """
        returns the xml section
        """
        return self._xml_section

    @abstractmethod
    def retrieve_data(self):
        """
        abstract method for inheritance
        """
        pass


class LocalFileConnector(Connector):
    """
    """
    def __init__(self, xml_section, module):
        Connector.__init__(self, xml_section=xml_section, module=module)

    def retrieve_data(self):
        path = self._parameters["path"]
        if path is None:
            QgsMessageLog.logMessage(message="LocalFileContainer:retrieve_data: the path out of the xml file is none!",
                                     level=Qgis.Critical)
            return
        temp = ""
        if "default_temp_folder" in self._module.config.parameters:
            temp = self._module.config.parameters["default_temp_folder"]

        if not os.path.isabs(path):
            path = temp + "/" + path

        if "temp" in self._parameters:
            if os.path.isabs(self._parameters["temp"]):
                temp = self._parameters["temp"]
            else:
                temp += "/" + self._parameters["temp"]
        self._retrieve_data(path, temp)

    def _retrieve_data(self, path: str, temp: str):
        if not os.path.isfile(path):
            QgsMessageLog.logMessage(message="LocalFileContainer:_retrieve_data: the path is not a file: " + path,
                                     level=Qgis.Critical)
            return
        self._connection = path

        zipped = False
        if "zipped" in self._parameters:
            zipped: bool = xml_ctrl.XMLConfigCtrl.get_bool_value(self._parameters["zipped"], False)
        if zipped:
            sub_path = ""
            if "zip_sub_path" in self._parameters:
                sub_path = self._parameters["zip_sub_path"]
            # extract zip file
            with zipfile.ZipFile(path, 'r') as zip_ref:
                zip_ref.extractall(temp)
            self._connection = temp + "/" + sub_path


class RemoteFileConnector(LocalFileConnector):
    """
    """
    def __init__(self, xml_section, module):
        Connector.__init__(self, xml_section=xml_section, module=module)

    def retrieve_data(self):
        temp = ""
        try:
            if "path" not in self._parameters:
                # TODO: logging over qgis_interface
                QgsMessageLog.logMessage(message="RemoteFileConnector:retrieve_data: 'path' is not inside parameters",
                                         level=Qgis.Info)
                return

            if "file" in self._parameters:
                self._temp_zip_file = self._parameters["file"]

            path = self._parameters["path"]

            if "default_temp_folder" in self._module.config.parameters:
                temp += self._module.config.parameters["default_temp_folder"]

            if "temp" in self._parameters:
                if os.path.isabs(self._parameters["temp"]):
                    temp = self._parameters["temp"]
                else:
                    temp += "/" + self._parameters["temp"]

            if os.path.isfile(temp + "/" + self._temp_zip_file):
                print(temp + "/" + self._temp_zip_file + " ist im cache")
            else:
                os.makedirs(temp, exist_ok=True)
                ulr_req.urlretrieve(path, temp + "/" + self._temp_zip_file)
        except Exception as e:
            QgsMessageLog.logMessage(message="RemoteFileConnector:retrieve_data: exception - " + str(e),
                                     level=Qgis.Info)
        # TODO: doesnt matter what happens, this will be executed
        super()._retrieve_data(temp + "/" + self._temp_zip_file, temp)
