# -*- coding: utf-8 -*-
"""
/***************************************************************************
 wfkDialog
                                 A QGIS plugin
 wide are mapping
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-11-13
        git sha              : $Format:%H$
        copyright            : (C) 2020 by forschung@ciss.de
        email                : forschung@ciss.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import requests

from qgis.PyQt.QtWidgets import QGraphicsDropShadowEffect, QSizeGrip, QPushButton, QSizePolicy, QFileDialog
from qgis.core import Qgis, QgsMessageLog, QgsApplication, QgsVectorFileWriter, QgsCoordinateTransformContext
from qgis.PyQt.QtGui import QMovie, QColor, QFont
from qgis.PyQt import QtWidgets, QtCore
from qgis.PyQt.QtCore import QSettings, QSize, QPoint, Qt, QPropertyAnimation, QEasingCurve
from qgis.PyQt.Qt import QUrl, QDesktopServices

import weissflaechenkartierung.wfk_sources.xml_config_ctrl as xml_ctrl
import weissflaechenkartierung.wfk_sources.wfk_task as wfk
import weissflaechenkartierung.wfk_sources.analyze_task as analyze
import weissflaechenkartierung.wfk_sources.QGisTool as qgis_tool

from .ui_styles import Style
from .limbo_wfk_gui import Ui_MainWindow
from .message_box_dlg import MessageBoxDlg, MsgMode


class LimboWfkDlg(QtWidgets.QMainWindow):
    pages = {
        "btn_wfk": {
            "index": 0,
            "txt": "Kartierung",
            "icon": "url(:/cil-map.png)"
        },
        "btn_analyze": {
            "index": 1,
            "txt": "Analyse",
            "icon": "url(:/cil-magnifying-glass.png)"
        },
        "btn_settings": {
            "index": 2,
            "txt": "Export",
            "icon": "url(:/cil-settings.png)"
        }
    }
    web_urls = {
        "ciss_webshop": "https://shop.ciss.de/",
        "ciss_converter": "https://shop.ciss.de/d-xml-upload-formular.html"
    }

    def __init__(self, qgis_interface=None):
        super(LimboWfkDlg, self).__init__()

        ########################################################################
        # INITIALIZATION

        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)

        # qgis interface
        self.qgis_interface = qgis_interface

        self.settings = QSettings('wfk_tool', 'wfk_tool')
        self.resize(self.settings.value("last_size", QSize(510, 430)))
        self.move(self.settings.value("last_pos", QPoint(380, 230)))
        self.config_path: str = self.settings.value("cfg_path", "")

        # WINDOW position
        self.dragPos = 0

        self.last_window_size = QSize(750, 500)
        self.menu_count = 0

        # SHADOW
        self.shadow = QGraphicsDropShadowEffect(self)
        self.shadow.setBlurRadius(20)
        self.shadow.setXOffset(0)
        self.shadow.setYOffset(0)
        self.shadow.setColor(QColor(0, 0, 0, 150))
        self.ui.frame_main.setGraphicsEffect(self.shadow)

        # remove title bar
        self.setWindowFlags(QtCore.Qt.FramelessWindowHint)

        # RESIZE GRIP
        self.sizegrip = QSizeGrip(self.ui.frame_size_grip)
        self.sizegrip.setStyleSheet("width: 20px; height: 20px; margin 0px; padding: 0px;")
        self.setAttribute(QtCore.Qt.WA_TranslucentBackground)

        ########################################################################
        # MENU

        # toggle menu
        self.ui.btn_toggle.clicked.connect(lambda: self.toggle_menu(250, True))

        # create your own menu:
        # 1 - open QT Designer with limbo_wfk_gui.ui
        # 2 - add a new page to page widget
        # 3 - rebuild the ui with pyuic5
        # 4 - remove the last line of the new built ui.py
        # 5 - add a new dict entry to self.pages
        # 6 - call [add_new_btn_to_menu] method with corresponding parameters

        # CUSTOM MENUS
        self.add_new_btn_to_menu(obj_name="btn_wfk")
        self.add_new_btn_to_menu(obj_name="btn_analyze")
        self.add_new_btn_to_menu(obj_name="btn_settings")

        # set config path-edit
        if os.path.exists(self.config_path):
            self.ui.lineEdit_config_path.setText(os.path.split(self.config_path)[1])
            self.ui.lineEdit_config_path.setToolTip(self.config_path)
            self.change_menu(obj_name="btn_wfk")
        else:
            qgis_tool.QGisTool.show_message(caption="Warnung",
                                            txt="Es muss eine Konfigurationdatei angegeben werden!",
                                            lvl=Qgis.Warning,
                                            qgis_interface=self.qgis_interface)
            self.ui.lineEdit_config_path.setStyleSheet(Style.style_lineEdit_error)
            self.ui.lineEdit_config_path.setToolTip("Es muss eine Konfigurationsdatei hinterlegt werden!")

        ########################################################################
        # HANDLE EVENTS
        self.ui.frame_top_title.mouseMoveEvent = self.move_window
        self.ui.btn_exit.clicked.connect(self.close)
        self.ui.btn_start_wfk.clicked.connect(self.start_wfk_clicked)
        self.ui.btn_refresh.clicked.connect(self.refresh_clicked)
        self.ui.btn_analyze.clicked.connect(self.start_analyzing_clicked)
        self.ui.btn_search_config.clicked.connect(self.open_file_browser_clicked)
        self.ui.btn_alkis_data.clicked.connect(lambda:
                                               QDesktopServices.openUrl(QUrl(LimboWfkDlg.web_urls["ciss_webshop"]))
                                               )
        self.ui.btn_converter.clicked.connect(self.open_converter_clicked)
        self.ui.btn_export_layer.clicked.connect(self.open_export_layer_clicked)

        ########################################################################
        # SOME UI STUFF

        # current run state
        self.is_running_wfk: bool = False
        self.is_running_analyze: bool = False

        # global members
        self.wfk_qgis_task = None
        self.analyze_task = None
        self.analyze_info_list: list = []

        # set check box checked
        self.ui.checkBox_sir.setChecked(True)

        # initialize gif
        movie = QMovie(":/spinner.gif")
        self.ui.label_movie.setMovie(movie)
        movie.setScaledSize(self.ui.label_movie.size())
        movie.start()
        self.ui.label_movie.hide()

        # initialize combobox
        # if you want to use these:
        self.ui.cb_config_selection.setStyleSheet(Style.style_cb_standard)
        self.ui.cb_layer_selection.setStyleSheet(Style.style_cb_standard)
        # it is only necessary, if you built the .ui file and deleted the normal style of the cb

        # initialize progress bar
        self.ui.progressBar.setVisible(False)
        self.ui.progressBar.setValue(0)

        self.ui.progressBar_analyze.setVisible(False)
        self.ui.progressBar_analyze.setValue(0)

        # update layer list
        self.refresh_layer_list()

        # update config list
        self.refresh_config_list()

        # set analyze button disabled
        self.ui.btn_analyze.setEnabled(False)

    ########################################################################
    # Window Events

    @staticmethod
    def deselect_menu(get_style):
        deselect = get_style.replace("QPushButton { border-right: 7px solid rgb(44, 49, 60); }", "")
        return deselect

    @staticmethod
    def select_menu(get_style):
        select = get_style + "QPushButton { border-right: 7px solid rgb(44, 49, 60); }"
        return select

    def add_new_btn_to_menu(self, obj_name):
        """
        adds a dynamic button to the menu bar
        """
        new_btn_font = QFont()
        new_btn_font.setFamily(u"Segoe UI")
        new_button = QPushButton(str(self.menu_count), self)
        new_button.setObjectName(obj_name)

        new_button_sizePolicy = QSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed)
        new_button_sizePolicy.setHorizontalStretch(0)
        new_button_sizePolicy.setVerticalStretch(0)
        new_button_sizePolicy.setHeightForWidth(new_button.sizePolicy().hasHeightForWidth())

        new_button.setSizePolicy(new_button_sizePolicy)
        new_button.setMinimumSize(QSize(0, 70))
        new_button.setLayoutDirection(Qt.LeftToRight)
        new_button.setFont(new_btn_font)
        new_button.setStyleSheet(Style.style_btn_menu_standard.replace('ICON_REPLACE', self.pages[obj_name]["icon"]))
        new_button.setText(self.pages[obj_name]["txt"])
        new_button.setToolTip(self.pages[obj_name]["txt"])
        new_button.clicked.connect(self.menu_button_clicked)
        self.ui.layout_menus.addWidget(new_button)

    def toggle_menu(self, max_width, enable):
        if enable:
            # GET WIDTH
            width = self.ui.frame_left_menu.width()
            max_extend = max_width
            standard = 70

            # SET MAX WIDTH
            if width == 70:
                width_extended = max_extend
                self.ui.btn_toggle.setToolTip("Zuklappen")
            else:
                width_extended = standard
                self.ui.btn_toggle.setToolTip("Aufklappen")

            # ANIMATION
            self.animation = QPropertyAnimation(self.ui.frame_left_menu, b"minimumWidth")
            self.animation.setDuration(100)
            self.animation.setStartValue(width)
            self.animation.setEndValue(width_extended)
            self.animation.setEasingCurve(QEasingCurve.InOutQuart)
            self.animation.start()

    def resizeEvent(self, event):
        self.last_window_size = self.size()
        event.accept()

    def closeEvent(self, event):
        if self.is_running_wfk:
            self.stop_wfk()
        # Write window size and position to config file
        self.settings.setValue("last_size", self.size())
        self.settings.setValue("last_pos", self.pos())
        self.settings.setValue("cfg_path", self.config_path)
        event.accept()

    def move_window(self, event):
        if event.buttons() == Qt.LeftButton:
            self.move(self.pos() + event.globalPos() - self.dragPos)
            self.dragPos = event.globalPos()
            event.accept()

    def mousePressEvent(self, event):
        self.dragPos = event.globalPos()

    ########################################################################

    def menu_button_clicked(self):
        """
        called when the user serves trough the menu
        """
        btn_obj_name: str = self.sender().objectName()
        if btn_obj_name in LimboWfkDlg.pages:
            self.change_menu(obj_name=btn_obj_name)

    def set_orientation_label(self, orientation: str):
        """
        set the current orientation
        """
        self.ui.label_curr_page.setText('| ' + orientation.upper())

    def change_menu(self, obj_name: str):
        """
        changes the current selected menu
        """
        try:
            # reset all selections
            for w in self.ui.frame_left_menu.findChildren(QPushButton):
                w.setStyleSheet(self.deselect_menu(w.styleSheet()))

            # select the right one
            for w in self.ui.frame_left_menu.findChildren(QPushButton):
                if w.objectName() == obj_name:
                    w.setStyleSheet(self.select_menu(w.styleSheet()))
            # select the right index
            self.ui.pages_widget.setCurrentIndex(LimboWfkDlg.pages[obj_name]["index"])
            # set the right orientation
            self.set_orientation_label(orientation=LimboWfkDlg.pages[obj_name]["txt"])
        except KeyError:
            QgsMessageLog.logMessage(message="WfkDialog:change_menu: can not change the menu, the menu key does not "
                                             "exist",
                                     level=Qgis.Critical)

    def check_analyze_status(self) -> bool:
        # checks if the analyze task can be started
        if self.ui.cb_layer_selection.count() <= 0:
            QgsMessageLog.logMessage(message="WfkDialog:start_analyzing: there are no layer to analyze!",
                                     level=Qgis.Critical)
            return False

        if len(self.analyze_info_list) == 0:
            QgsMessageLog.logMessage(
                message="WfkDialog:start_analyzing: please start the wfk at first before analyzing",
                level=Qgis.Info)
            qgis_tool.QGisTool.show_message(caption="Information",
                                            txt="please start the wfk at first before analyzing!",
                                            lvl=Qgis.Info,
                                            qgis_interface=self.qgis_interface)
            return False
        return True

    # ################################
    # user interaction methods

    def start_wfk_clicked(self):
        # still running wkk
        if self.is_running_wfk:
            self.stop_wfk()
        else:
            self.start_wfk()

    def refresh_clicked(self):
        self.refresh_layer_list()
        self.refresh_config_list()

    def start_analyzing_clicked(self):
        self.start_analyzing()

    def open_export_layer_clicked(self):
        """
        export layer to shape
        """
        # get selected features
        layer = self.qgis_interface.activeLayer()
        if layer.selectedFeatureCount() == 0:
            layer_to_save = qgis_tool.QGisTool.clone_layer(input_layer=layer)
        else:
            layer_to_save = qgis_tool.QGisTool.clone_selected_layer(input_layer=layer)

        file_name = QFileDialog.getSaveFileName(self,
                                                'Export',
                                                os.path.dirname(os.path.realpath(__file__)),
                                                '*.shp')
        if file_name:
            if not file_name[0] == "" and not os.path.exists(file_name[0]):
                try:
                    new_file_path = file_name[0]
                    b_dir, f_name = os.path.split(new_file_path)
                    new_dir = b_dir + "/" + f_name[:f_name.rfind('.')]
                    if not os.path.exists(new_dir):
                        os.mkdir(new_dir)
                        new_file_path = new_dir + "/" + f_name

                    options = QgsVectorFileWriter.SaveVectorOptions()
                    options.driverName = "ESRI Shapefile"
                    QgsVectorFileWriter.writeAsVectorFormatV2(layer=layer_to_save,
                                                              fileName=new_file_path,
                                                              transformContext=QgsCoordinateTransformContext(),
                                                              options=options)
                    MessageBoxDlg(parent=self,
                                  mode=MsgMode.successfully,
                                  txt="Layer '" + str(layer.name()) + "' nach '" + new_file_path + "' exportiert")
                except Exception as e:
                    MessageBoxDlg(parent=self,
                                  mode=MsgMode.error,
                                  txt=str(repr(e)))
                    pass

    @staticmethod
    def open_converter_clicked():
        """
        opens converter webpage
        """
        # send specific user agent
        header = {
            "User-Agent": "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/34.0.1866.237 "
                          "Safari/537.36"
        }
        try:
            requests.Session().get(url=LimboWfkDlg.web_urls["ciss_webshop"],
                                   headers=header)
        except:
            # sometimes there is a proxy error. This will be fixed in further update.
            pass

        QDesktopServices.openUrl(QUrl(LimboWfkDlg.web_urls["ciss_converter"]))

    def open_file_browser_clicked(self):
        """
        open a file with QFileDialog
        """
        # look where the file browser should start
        start_path = os.path.dirname(os.path.realpath(__file__))
        if len(self.ui.lineEdit_config_path.text()) > 0:
            b_dir, f_name = os.path.split(self.ui.lineEdit_config_path.toolTip())
            start_path = b_dir

        # open the directory
        result = QFileDialog.getOpenFileName(self,
                                             'Open file',
                                             start_path,
                                             "Config files (*.cfg)")
        if not result[0] == "" and os.path.exists(result[0]):
            b_dir, f_name = os.path.split(result[0])
            self.ui.lineEdit_config_path.setText(f_name)
            self.ui.lineEdit_config_path.setToolTip(result[0])
            self.config_path = result[0]
            self.refresh_config_list()
            self.ui.lineEdit_config_path.setStyleSheet(Style.style_lineEdit_standard)
        else:
            if os.path.exists(self.config_path):
                self.ui.lineEdit_config_path.setToolTip(self.ui.lineEdit_config_path.toolTip())
                self.ui.lineEdit_config_path.setText(os.path.split(self.config_path)[1])

    ########################################################################

    # ###################################################################
    #

    def refresh_layer_list(self) -> None:
        """
        refreshes the layer combobox
        :return: none
        """
        self.ui.cb_layer_selection.clear()
        self.ui.cb_layer_selection.addItems(self.get_current_available_layers())

    def get_current_available_layers(self) -> list:
        """
        :return: a list with all available layers
        """
        return [layer.name() for layer in self.qgis_interface.mapCanvas().layers()]

    def refresh_config_list(self) -> None:
        """
        refreshes the config combobox
        :return: none
        """
        if os.path.exists(self.config_path):

            configs: list = xml_ctrl.XMLConfigCtrl(xml_path=self.config_path).get_configuration_sections()

            self.ui.cb_config_selection.clear()
            self.ui.cb_config_selection.addItems(configs)

            layer_text = self.ui.cb_layer_selection.currentText()
            for config in configs:
                if layer_text.lower() in config.lower():
                    index = self.ui.cb_config_selection.findText(layer_text, Qt.MatchContains)
                    self.ui.cb_config_selection.setCurrentIndex(index)

    def start_analyzing(self) -> bool:
        """
        starts the analyzing function

        :return: bool
        """
        if not self.check_analyze_status():
            return False

        # create the analyzing task
        self.analyze_task = analyze.AnalyzeTask(desc='analyze',
                                                analyze_run_info_list=self.analyze_info_list,
                                                parent_dlg=self
                                                )
        # start the task
        self.analyze_task.progressChanged.connect(
            lambda: self.set_task_progress(task=self.analyze_task,
                                           progressbar=self.ui.progressBar_analyze)
        )
        QgsApplication.taskManager().addTask(self.analyze_task)

        self.ui.btn_start_wfk.setEnabled(False)
        self.ui.btn_analyze.setEnabled(False)
        self.ui.btn_refresh.setEnabled(False)
        self.ui.label_movie.show()
        self.ui.progressBar_analyze.setVisible(True)
        self.is_running_analyze = True
        return True

    @staticmethod
    def set_task_progress(task, progressbar):
        if task is not None:
            progressbar.setValue(task.progress())

    def start_wfk(self) -> bool:
        """
        starts the wide area mapping

        :return: bool
        """
        if not os.path.exists(self.config_path):
            QgsMessageLog.logMessage(message="WfkDialog:start_wfk: the config path is "" or does not exist",
                                     level=Qgis.Critical)

            qgis_tool.QGisTool.show_message(caption="Error",
                                            txt="the config path is "" or does not exist",
                                            lvl=Qgis.Critical,
                                            qgis_interface=self.qgis_interface)

            self.change_menu(obj_name="btn_settings")
            return False

        if not self.ui.cb_config_selection.count() > self.ui.cb_config_selection.currentIndex() >= 0:
            QgsMessageLog.logMessage(message="WfkDialog:start_wfk: there is no configuration file please restart with "
                                             "needed!",
                                     level=Qgis.Critical)
            qgis_tool.QGisTool.show_message(caption="Error",
                                            txt="there is no configuration file please restart with needed!",
                                            lvl=Qgis.Critical,
                                            qgis_interface=self.qgis_interface)
            return False

        if not self.ui.cb_layer_selection.count() > self.ui.cb_layer_selection.currentIndex() >= 0:
            QgsMessageLog.logMessage(message="WfkDialog:start_wfk: there are no layer, please restart with "
                                             "needed!",
                                     level=Qgis.Critical)
            qgis_tool.QGisTool.show_message(caption="Error",
                                            txt="there are no layer, please restart with needed!",
                                            lvl=Qgis.Critical,
                                            qgis_interface=self.qgis_interface)
            return False

        save_intermediate_results = self.ui.checkBox_sir.isChecked()
        config_name = self.ui.cb_config_selection.currentText()

        try:
            layer_obj = self.qgis_interface.mapCanvas().layers()[self.ui.cb_layer_selection.currentIndex()]
        except:
            QgsMessageLog.logMessage(message="WfkDialog:start_wfk: Exception while getting the current layer!",
                                     level=Qgis.Critical)
            return False

        QgsMessageLog.logMessage(
            message="\n------------------------------------------------------ WfkDialog:start_wfk "
                    "------------------------------------------------------",
            level=Qgis.Info)
        QgsMessageLog.logMessage(message="sir= " + str(save_intermediate_results), level=Qgis.Info)
        QgsMessageLog.logMessage(message="config= " + str(config_name), level=Qgis.Info)
        QgsMessageLog.logMessage(message="initialize the qgis task...", level=Qgis.Info)

        self.wfk_qgis_task = wfk.WfkTask(desc='wfk',
                                         config_name=config_name,
                                         dlg=self,
                                         save_inter_results=save_intermediate_results,
                                         layer=layer_obj,
                                         config_path=self.config_path,
                                         qgis_interface=self.qgis_interface
                                         )
        self.wfk_qgis_task.progressChanged.connect(
            lambda: self.set_task_progress(task=self.wfk_qgis_task,
                                           progressbar=self.ui.progressBar)
        )
        QgsApplication.taskManager().addTask(self.wfk_qgis_task)

        self.ui.btn_start_wfk.setText("Stop")
        self.ui.btn_start_wfk.setToolTip("Weißflächenkartierung stoppen")
        self.is_running_wfk = True
        self.ui.btn_refresh.setEnabled(False)
        self.ui.btn_analyze.setEnabled(False)
        self.ui.progressBar.setVisible(True)
        self.ui.label_movie.show()

        return True

    def stop_wfk(self) -> bool:
        """
        stops the wide area mapping

        :return: bool
        """
        if self.wfk_qgis_task is not None:
            try:
                self.wfk_qgis_task.cancel()
                self.wfk_qgis_task = None
            except:
                pass
        self.ui.btn_start_wfk.setEnabled(True)
        self.ui.btn_start_wfk.setText("start")
        self.ui.progressBar.setVisible(False)
        self.ui.progressBar.setValue(0)
        self.ui.label_movie.hide()
        self.ui.btn_refresh.setEnabled(True)
        self.ui.btn_analyze.setEnabled(True)
        self.is_running_wfk = False
        return True
