# DTU Wind WAsP QGIS plugin

Creating good roughness and elevation maps is important for microscale flow modelling for wind resource and siting assessment. The Wind Atlas Analysis and Application Program (WAsP) is often used for this purpose and requires maps as inputs. This repository contains scripts for:

* downloading elevation data
* downloading landcover data
* Convert landcover polygons to roughness or landcover lines as required by WAsP
* Creating hand digitized landcover polygon maps
* Saving the elevation, roughness or landcover lines as WAsP .map/.gml files
* Saving the elevation and roughness lines as WEng .grd files

Video solutions for different work flows are available in [this playlist](https://panopto.dtu.dk/Panopto/Pages/Viewer.aspx?pid=027e510f-32e6-473d-b96c-b0d800dddc2e)

It contains [a general introduction to QGIS for WAsP applications](https://panopto.dtu.dk/Panopto/Pages/Viewer.aspx?id=53e8adad-a0b4-48bd-9abf-b0d800dbcce4) and some more specific video tutorials on the different workflows for which the scripts can be used and some pitfalls to be aware of when using these scripts.

### Specific tutorials
* [Importing an elevation map from the GWA warehousee](https://panopto.dtu.dk/Panopto/Pages/Viewer.aspx?id=82b218ab-0d5c-420f-84cf-b0d800da1306)
* [creating a hand-digitized landcover map using google earth satellite data](https://panopto.dtu.dk/Panopto/Pages/Viewer.aspx?id=75478119-b721-4826-ab48-b0d800dbcc66)
* [Import a landcover map from the CORINE database](https://panopto.dtu.dk/Panopto/Pages/Viewer.aspx?id=d46660c2-52e6-4ca5-bdfc-b0d800dbcbfb)

## Citation of this work
If you use this plugin, please use the CITATION.bib provided in this repository and the related DOI:

Floors, Rogier Ralph (2022). Using QGIS to create WAsP maps. Technical University of Denmark. Software. https://doi.org/10.11583/DTU.20495178

## Install 

This plugin can be installed from the QGIS plugin directory or using "install from zip file" in the QGIS plugin menu.

### Build zip file

It can be zipped up to a package by running the following command from the directory above this repository.
```bash
ln -s qgis-plugin wasp_scripts;zip -r wasp_scripts.zip wasp_scripts -x "wasp_scripts/.git/*";rm wasp_scripts
```
Note that this creates a temporary soft link to a folder called `wasp_scripts`, which is the name required in the QGIS plugin repository, because it origionally had that name, but the main repository on git is now called `qgis-plugin`.

## Datasets 

The scripts provide access to several database that are hosted on DTU servers. The following section describe how the files where processed to get them in the format that the plugin can use.

### GWA3 landcover data

The GWA data are based on the ESA-CCI 2015 landcover data with 300 m resolution. The full
file was downloaded from the website:
ftp://geo10.elie.ucl.ac.be/CCI/LandCover/ESACCI-LC-L4-LCCS-Map-300m-P1Y-2015-v2.0.7.zip

```bash
gdal_retile.py -co "COMPRESS=LZW" -ps 1080 1080 -targetDir tiles ESACCI-LC-L4-LCCS-Map-300m-P1Y-2015-v2.0.7.tif
```

Afterwards, we create a gpkg that contains the bounding boxes of all the tifs 
created above. These are then used to find intersecting tiles with the user specified polygon. These intersecting
tiles are downloaded to the user and clipped and reprojected to the specified clipping layer of the user.

A cloud optimized geotiff can be created using:
```bash
gdal_translate ESACCI-LC-L4-LCCS-Map-300m-P1Y-2015-v2.0.7.tif esa_cci_2015.tif -of COG  -co COMPRESS=LZW -co NUM_THREADS=16
```

### GWA3 elevation data

The GWA elevation are a combination of the [SRTM GL3 v003](www.doi.org/10.5067/MEaSUREs/SRTM/SRTMGL3.003) and the [Viewfinder](http://viewfinderpanoramas.org/) DEMs. More information about this blending can be found in the [GWA Paper](https://doi.org/10.1175/BAMS-D-21-0075.1). 

All tiles were downloaded and the data was exported to COG for use with this plugin.

### Worldcover data
The worldcover data is hosted on Copernicus servers and follows the same approach for the other landcover sources. 
An example script can be found here: https://esa-worldcover.org/en/data-access
Because the 10 m default resolution is making the whole work flow extremely slow the maps are first downsampled to 100 m resolution (default). A user can specify a resolution up to 50 m, but higher is not possible by design.

### CORINE 2018 Vector land cover data

The landcover data is rather big (8GB) and is in vector format, so it is not trivial to use the tiling approach that we used for the raster sources. A custom python API using geopandas was used to open a subset of the CORINE geopackage file, and clip the necessary parts. 
