"""
Moduł REST.
Umożliwia pobranie wektorowych danych przestrzennych.
"""

import os.path

from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QMenu, QToolBar

from qgis.gui import QgisInterface

from .waw_rest_dockwidget import WawRestDockWidget


class WawRest:
    """Klasa wtyczki."""

    def __init__(self, iface: QgisInterface):
        """Konstruktor.

        :param iface: Interfejs aplikacji umożliwiający jego modyfikację.
        """

        self.action = None
        self.iface = iface
        self.dockwidget = None

    def initGui(self, menu: QMenu, toolbar: QToolBar):
        """Tworzy okno wtyczki oraz akcję jego wywołania
        i osadza je w interfejsie QGISa."""

        self.dockwidget = WawRestDockWidget()
        self.iface.addDockWidget(Qt.DockWidgetArea.BottomDockWidgetArea, self.dockwidget)

        self.action = self.dockwidget.toggleViewAction()
        iconRest = os.path.join(os.path.dirname(__file__), 'img', 'bi_bi_layers_half.svg')
        self.action.setIcon(QIcon(iconRest))
        self.action.setText('Wczytaj dane przestrzenne')

        menu.addAction(self.action)
        toolbar.addAction(self.action)

    def unload(self):
        """Usuwa okno wtyczki z interfejsu QGISa."""

        self.iface.removeDockWidget(self.dockwidget)
