"""
Moduł EGiB.
Umożliwia pobranie danych o działkach ewidencyjnych i budynkach.
"""

import os.path

from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QMenu, QToolBar

from qgis.gui import QgisInterface

from .waw_egib_dockwidget import WawEgibDockWidget


class WawEgib:
    """Klasa wtyczki."""

    def __init__(self, iface: QgisInterface):
        """Konstruktor.

        :param iface: Interfejs aplikacji umożliwiający jego modyfikację.
        """

        self.action = None
        self.iface = iface
        self.dockwidget = None

    def initGui(self, menu: QMenu, toolbar: QToolBar):
        """Tworzy okno wtyczki oraz akcję jego wywołania
        i osadza je w interfejsie QGISa."""

        self.dockwidget = WawEgibDockWidget()
        self.iface.addDockWidget(Qt.DockWidgetArea.RightDockWidgetArea, self.dockwidget)

        self.action = self.dockwidget.toggleViewAction()
        iconEgib = os.path.join(os.path.dirname(__file__), 'img', 'egib.svg')
        self.action.setIcon(QIcon(iconEgib))
        self.action.setText('Działki i budynki')

        menu.addAction(self.action)
        toolbar.addAction(self.action)

    def unload(self):
        """Usuwa okno wtyczki z interfejsu QGISa."""

        self.iface.removeDockWidget(self.dockwidget)
