# -*- coding: utf-8 -*-
"""
/***************************************************************************
 WalkPotential
                                 A QGIS plugin
 A plugin to analyze pedestrian demand in cities.
                              -------------------
        begin                : 2025-10-13
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Mark Stosberg
        email                : mark@stosberg.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os.path
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import QgsApplication

from .walk_potential_provider import WalkPotentialProvider


class WalkPotentialPlugin:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # Initialize processing provider
        self.provider = None


    def initGui(self):
        """Initialize the plugin GUI."""
        # Register processing provider
        self.provider = WalkPotentialProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        """Removes the plugin from QGIS."""
        # Unregister processing provider
        if self.provider:
            QgsApplication.processingRegistry().removeProvider(self.provider)

