# -*- coding: utf-8 -*-
"""
/***************************************************************************
 WalkPotentialProvider
                                 A QGIS plugin
 Processing provider for walk potential analysis
                              -------------------
        begin                : 2025-10-13
        copyright            : (C) 2025 by Mark Stosberg
        email                : mark@stosberg.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsProcessingProvider

from .walk_potential_algorithm import WalkPotentialAlgorithm


class WalkPotentialProvider(QgsProcessingProvider):
    """
    Processing provider for Walk Potential algorithms.
    """

    def __init__(self):
        super().__init__()

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider.
        """
        return 'walkpotential'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.
        """
        return 'Walk Potential'

    def icon(self):
        """
        Returns an icon for the provider.
        """
        # You can return a custom icon here if you have one
        icon_path = os.path.join(os.path.dirname(__file__), 'icon.png')
        if os.path.exists(icon_path):
            return QIcon(icon_path)
        return QgsProcessingProvider.icon(self)

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(WalkPotentialAlgorithm())

    def longName(self):
        """
        Returns the longer version of the provider name.
        """
        return 'Walk Potential Analysis Tools'
