# -*- coding: utf-8 -*-
"""
/***************************************************************************
 VX
                                 A QGIS plugin
 Download data from WinCan VX
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-05-17
        copyright            : (C) 2019 by WinCan Poland
        email                : p.paziewski@wincan.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""
import sys
import os.path
from ctypes import cdll, windll
vx_assembly_path = os.environ["ProgramFiles(x86)"] + "\CDLAB\Assemblies"
sys.path.append(vx_assembly_path.rstrip())
windll.LoadLibrary(vx_assembly_path + "\libsodium.dll")

import clr
clr.AddReference("ZeroMQ")
clr.AddReference("CDLAB.WinCan.MQ")
clr.AddReference("CDLAB.WinCan.SDK.GIS")
clr.AddReference("CDLAB.WinCan.SDK.GIS.UI")
clr.AddReference("CDLAB.WinCan.Template")

# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load VX class from file VX.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    from .VX_integration import VX
    
    return VX(iface)
