# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Visualist
                                 A QGIS plugin
 Plugin for Crime Analysts
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-04-15
        copyright            : (C) 2019 by Quentin Rossy
        email                : quentin.rossy@unil.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Quentin Rossy'
__date__ = '2019-04-15'
__copyright__ = '(C) 2019 by Quentin Rossy'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon
from .PointsToProportional import PointsToProportional
from .PointsInPolygon import PointsInPolygon
from .PointsInGrid import PointsInGrid
from .PointsToLine import PointsToLine
from .PointsToSplitLine import PointsToSplitLine
from .PointsToNNCluster import PointsToNNCluster
from .PointsToEdge import PointsToEdge
from .EdgesToFlow import EdgesToFlow
from .Lisa import LocalIndicatorSpatialA
from .NearestNeighbourAnalysis import NearestNeighbourAnalysis
from .MeetingPoints import MeetingPointsAnalysis
from .DistanceAnalysis import DistanceAnalysis

class VisualistProvider(QgsProcessingProvider):

    def __init__(self):
        QgsProcessingProvider.__init__(self)
        self.algs = []

    def load(self):
        """In this method we add settings needed to configure our
        provider.
        """
        self.refreshAlgorithms()
        return True

    def icon(self):
        iconName = 'visualist.png'
        return QIcon(":/plugins/visualist/icons/" + iconName)

    def getAlgs(self):
        algs = [
                    PointsInPolygon(),
                    PointsToProportional(),
                    PointsInGrid(),
                    PointsToLine(),
                    PointsToEdge(),
                    EdgesToFlow(),
                    PointsToSplitLine(),
                    PointsToNNCluster(),
                    LocalIndicatorSpatialA(),
                    NearestNeighbourAnalysis(),
                    #DistanceAnalysis(), # TODO
                    #MeetingPointsAnalysis(), #Will be added in next version
                    ]

        return algs

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.algs = self.getAlgs()
        for alg in self.algs:
            self.addAlgorithm( alg )

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'visualist'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('Visualist')

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
