# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Visualist
                                 A QGIS plugin
 Plugin for Crime Analysts
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-04-15
        copyright            : (C) 2019 by Quentin Rossy
        email                : quentin.rossy@unil.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Quentin Rossy'
__date__ = '2019-04-15'
__copyright__ = '(C) 2019 by Quentin Rossy'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect
import yaml

from qgis.PyQt.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, Qt
from qgis.core import QgsProcessingAlgorithm, QgsApplication, QgsMessageLog, QgsSettings

from .visualist_provider import VisualistProvider
from . import resources

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)

        # for alg in QgsApplication.processingRegistry().algorithms():
        #     feedback.pushInfo("{}:{} --> {}".format(alg.provider().name(), alg.name(), alg.displayName()))

#Convenient function to debug
NAME = "Visualist"
log = lambda m: QgsMessageLog.logMessage(m, NAME)

class VisualistPlugin(object):

    def __init__(self, iface):
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        log('Locale: {}'.format(locale))
        log('Plugin directory: {}'.format(self.plugin_dir))
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'visualist_{}.qm'.format(locale))
        log('Translation file: {}'.format(locale_path))
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
                log('Translator added')

        #Store settings used by the plugin
        s = QgsSettings()
        s.setValue("visualist/homepage", "https://ipsac2.unil.ch/main/")

        yaml_path = os.path.join(
            self.plugin_dir,'visualist.yaml')
        yaml_stream = open(yaml_path, 'r')
        yaml_document = yaml.safe_load(yaml_stream)
        for helper in yaml_document:
            s.setValue("visualist/help/"+helper, yaml_document[helper])

        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = VisualistProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
