# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Visualist
                                 A QGIS plugin
 Plugin for Crime Analysts
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/

 Script modified from Victor Olaya plugin
                              -------------------
        begin                : 2019-04-15
        copyright            : (C) 2019 by Quentin Rossy
        email                : quentin.rossy@unil.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Quentin Rossy'
__date__ = '2019-04-23'
__copyright__ = '(C) 2019 by Quentin Rossy'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'# -*- coding: utf-8 -*-

from qgis.PyQt.QtGui import QIcon
from qgis.core import (QgsSettings)

from processing.algs.qgis.QgisAlgorithm import QgisAlgorithm

from .utils import renderers

class VisualistAlgorithm(QgisAlgorithm):

    def __init__(self):
        super().__init__()
        s = QgsSettings()
        self.settings = s.value("visualist/help/"+self.name())

    def icon(self):
        return QIcon(":/plugins/visualist/icons/" + self.settings['icon'])

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return self.settings['group']

    def displayName(self):
        return self.tr(self.settings['displayName'])

    def helpUrl(self):
        s = QgsSettings()
        url = s.value("visualist/homepage")+self.settings['helpUrl']
        return url

    def shortDescription(self):
        return self.settings['description']
