# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Visualist
                                 A QGIS plugin
 Plugin for Crime Analysts
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/

 Script modified from Victor Olaya plugin
                              -------------------
        begin                : 2019-04-15
        copyright            : (C) 2019 by Quentin Rossy
        email                : quentin.rossy@unil.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Quentin Rossy'
__date__ = '2019-04-15'
__copyright__ = '(C) 2019 by Quentin Rossy'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'# -*- coding: utf-8 -*-

from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QVariant

from qgis.core import (QgsGeometry,
                       QgsFeatureSink,
                       QgsFeatureRequest,
                       QgsFeature,
                       QgsField,
                       QgsProcessing,
                       QgsProcessingException,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterString,
                       QgsProcessingParameterField,
                       QgsProcessingParameterNumber,
                       QgsProcessingUtils,
                       QgsProcessingParameterDefinition,
                       QgsSettings)

from .utils import renderers
from .visualist_alg import VisualistAlgorithm

class PointsInPolygon(VisualistAlgorithm):
    dest_id = None  # Save a reference to the output layer id

    POLYGONS = 'POLYGONS'
    POINTS = 'POINTS'
    OUTPUT = 'OUTPUT'
    FIELD = 'FIELD'
    WEIGHT = 'WEIGHT'
    MULTIPLIER = 'MULTIPLIER'

    def __init__(self):
        super().__init__()

    def name(self):
        return 'choroplethmap'

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterFeatureSource(self.POLYGONS,
                                                              self.tr('Polygons'), [QgsProcessing.TypeVectorPolygon]))
        self.addParameter(QgsProcessingParameterFeatureSource(self.POINTS,
                                                              self.tr('Points'), [QgsProcessing.TypeVectorPoint]))

        weight_field = QgsProcessingParameterField(self.WEIGHT,
                                                      self.tr('Weight field'), parentLayerParameterName=self.POLYGONS,
                                                      optional=True)
        weight_field.setFlags(weight_field.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(weight_field)

        multiplier_field = QgsProcessingParameterNumber(self.MULTIPLIER,
                                                      self.tr('Multiplier (default is %)'),
                                                      optional=True,
                                                      defaultValue=100)
        multiplier_field.setFlags(multiplier_field.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(multiplier_field)

        count_field = QgsProcessingParameterString(self.FIELD, self.tr('Count field name'), defaultValue='NUMPOINTS')
        count_field.setFlags(count_field.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(count_field)

        self.addParameter(QgsProcessingParameterFeatureSink(self.OUTPUT, self.tr('Choropleth Map'), QgsProcessing.TypeVectorPolygon))

    def postProcessAlgorithm(self, context, feedback):
        """
        PostProcessing Tasks to define the Symbology
        """
        output = QgsProcessingUtils.mapLayerFromString(self.dest_id, context)
        r = renderers.MapRender(output)
        r.choropleth(self.field_name)

        return {self.OUTPUT: self.dest_id}

    def processAlgorithm(self, parameters, context, feedback):
        poly_source = self.parameterAsSource(parameters, self.POLYGONS, context)
        if poly_source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.POLYGONS))

        point_source = self.parameterAsSource(parameters, self.POINTS, context)
        if point_source is None:
            raise QgsProcessingException(self.invalidSourceError(parameters, self.POINTS))

        weight_field = self.parameterAsString(parameters, self.WEIGHT, context)
        weight_field_index = -1
        if weight_field:
            weight_field_index = poly_source.fields().lookupField(weight_field)

        multiplier = self.parameterAsDouble(parameters, self.MULTIPLIER, context)

        field_name = self.parameterAsString(parameters, self.FIELD, context)
        self.field_name = field_name
        if weight_field:
            self.field_name = field_name+'_WEIGHTED'

        fields = poly_source.fields()
        if fields.lookupField(field_name) < 0:
            fields.append(QgsField(field_name, QVariant.LongLong))
            if weight_field:
                fields.append(QgsField(field_name+'_WEIGHTED', QVariant.LongLong))
        field_index = fields.lookupField(field_name)

        (sink, self.dest_id) = self.parameterAsSink(parameters, self.OUTPUT, context,
                                               fields, poly_source.wkbType(), poly_source.sourceCrs(), QgsFeatureSink.RegeneratePrimaryKey)
        if sink is None:
            raise QgsProcessingException(self.invalidSinkError(parameters, self.OUTPUT))

        features = poly_source.getFeatures()
        total = 100.0 / poly_source.featureCount() if poly_source.featureCount() else 0
        for current, polygon_feature in enumerate(features):
            if feedback.isCanceled():
                break

            count = 0
            output_feature = QgsFeature()
            if polygon_feature.hasGeometry():
                geom = polygon_feature.geometry()
                engine = QgsGeometry.createGeometryEngine(geom.constGet())
                engine.prepareGeometry()
                count = 0
                request = QgsFeatureRequest().setFilterRect(geom.boundingBox()).setDestinationCrs(poly_source.sourceCrs(), context.transformContext())
                for point_feature in point_source.getFeatures(request):
                    if feedback.isCanceled():
                        break
                    if engine.contains(point_feature.geometry().constGet()):
                        count += 1
                output_feature.setGeometry(geom)
            attrs = polygon_feature.attributes()
            attrs.append(count)
            if weight_field_index >= 0:
                weight = polygon_feature[weight_field_index]
                if weight == None or weight == 0:
                    weighted_count = 0
                    feedback.pushInfo('Error with feature {} : no value for weight'.format(polygon_feature.id()))
                else:
                    try:
                        weighted_count = (count*multiplier)/float(weight)
                        attrs.append(weighted_count)
                    except:
                        feedback.pushInfo('Error with feature {} : {} is not a valid weight'.format(polygon_feature.id(), weight))

            output_feature.setAttributes(attrs)
            sink.addFeature(output_feature, QgsFeatureSink.FastInsert)

            feedback.setProgress(int(current * total))

        return {self.OUTPUT: self.dest_id}
