# -*- coding: utf-8 -*-
"""
/***************************************************************************
 VibrationControl
                                 A QGIS plugin
 Blaster Vibration Control
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-02-19
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Bruno S. Mosso
        email                : engbrunomosso@outlook.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QDialog
from qgis.core import *
from qgis.core import QgsProject
from qgis.PyQt.QtCore import QObject
from .processamento import *
from . import processamento
from PyQt5.QtWidgets import QTableWidgetItem
from PyQt5.QtGui import QDoubleValidator

# Initialize Qt resources from file resources.py
from .resources import *
from .vibration_control_dialog import VibrationControlDialog
import os.path
import processing
import sys, os
from osgeo import *
#from .regressao import calcular_lei_atenuacao
#from .import regressao
from .simulado import *
from .estado import resetar_estado_plugin
#from . import regressao_sci
from . import regressao_sci_linear






class VibrationControl():
    """QGIS Plugin Implementation."""
    
    #def chamar_processamento(self):
        #camada = self.camadaEscolhida()  # pega a camada escolhida no combo
        #executar_processamento(camada)   # chama a função do outro arquivo


    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        
        # Save reference to the QGIS interface
        self.iface = iface
        
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'VibrationControl_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Blaster Vibration Control')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('VibrationControl', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/vibration_control_main/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Blaster Vibration Control'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Blaster Vibration Control'),
                action)
            self.iface.removeToolBarIcon(action)

    
    

    """Preenche o combox com as layers vetoriais existentes no projeto"""
    def carregaComboBox(self, camada_escolhida=None, destino=None):
        
        #Coleta do que já foi selecionado no comboBox
        if camada_escolhida != None:
            selected_furos = self.dlg.comboBox_shpFuros.currentText()
            selected_geofones = self.dlg.comboBox_shpGeofones.currentText()
            selected_criticas = self.dlg.comboBox_shpZCriticas.currentText()
            selected_topo = self.dlg.comboBox_shpTopo.currentText()
            selected_furos_sim = self.dlg.comboBox_shpFuros_simular.currentText()
        
        
        #Limpeza das listas dos comboBox
        self.dlg.comboBox_shpFuros.clear()
        self.dlg.comboBox_shpGeofones.clear()
        self.dlg.comboBox_shpZCriticas.clear()
        self.dlg.comboBox_shpTopo.clear()
        self.dlg.comboBox_shpFuros_simular.clear()
        
        # Adiciona primeiro um item vazio
        self.dlg.comboBox_shpFuros.addItem("Selecione...")
        self.dlg.comboBox_shpGeofones.addItem("Selecione...")
        self.dlg.comboBox_shpZCriticas.addItem("Selecione...")
        self.dlg.comboBox_shpTopo.addItem("Selecione...")
        self.dlg.comboBox_shpFuros_simular.addItem("Selecione...")

        lista_layers = [layer.name() for layer in QgsProject.instance().mapLayers().values() if layer.type() == QgsMapLayer.VectorLayer]
        
        #add as camadas correntes nos comboBox
        self.dlg.comboBox_shpFuros.addItems(lista_layers)
        self.dlg.comboBox_shpGeofones.addItems(lista_layers)
        self.dlg.comboBox_shpZCriticas.addItems(lista_layers)
        self.dlg.comboBox_shpTopo.addItems(lista_layers)
        self.dlg.comboBox_shpFuros_simular.addItems(lista_layers)
               
        #Devolve as camadas que já foram selecionadas nos comboBox
        if camada_escolhida != None:
            if destino == "furos":
                self.dlg.comboBox_shpGeofones.setCurrentText(selected_geofones)
                self.dlg.comboBox_shpZCriticas.setCurrentText(selected_criticas)
                self.dlg.comboBox_shpTopo.setCurrentText(selected_topo)
                self.dlg.comboBox_shpFuros_simular.setCurrentText(selected_furos_sim)
            if destino == "geofones":
                self.dlg.comboBox_shpFuros.setCurrentText(selected_furos)
                self.dlg.comboBox_shpZCriticas.setCurrentText(selected_criticas)
                self.dlg.comboBox_shpTopo.setCurrentText(selected_topo)
                self.dlg.comboBox_shpFuros_simular.setCurrentText(selected_furos_sim)
            if destino == "zcriticas":
                self.dlg.comboBox_shpFuros.setCurrentText(selected_furos)
                self.dlg.comboBox_shpGeofones.setCurrentText(selected_geofones)
                self.dlg.comboBox_shpTopo.setCurrentText(selected_topo)
                self.dlg.comboBox_shpFuros_simular.setCurrentText(selected_furos_sim)
            if destino == "topo":
                self.dlg.comboBox_shpFuros.setCurrentText(selected_furos)
                self.dlg.comboBox_shpGeofones.setCurrentText(selected_geofones)
                self.dlg.comboBox_shpZCriticas.setCurrentText(selected_criticas)
                self.dlg.comboBox_shpFuros_simular.setCurrentText(selected_furos_sim)
            if destino == "furos_sim":
                self.dlg.comboBox_shpFuros.setCurrentText(selected_furos)
                self.dlg.comboBox_shpGeofones.setCurrentText(selected_geofones)
                self.dlg.comboBox_shpZCriticas.setCurrentText(selected_criticas)
                self.dlg.comboBox_shpTopo.setCurrentText(selected_topo)
                
                
                
        
        # Se uma camada foi passada e um destino foi especificado, definir como selecionada
        if camada_escolhida and camada_escolhida in lista_layers:
            if destino == "furos":
                self.dlg.comboBox_shpFuros.setCurrentText(camada_escolhida)
            if destino == "geofones":
                self.dlg.comboBox_shpGeofones.setCurrentText(camada_escolhida)
            if destino == "zcriticas":
                self.dlg.comboBox_shpZCriticas.setCurrentText(camada_escolhida)
            if destino == "topo":
                self.dlg.comboBox_shpTopo.setCurrentText(camada_escolhida)
            if destino == "furos_sim":
                self.dlg.comboBox_shpFuros_simular.setCurrentText(camada_escolhida)
                


    
    """abre a janela de dialógo para abrir uma layer a ser carregada"""
    def abrirVetor(self):
        sender_button = self.dlg.sender()  # Identifica qual botão chamou a função
        camada_abrir = str(QFileDialog.getOpenFileName(caption="Escolha a camada...", filter="Shapefiles (*.shp)")[0])
        #se camada_abrir não for vazio
        if (camada_abrir != ""):
            nome_camada = os.path.basename(camada_abrir).split(".")[0]
            self.iface.addVectorLayer(camada_abrir, nome_camada, "ogr")

            # Define qual comboBox deve ser atualizado
            if sender_button == self.dlg.toolButton_furos:
                self.carregaComboBox(nome_camada, "furos")
            if sender_button == self.dlg.toolButton_geofones:
                self.carregaComboBox(nome_camada, "geofones")
            if sender_button == self.dlg.toolButton_criticas:
                self.carregaComboBox(nome_camada, "zcriticas")
            if sender_button == self.dlg.toolButton_topo:
                self.carregaComboBox(nome_camada, "topo")
            if sender_button == self.dlg.toolButton_furos_simular:  
                self.carregaComboBox(nome_camada, "furos_sim")

    
    def ok(self):
        if not hasattr(self.dlg, "resultados_processados") or not self.dlg.resultados_processados:
            self.dlg.tabWidget.setCurrentIndex(1)  # Aba PROCESS
        else:
            self.dlg.tabWidget.setCurrentIndex(2)  # Aba Simulação

       
    #//-------------------------------//
    #//----------Execução-------------//
    #//-------------------------------//
    def run(self):
        """Run method that performs all the real work"""

        #Reinicia o plugin
        #resetar_estado_plugin(self)
        
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            #self.dlg = VibrationControlDialog()
        
        self.dlg = VibrationControlDialog()
        # show the dialog
        self.dlg.show()

        #Funções
        self.carregaComboBox()
        self.dlg.toolButton_furos.clicked.connect(self.abrirVetor)
        self.dlg.toolButton_geofones.clicked.connect(self.abrirVetor)
        self.dlg.toolButton_criticas.clicked.connect(self.abrirVetor)
        self.dlg.toolButton_topo.clicked.connect(self.abrirVetor)
        self.dlg.toolButton_furos_simular.clicked.connect(self.abrirVetor)
        self.dlg.pushButton_OK.clicked.connect(self.ok)
        
        
        
        self.dlg.pushButton_process.clicked.connect(lambda: processar_dados(self.iface, self.dlg))       
        self.dlg.pushButton_txt.clicked.connect(lambda: exportar_tabela_para_txt(self.dlg.resultados_processados))
        self.dlg.pushButton_imagem.clicked.connect(lambda: gerar_grafico(self.dlg.resultados_processados))
        self.dlg.pushButton_leiAtenuacao.clicked.connect(lambda: regressao_sci_linear.calcular_regressao(self.dlg))
        self.dlg.pushButton_interp_graf.clicked.connect(lambda: regressao_sci_linear.gerar_grafico_ajuste_ui(self.dlg))
        self.dlg.pushButton_simular.clicked.connect(lambda: executar_simulacao(self.dlg, self.iface))
        self.dlg.pushButton_intxt.clicked.connect(lambda: importar_resultados_excel(self.dlg))
        
        
        
        # Para capturar o valor de PPV(mm/s) entre linhas
        validator = QDoubleValidator(0.0, 999.99, 2)  # min, max, casas decimais
        validator.setNotation(QDoubleValidator.StandardNotation)
        self.dlg.lineEdit_iso.setValidator(validator)
    



        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
